/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.trace;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.internal.AbstractTraceForURIProvider;
import org.eclipse.xtext.idea.build.IdeaOutputConfigurationProvider;
import org.eclipse.xtext.idea.build.XtextAutoBuilderComponent;
import org.eclipse.xtext.idea.filesystem.IdeaProjectConfig;
import org.eclipse.xtext.idea.filesystem.IdeaProjectConfigProvider;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.idea.trace.IIdeaTrace;
import org.eclipse.xtext.idea.trace.ILocationInVirtualFile;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.idea.trace.VirtualFileBasedTrace;
import org.eclipse.xtext.idea.trace.VirtualFileInProject;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TraceForVirtualFileProvider
extends AbstractTraceForURIProvider<VirtualFileInProject, VirtualFileBasedTrace>
implements ITraceForVirtualFileProvider {
    @Inject
    private Provider<VirtualFileBasedTrace> traceProvider;

    @Override
    public List<? extends PsiElement> getGeneratedElements(PsiElement element) {
        VirtualFileInProject fileInProject = VirtualFileInProject.forPsiElement(element);
        if (fileInProject == null) {
            return CollectionLiterals.emptyList();
        }
        IIdeaTrace traceToTarget = this.getTraceToTarget(fileInProject);
        return this.getTracedElements(traceToTarget, element);
    }

    private List<PsiElement> getTracedElements(IIdeaTrace trace, PsiElement element) {
        if (trace == null) {
            return CollectionLiterals.emptyList();
        }
        TextRange range = element.getTextRange();
        int offset = element.getTextOffset();
        int _endOffset = range.getEndOffset();
        int _minus = _endOffset - offset;
        TextRegion region = new TextRegion(offset, _minus);
        Iterable targetLocations = trace.getAllAssociatedLocations((ITextRegion)region);
        final PsiManager mngr = element.getManager();
        Functions.Function1<ILocationInVirtualFile, Boolean> _function = new Functions.Function1<ILocationInVirtualFile, Boolean>(){

            public Boolean apply(ILocationInVirtualFile it) {
                ITextRegionWithLineInformation _textRegion = it.getTextRegion();
                int _length = _textRegion.getLength();
                return _length > 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)targetLocations, (Functions.Function1)_function);
        Functions.Function1<ILocationInVirtualFile, PsiElement> _function_1 = new Functions.Function1<ILocationInVirtualFile, PsiElement>(){

            public PsiElement apply(ILocationInVirtualFile it) {
                boolean _equals_1;
                int _textLength;
                boolean _equals;
                PsiElement _xblockexpression = null;
                VirtualFileInProject platformResource = (VirtualFileInProject)it.getPlatformResource();
                if (platformResource == null) {
                    return null;
                }
                VirtualFile targetFile = platformResource.getFile();
                ITextRegionWithLineInformation textRegion = it.getTextRegion();
                PsiFile _findFile = mngr.findFile(targetFile);
                PsiElement _findElementAt = null;
                if (_findFile != null) {
                    int _offset = textRegion.getOffset();
                    _findElementAt = _findFile.findElementAt(_offset);
                }
                PsiElement result = _findElementAt;
                boolean _or = false;
                _or = result == null ? true : (_equals = (_textLength = result.getTextLength()) == 0);
                if (_or) {
                    return null;
                }
                while (!result.getTextRange().containsRange(textRegion.getOffset(), textRegion.getOffset() + textRegion.getLength())) {
                    PsiElement _parent;
                    result = _parent = result.getParent();
                }
                int _textLength_1 = result.getTextLength();
                boolean bl = _equals_1 = _textLength_1 == 0;
                if (_equals_1) {
                    return null;
                }
                _xblockexpression = result;
                return _xblockexpression;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Set _set = IterableExtensions.toSet((Iterable)_filterNull);
        List result = IterableExtensions.toList((Iterable)_set);
        return result;
    }

    @Override
    public List<? extends PsiElement> getOriginalElements(PsiElement element) {
        VirtualFileInProject fileInProject = VirtualFileInProject.forPsiElement(element);
        if (fileInProject == null) {
            return CollectionLiterals.emptyList();
        }
        VirtualFileBasedTrace traceToSource = (VirtualFileBasedTrace)this.getTraceToSource(fileInProject);
        return this.getTracedElements(traceToSource, element);
    }

    protected VirtualFileInProject asFile(AbsoluteURI absoluteURI, IProjectConfig project) {
        URI _uRI = absoluteURI.getURI();
        VirtualFile file = VirtualFileURIUtil.getVirtualFile(_uRI);
        Module module = ((IdeaProjectConfig)project).getModule();
        Project ideaProject = module.getProject();
        return new VirtualFileInProject(file, ideaProject);
    }

    protected List<AbstractTraceForURIProvider.PersistedTrace> findInverseTraceFiles(VirtualFileInProject sourceFile) {
        Project ideaProject = sourceFile.getProject();
        XtextAutoBuilderComponent builder = (XtextAutoBuilderComponent)((Object)ideaProject.getComponent(XtextAutoBuilderComponent.class));
        if (builder == null) {
            return CollectionLiterals.newArrayList((Object[])new AbstractTraceForURIProvider.PersistedTrace[0]);
        }
        VirtualFile _file = sourceFile.getFile();
        URI _uRI = VirtualFileURIUtil.getURI(_file);
        Iterable<URI> generatedSources = builder.getGeneratedSources(_uRI);
        Functions.Function1<URI, VirtualFile> _function = new Functions.Function1<URI, VirtualFile>(){

            public VirtualFile apply(URI it) {
                return VirtualFileURIUtil.getVirtualFile(it);
            }
        };
        Iterable _map = IterableExtensions.map(generatedSources, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Functions.Function1<VirtualFile, Boolean> _function_1 = new Functions.Function1<VirtualFile, Boolean>(){

            public Boolean apply(VirtualFile it) {
                return TraceForVirtualFileProvider.this.isTraceFile(it);
            }
        };
        Iterable generatedTraces = IterableExtensions.filter((Iterable)_filterNull, (Functions.Function1)_function_1);
        Functions.Function1<VirtualFile, AbstractTraceForURIProvider.PersistedTrace> _function_2 = new Functions.Function1<VirtualFile, AbstractTraceForURIProvider.PersistedTrace>(){

            public AbstractTraceForURIProvider.PersistedTrace apply(VirtualFile it) {
                VirtualFilePersistedTrace _virtualFilePersistedTrace = new VirtualFilePersistedTrace(it, TraceForVirtualFileProvider.this);
                return _virtualFilePersistedTrace;
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)generatedTraces, (Functions.Function1)_function_2);
        List result = IterableExtensions.toList((Iterable)_map_1);
        return result;
    }

    public SourceRelativeURI getGeneratedUriForTrace(IProjectConfig projectConfig, AbsoluteURI absoluteSourceResource, AbsoluteURI generatedFileURI, ITraceURIConverter traceURIConverter) {
        boolean _exists;
        boolean _not;
        final Module module = ((IdeaProjectConfig)projectConfig).getModule();
        IResourceServiceProvider _serviceProvider = this.getServiceProvider(absoluteSourceResource);
        IdeaOutputConfigurationProvider outputConfigurationProvider = (IdeaOutputConfigurationProvider)_serviceProvider.get(IdeaOutputConfigurationProvider.class);
        Set<OutputConfiguration> outputConfigurations = outputConfigurationProvider.getOutputConfigurations(module);
        URI _uRI = absoluteSourceResource.getURI();
        ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(_uRI);
        if (sourceFolder == null) {
            return null;
        }
        OutputConfiguration _head = (OutputConfiguration)IterableExtensions.head(outputConfigurations);
        String _name = sourceFolder.getName();
        final String outputFolder = _head.getOutputDirectory(_name);
        Application _application = ApplicationManager.getApplication();
        Computable<VirtualFile> _function = new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile[] _contentRoots;
                boolean _isAbsolutePath = TraceForVirtualFileProvider.this.isAbsolutePath(outputFolder);
                if (_isAbsolutePath) {
                    VirtualFileManager _instance = VirtualFileManager.getInstance();
                    String _pathToUrl = VfsUtilCore.pathToUrl((String)outputFolder);
                    return _instance.findFileByUrl(_pathToUrl);
                }
                ModuleRootManager _instance_1 = ModuleRootManager.getInstance((Module)module);
                for (VirtualFile contentRoot : _contentRoots = _instance_1.getContentRoots()) {
                    boolean _notEquals;
                    VirtualFile result = contentRoot.findFileByRelativePath(outputFolder);
                    boolean bl = _notEquals = !Objects.equal((Object)result, null);
                    if (!_notEquals) continue;
                    return result;
                }
                return null;
            }
        };
        VirtualFile outputSourceFolder = (VirtualFile)_application.runReadAction((Computable)_function);
        boolean _or = false;
        _or = outputSourceFolder == null ? true : (_not = !(_exists = outputSourceFolder.exists()));
        if (_or) {
            SourceRelativeURI result = super.getGeneratedUriForTrace(projectConfig, absoluteSourceResource, generatedFileURI, traceURIConverter);
            return result;
        }
        URI sourceFolderURI = VirtualFileURIUtil.getURI(outputSourceFolder);
        SourceRelativeURI result_1 = generatedFileURI.deresolve(sourceFolderURI);
        return result_1;
    }

    private boolean isAbsolutePath(String path) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)path);
        if (_isNullOrEmpty) {
            return false;
        }
        char start = path.charAt(0);
        return start == File.pathSeparatorChar;
    }

    private boolean isTraceFile(VirtualFile file) {
        TraceFileNameProvider _traceFileNameProvider = this.getTraceFileNameProvider();
        String _name = file.getName();
        return _traceFileNameProvider.isTraceFileName(_name);
    }

    public IIdeaTrace getTraceToTarget(VirtualFileInProject sourceResource) {
        AbsoluteURI _absoluteLocation = this.getAbsoluteLocation(sourceResource);
        IdeaProjectConfig _projectConfig = this.getProjectConfig(sourceResource);
        return this.getTraceToTarget(sourceResource, _absoluteLocation, (IProjectConfig)_projectConfig);
    }

    protected AbstractTraceForURIProvider.PersistedTrace findPersistedTrace(VirtualFileInProject generatedFile) {
        VirtualFile virtualFile = generatedFile.getFile();
        VirtualFile traceFile = this.getTraceFile(virtualFile);
        return new VirtualFilePersistedTrace(traceFile, this);
    }

    protected AbsoluteURI getAbsoluteLocation(VirtualFileInProject file) {
        VirtualFile _file = file.getFile();
        return this.getAbsoluteLocation(_file);
    }

    protected AbsoluteURI getAbsoluteLocation(VirtualFile file) {
        URI _uRI = VirtualFileURIUtil.getURI(file);
        return new AbsoluteURI(_uRI);
    }

    protected IdeaProjectConfig getProjectConfig(VirtualFileInProject sourceFile) {
        Module module = sourceFile.getModule();
        if (module == null) {
            return null;
        }
        return new IdeaProjectConfig(module);
    }

    @Override
    public boolean isGenerated(VirtualFileInProject file) {
        AbstractTraceForURIProvider.PersistedTrace _findPersistedTrace = this.findPersistedTrace(file);
        return _findPersistedTrace.exists();
    }

    public VirtualFileBasedTrace getTraceToTarget(VirtualFileInProject sourceFile, AbsoluteURI absoluteSourceResource, IProjectConfig projectConfig) {
        VirtualFileBasedTrace result = (VirtualFileBasedTrace)super.getTraceToTarget((Object)sourceFile, absoluteSourceResource, projectConfig);
        if (result != null) {
            IResourceServiceProvider _serviceProvider = this.getServiceProvider(absoluteSourceResource);
            IdeaOutputConfigurationProvider outputConfigurationProvider = (IdeaOutputConfigurationProvider)_serviceProvider.get(IdeaOutputConfigurationProvider.class);
            IResourceServiceProvider _serviceProvider_1 = this.getServiceProvider(absoluteSourceResource);
            IdeaProjectConfigProvider projectConfigProvider = (IdeaProjectConfigProvider)_serviceProvider_1.get(IdeaProjectConfigProvider.class);
            result.setOutputConfigurationProvider(outputConfigurationProvider);
            result.setProjectConfigProvider(projectConfigProvider);
        }
        return result;
    }

    protected VirtualFileBasedTrace newAbstractTrace(VirtualFileInProject file) {
        VirtualFileBasedTrace result = (VirtualFileBasedTrace)this.traceProvider.get();
        result.setLocalStorage(file);
        JarFileSystem _instance = JarFileSystem.getInstance();
        VirtualFile _file = file.getFile();
        VirtualFile jarRoot = _instance.getRootByEntry(_file);
        if (jarRoot != null) {
            result.setJarRoot(jarRoot);
        } else {
            IdeaProjectConfig _projectConfig = this.getProjectConfig(file);
            result.setLocalProjectConfig(_projectConfig);
        }
        return result;
    }

    protected VirtualFile getTraceFile(VirtualFile generatedFile) {
        VirtualFile parent = generatedFile.getParent();
        if (parent == null) {
            return null;
        }
        TraceFileNameProvider _traceFileNameProvider = this.getTraceFileNameProvider();
        String _name = generatedFile.getName();
        String _traceFromJava = _traceFileNameProvider.getTraceFromJava(_name);
        VirtualFile result = parent.findChild(_traceFromJava);
        return result;
    }

    @FinalFieldsConstructor
    protected static class VirtualFilePersistedTrace
    implements AbstractTraceForURIProvider.PersistedTrace {
        private final VirtualFile file;
        private final TraceForVirtualFileProvider traceProvider;

        public AbsoluteURI getPath() {
            return this.traceProvider.getAbsoluteLocation(this.file);
        }

        public long getTimestamp() {
            return this.file.getModificationStamp();
        }

        public InputStream openStream() throws IOException {
            Application _application = ApplicationManager.getApplication();
            Computable<InputStream> _function = new Computable<InputStream>(){

                public InputStream compute() {
                    try {
                        byte[] _contentsToByteArray = VirtualFilePersistedTrace.this.file.contentsToByteArray();
                        return new ByteArrayInputStream(_contentsToByteArray);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            return (InputStream)_application.runReadAction((Computable)_function);
        }

        public boolean exists() {
            boolean _exists;
            boolean _and = false;
            _and = this.file == null ? false : (_exists = this.file.exists());
            return _and;
        }

        public VirtualFilePersistedTrace(VirtualFile file, TraceForVirtualFileProvider traceProvider) {
            this.file = file;
            this.traceProvider = traceProvider;
        }
    }
}

