/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.TypeLookupImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.FileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class RegisterGlobalsContextImpl
implements RegisterGlobalsContext {
    @Accessors
    private IJvmDeclaredTypeAcceptor acceptor;
    @Accessors
    private CompilationUnitImpl compilationUnit;

    public void registerAnnotationType(String qualifiedName) throws IllegalArgumentException {
        JvmAnnotationType newType = TypesFactory.eINSTANCE.createJvmAnnotationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerClass(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        EList _superTypes = newType.getSuperTypes();
        JvmTypeReference _typeForName = this.compilationUnit.getTypeReferences().getTypeForName(Object.class, (Notifier)this.compilationUnit.getXtendFile(), new JvmTypeReference[0]);
        _superTypes.add((Object)_typeForName);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerEnumerationType(String qualifiedName) throws IllegalArgumentException {
        JvmEnumerationType newType = TypesFactory.eINSTANCE.createJvmEnumerationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerInterface(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        newType.setInterface(true);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    private void setNameAndAccept(JvmDeclaredType newType, String qualifiedName) {
        boolean _tripleNotEquals;
        ConditionUtils.checkQualifiedName(qualifiedName, "qualifiedName");
        JvmDeclaredType _findType = this.findType(qualifiedName);
        boolean _tripleEquals = _findType == null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The type '");
        _builder.append(qualifiedName);
        _builder.append("' has already been registered.");
        Preconditions.checkArgument((boolean)_tripleEquals, (Object)_builder);
        this.compilationUnit.checkCanceled();
        Pair<String, String> namespaceAndName = this.getNameParts(qualifiedName);
        String headerText = this.compilationUnit.getFileHeaderProvider().getFileHeader(this.compilationUnit.getXtendFile().eResource());
        this.compilationUnit.getJvmTypesBuilder().setFileHeader(newType, headerText);
        String _key = (String)namespaceAndName.getKey();
        boolean bl = _tripleNotEquals = _key != null;
        if (_tripleNotEquals) {
            JvmDeclaredType parentType = this.findType((String)namespaceAndName.getKey());
            if (parentType != null) {
                EList _members = parentType.getMembers();
                _members.add((Object)newType);
                newType.setStatic(true);
            } else {
                newType.setPackageName((String)namespaceAndName.getKey());
                this.acceptor.accept(newType);
            }
        } else {
            this.acceptor.accept(newType);
        }
        newType.setSimpleName((String)namespaceAndName.getValue());
    }

    private JvmDeclaredType findType(String string) {
        return this.findRecursively(string, Iterables.filter((Iterable)this.compilationUnit.getXtendFile().eResource().getContents(), JvmDeclaredType.class));
    }

    private JvmDeclaredType findRecursively(String string, Iterable<? extends JvmDeclaredType> types) {
        for (JvmDeclaredType jvmDeclaredType : types) {
            JvmDeclaredType result;
            String candidateQualifiedName = jvmDeclaredType.getQualifiedName('.');
            boolean _equals = Objects.equal((Object)string, (Object)candidateQualifiedName);
            if (_equals) {
                return jvmDeclaredType;
            }
            boolean _startsWith = string.startsWith(candidateQualifiedName);
            if (!_startsWith || (result = this.findRecursively(string, Iterables.filter((Iterable)jvmDeclaredType.getMembers(), JvmDeclaredType.class))) == null) continue;
            return result;
        }
        return null;
    }

    private Pair<String, String> getNameParts(String string) {
        int index = string.lastIndexOf(46);
        if (index != -1) {
            String _substring = string.substring(0, index);
            String _substring_1 = string.substring(index + 1);
            return Pair.of((Object)_substring, (Object)_substring_1);
        }
        return Pair.of(null, (Object)string);
    }

    @Delegate
    public FileSystemSupport getFileSystemSupport() {
        return this.compilationUnit.getFileSystemSupport();
    }

    @Delegate
    public FileLocations getFileLocations() {
        return this.compilationUnit.getFileLocations();
    }

    @Delegate
    public TypeLookupImpl getTypeLookup() {
        return this.compilationUnit.getTypeLookup();
    }

    @Pure
    public IJvmDeclaredTypeAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(IJvmDeclaredTypeAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Pure
    public CompilationUnitImpl getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public Iterable<? extends Path> getChildren(Path arg0) {
        return this.getFileSystemSupport().getChildren(arg0);
    }

    public boolean exists(Path arg0) {
        return this.getFileSystemSupport().exists(arg0);
    }

    public boolean isFolder(Path arg0) {
        return this.getFileSystemSupport().isFolder(arg0);
    }

    public boolean isFile(Path arg0) {
        return this.getFileSystemSupport().isFile(arg0);
    }

    public long getLastModification(Path arg0) {
        return this.getFileSystemSupport().getLastModification(arg0);
    }

    public String getCharset(Path arg0) {
        return this.getFileSystemSupport().getCharset(arg0);
    }

    public CharSequence getContents(Path arg0) {
        return this.getFileSystemSupport().getContents(arg0);
    }

    public InputStream getContentsAsStream(Path arg0) {
        return this.getFileSystemSupport().getContentsAsStream(arg0);
    }

    public URI toURI(Path arg0) {
        return this.getFileSystemSupport().toURI(arg0);
    }

    public Path getSourceFolder(Path arg0) {
        return this.getFileLocations().getSourceFolder(arg0);
    }

    public Path getTargetFolder(Path arg0) {
        return this.getFileLocations().getTargetFolder(arg0);
    }

    public Path getProjectFolder(Path arg0) {
        return this.getFileLocations().getProjectFolder(arg0);
    }

    public Set<Path> getProjectSourceFolders(Path arg0) {
        return this.getFileLocations().getProjectSourceFolders(arg0);
    }

    public ClassDeclaration findSourceClass(String arg0) {
        return this.getTypeLookup().findSourceClass(arg0);
    }

    public InterfaceDeclaration findSourceInterface(String arg0) {
        return this.getTypeLookup().findSourceInterface(arg0);
    }

    public EnumerationTypeDeclaration findSourceEnumerationType(String arg0) {
        return this.getTypeLookup().findSourceEnumerationType(arg0);
    }

    public AnnotationTypeDeclaration findSourceAnnotationType(String arg0) {
        return this.getTypeLookup().findSourceAnnotationType(arg0);
    }

    public Type findUpstreamType(Class<?> arg0) {
        return this.getTypeLookup().findUpstreamType(arg0);
    }

    public Type findUpstreamType(String arg0) {
        return this.getTypeLookup().findUpstreamType(arg0);
    }
}

