/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XtendResourceDescription
extends DefaultResourceDescription {
    private static final Set<String> primitivesFilter = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"boolean", "int", "char", "byte", "short", "long", "double", "float", "void"}));
    private IBatchTypeResolver typeResolver;
    private IQualifiedNameConverter nameConverter;
    private Set<QualifiedName> importedNames;

    public XtendResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IBatchTypeResolver typeResolver, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.typeResolver = typeResolver;
        this.nameConverter = nameConverter;
    }

    protected EObjectDescriptionLookUp getLookUp() {
        if (this.lookup == null) {
            EObjectDescriptionLookUp _eObjectDescriptionLookUp;
            List _computeExportedObjects = this.computeExportedObjects();
            this.lookup = _eObjectDescriptionLookUp = new EObjectDescriptionLookUp(_computeExportedObjects);
        }
        return this.lookup;
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return Collections.emptyList();
    }

    public Iterable<QualifiedName> getImportedNames() {
        if (this.importedNames != null) {
            return this.importedNames;
        }
        HashSet result = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        EObject astRoot = (EObject)IterableExtensions.head((Iterable)this.getResource().getContents());
        if (astRoot != null) {
            IResolvedTypes types = this.typeResolver.resolveTypes(astRoot);
            Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)EcoreUtil.getAllContents((EObject)astRoot, (boolean)true)), XExpression.class);
            for (XExpression expression : _filter) {
                LightweightTypeReference typeRef;
                boolean _isTypeLiteral;
                boolean _matched = false;
                if (expression instanceof XMemberFeatureCall && ((XMemberFeatureCall)expression).getFeature() != null && ((XMemberFeatureCall)expression).getFeature().eIsProxy() && !((XMemberFeatureCall)expression).isExplicitOperationCallOrBuilderSyntax()) {
                    boolean _isTypeLiteral2;
                    _matched = true;
                    XExpression receiver = ((XMemberFeatureCall)expression).getActualReceiver();
                    if (receiver instanceof XAbstractFeatureCall && (_isTypeLiteral2 = ((XAbstractFeatureCall)receiver).isTypeLiteral())) {
                        JvmIdentifiableElement type = ((XAbstractFeatureCall)receiver).getFeature();
                        String _identifier = type.getIdentifier();
                        String _plus = String.valueOf(_identifier) + "$";
                        String _concreteSyntaxFeatureName = ((XMemberFeatureCall)expression).getConcreteSyntaxFeatureName();
                        String _plus_1 = String.valueOf(_plus) + _concreteSyntaxFeatureName;
                        QualifiedName _lowerCase = this.nameConverter.toQualifiedName(_plus_1).toLowerCase();
                        result.add(_lowerCase);
                    }
                }
                if (!_matched && expression instanceof XAbstractFeatureCall && (_isTypeLiteral = ((XAbstractFeatureCall)expression).isTypeLiteral())) {
                    _matched = true;
                    JvmIdentifiableElement type = ((XAbstractFeatureCall)expression).getFeature();
                    if (type instanceof JvmDeclaredType) {
                        Functions.Function1 _function = it -> {
                            QualifiedName _lowerCase = this.nameConverter.toQualifiedName(it).toLowerCase();
                            return result.add(_lowerCase);
                        };
                        this.registerAllTypes((JvmType)type, (Functions.Function1<? super String, ? extends Boolean>)_function);
                    }
                }
                if ((typeRef = types.getActualType(expression)) == null) continue;
                Functions.Function1 _function = it -> {
                    QualifiedName _lowerCase = this.nameConverter.toQualifiedName(it).toLowerCase();
                    return result.add(_lowerCase);
                };
                this.registerAllTypes(typeRef.getType(), (Functions.Function1<? super String, ? extends Boolean>)_function);
            }
            EList _contents = this.getResource().getContents();
            for (EObject eobject : _contents) {
                Functions.Function1 _function = it -> {
                    LightweightTypeReference _xifexpression = null;
                    if (!(it instanceof JvmType) || it instanceof JvmDeclaredType) {
                        _xifexpression = types.getActualType(it);
                    }
                    return _xifexpression;
                };
                Iterable typesOfIdentifiables = IteratorExtensions.toIterable((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllContents((EObject)eobject, (boolean)true), JvmIdentifiableElement.class), (Functions.Function1)_function));
                for (LightweightTypeReference typeRef : typesOfIdentifiables) {
                    if (typeRef == null) continue;
                    Functions.Function1 _function_1 = it -> {
                        QualifiedName _lowerCase = this.nameConverter.toQualifiedName(it).toLowerCase();
                        return result.add(_lowerCase);
                    };
                    this.registerAllTypes(typeRef.getType(), (Functions.Function1<? super String, ? extends Boolean>)_function_1);
                }
            }
        }
        Iterables.addAll((Collection)result, (Iterable)super.getImportedNames());
        Functions.Function1 _function = it -> {
            boolean _contains = primitivesFilter.contains(it.getLastSegment());
            return !_contains;
        };
        this.importedNames = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)result, (Functions.Function1)_function));
        return this.importedNames;
    }

    public void registerAllTypes(JvmType type, Functions.Function1<? super String, ? extends Boolean> acceptor) {
        if (type == null || type.eIsProxy()) {
            return;
        }
        if (!this.isLocal(type) && ((Boolean)acceptor.apply((Object)type.getIdentifier())).booleanValue() && type instanceof JvmGenericType) {
            this.registerAllTypes((JvmType)((JvmGenericType)type).getDeclaringType(), acceptor);
            JvmTypeReference _extendedClass = null;
            if ((JvmGenericType)type != null) {
                _extendedClass = ((JvmGenericType)type).getExtendedClass();
            }
            JvmType _type = null;
            if (_extendedClass != null) {
                _type = _extendedClass.getType();
            }
            this.registerAllTypes(_type, acceptor);
            Consumer<JvmTypeReference> _function = it -> {
                JvmType _type_1 = null;
                if (it != null) {
                    _type_1 = it.getType();
                }
                this.registerAllTypes(_type_1, acceptor);
            };
            ((JvmGenericType)type).getExtendedInterfaces().forEach(_function);
        }
    }

    public boolean isLocal(JvmType type) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (type instanceof JvmGenericType) {
            _matched = true;
            _switchResult = ((JvmGenericType)type).isLocal();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }
}

