/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class JavaResourceServiceProvider
implements IResourceServiceProvider {
    @Inject
    private Injector injector;
    @Inject
    private FileExtensionProvider extensionProvider;

    public boolean canHandle(URI uri) {
        return this.extensionProvider.getFileExtensions().contains(uri.fileExtension()) && !uri.isArchive();
    }

    public <T> T get(Class<T> t) {
        try {
            return (T)this.injector.getInstance(t);
        }
        catch (Throwable _t) {
            if (_t instanceof ConfigurationException) {
                ConfigurationException e = (ConfigurationException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public IContainer.Manager getContainerManager() {
        return this.get(IContainer.Manager.class);
    }

    public IEncodingProvider getEncodingProvider() {
        return this.get(IEncodingProvider.class);
    }

    public IResourceDescription.Manager getResourceDescriptionManager() {
        return this.get(IResourceDescription.Manager.class);
    }

    public IResourceValidator getResourceValidator() {
        return null;
    }
}

