/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;

public class CommonBreakIterator
extends BreakIterator {
    protected Run whitespace;
    protected Run delimiter;
    protected Run identifier;
    protected Run other;
    protected final BreakIterator fIterator = BreakIterator.getWordInstance();
    protected CharSequence fText;
    private int fIndex = this.fIterator.current();

    public CommonBreakIterator(boolean camelCase) {
        this.whitespace = new Whitespace();
        this.delimiter = new LineDelimiter();
        this.identifier = camelCase ? new CamelCaseIdentifier() : new Identifier();
        this.other = new Other();
    }

    public int current() {
        return this.fIndex;
    }

    public int first() {
        this.fIndex = this.fIterator.first();
        return this.fIndex;
    }

    public int following(int offset) {
        if (offset == this.getText().getEndIndex()) {
            return -1;
        }
        int next = this.fIterator.following(offset);
        if (next == -1) {
            return -1;
        }
        Run run = this.consumeRun(offset);
        return offset + run.length;
    }

    protected Run consumeRun(int offset) {
        char ch = this.fText.charAt(offset);
        int length = this.fText.length();
        Run run = this.getRun(ch);
        while (run.consume(ch) && offset < length - 1) {
            ch = this.fText.charAt(++offset);
        }
        return run;
    }

    protected Run getRun(char ch) {
        Run run;
        if (this.whitespace.isValid(ch)) {
            run = this.whitespace;
        } else if (this.delimiter.isValid(ch)) {
            run = this.delimiter;
        } else if (this.identifier.isValid(ch)) {
            run = this.identifier;
        } else if (this.other.isValid(ch)) {
            run = this.other;
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        run.init();
        return run;
    }

    public CharacterIterator getText() {
        return this.fIterator.getText();
    }

    public boolean isBoundary(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public int last() {
        this.fIndex = this.fIterator.last();
        return this.fIndex;
    }

    public int next() {
        this.fIndex = this.following(this.fIndex);
        return this.fIndex;
    }

    public int next(int n) {
        return this.fIterator.next(n);
    }

    public int preceding(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return -1;
        }
        if (this.isBoundary(offset - 1)) {
            return offset - 1;
        }
        int previous = offset - 1;
        while (!this.isBoundary(previous = this.fIterator.preceding(previous))) {
        }
        int last = -1;
        while (previous < offset) {
            last = previous;
            previous = this.following(previous);
        }
        return last;
    }

    public int previous() {
        this.fIndex = this.preceding(this.fIndex);
        return this.fIndex;
    }

    public void setText(String newText) {
        this.setText((CharSequence)newText);
    }

    public void setText(CharSequence newText) {
        this.fText = newText;
        this.fIterator.setText((CharacterIterator)new SequenceCharacterIterator(newText));
        this.first();
    }

    public void setText(CharacterIterator newText) {
        if (!(newText instanceof CharSequence)) {
            throw new UnsupportedOperationException("CharacterIterator not supported");
        }
        this.fText = (CharSequence)((Object)newText);
        this.fIterator.setText(newText);
        this.first();
    }

    protected static class CamelCaseIdentifier
    extends Run {
        private static final int S_INIT = 0;
        private static final int S_LOWER = 1;
        private static final int S_ONE_CAP = 2;
        private static final int S_ALL_CAPS = 3;
        private static final int S_EXIT = 4;
        private static final int S_EXIT_MINUS_ONE = 5;
        private static final int K_INVALID = 0;
        private static final int K_LOWER = 1;
        private static final int K_UPPER = 2;
        private static final int K_OTHER = 3;
        private int fState;
        private static final int[][] MATRIX = new int[][]{{4, 1, 2, 1}, {4, 1, 4, 1}, {4, 1, 3, 1}, {4, 5, 3, 1}};

        protected CamelCaseIdentifier() {
        }

        @Override
        protected void init() {
            super.init();
            this.fState = 0;
        }

        @Override
        protected boolean consume(char ch) {
            int kind = this.getKind(ch);
            this.fState = MATRIX[this.fState][kind];
            switch (this.fState) {
                case 1: 
                case 2: 
                case 3: {
                    ++this.length;
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    --this.length;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        protected int getKind(char ch) {
            if (Character.isUpperCase(ch)) {
                return 2;
            }
            if (Character.isLowerCase(ch)) {
                return 1;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                return 3;
            }
            return 0;
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    protected static class Identifier
    extends Run {
        protected Identifier() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    protected static class LineDelimiter
    extends Run {
        private char fState;
        private static final char INIT = '\u0000';
        private static final char EXIT = '\u0001';

        protected LineDelimiter() {
        }

        @Override
        protected void init() {
            super.init();
            this.fState = '\u0000';
        }

        @Override
        protected boolean consume(char ch) {
            if (!this.isValid(ch) || this.fState == '\u0001') {
                return false;
            }
            if (this.fState == '\u0000') {
                this.fState = ch;
                ++this.length;
                return true;
            }
            if (this.fState != ch) {
                this.fState = '\u0001';
                ++this.length;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isValid(char ch) {
            return ch == '\n' || ch == '\r';
        }
    }

    protected static class Other
    extends Run {
        protected Other() {
        }

        @Override
        protected boolean isValid(char ch) {
            return !Character.isWhitespace(ch) && !Character.isJavaIdentifierPart(ch);
        }
    }

    protected static abstract class Run {
        protected int length;

        public Run() {
            this.init();
        }

        protected boolean consume(char ch) {
            if (this.isValid(ch)) {
                ++this.length;
                return true;
            }
            return false;
        }

        protected abstract boolean isValid(char var1);

        protected void init() {
            this.length = 0;
        }
    }

    protected class SequenceCharacterIterator
    implements CharacterIterator {
        private int fIndex = -1;
        private final CharSequence fSequence;
        private final int fFirst;
        private final int fLast;

        private void invariant() {
            Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
            Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
        }

        public SequenceCharacterIterator(CharSequence sequence) {
            this(sequence, 0);
        }

        public SequenceCharacterIterator(CharSequence sequence, int first) throws IllegalArgumentException {
            this(sequence, first, sequence.length());
        }

        public SequenceCharacterIterator(CharSequence sequence, int first, int last) throws IllegalArgumentException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (first < 0 || first > last) {
                throw new IllegalArgumentException();
            }
            if (last > sequence.length()) {
                throw new IllegalArgumentException();
            }
            this.fSequence = sequence;
            this.fFirst = first;
            this.fLast = last;
            this.fIndex = first;
            this.invariant();
        }

        @Override
        public char first() {
            return this.setIndex(this.getBeginIndex());
        }

        @Override
        public char last() {
            if (this.fFirst == this.fLast) {
                return this.setIndex(this.getEndIndex());
            }
            return this.setIndex(this.getEndIndex() - 1);
        }

        @Override
        public char current() {
            if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
                return this.fSequence.charAt(this.fIndex);
            }
            return '\uffff';
        }

        @Override
        public char next() {
            return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
        }

        @Override
        public char previous() {
            if (this.fIndex > this.getBeginIndex()) {
                return this.setIndex(this.fIndex - 1);
            }
            return '\uffff';
        }

        @Override
        public char setIndex(int position) {
            if (position < this.getBeginIndex() || position > this.getEndIndex()) {
                throw new IllegalArgumentException();
            }
            this.fIndex = position;
            this.invariant();
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return this.fFirst;
        }

        @Override
        public int getEndIndex() {
            return this.fLast;
        }

        @Override
        public int getIndex() {
            return this.fIndex;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    protected static class Whitespace
    extends Run {
        protected Whitespace() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isWhitespace(ch) && ch != '\n' && ch != '\r';
        }
    }
}

