/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.inject.ImplementedBy;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;

@ImplementedBy(value=Default.class)
public interface IOutlineNodeComparer {
    public boolean equals(IOutlineNode var1, IOutlineNode var2);

    public static class Default
    implements IOutlineNodeComparer {
        @Override
        public boolean equals(IOutlineNode node1, IOutlineNode node2) {
            if (node1 == null || node2 == null) {
                return node1 == null && node2 == null;
            }
            return node1.getClass() == node2.getClass() && this.equals(node1.getParent(), node2.getParent()) && this.equalsNullSafe(node1.getText().toString(), node2.getText().toString()) && this.equalsNullSafe(node1.getImage(), node2.getImage()) && this.equalsNullSafe(this.getImageDescriptor(node1), this.getImageDescriptor(node2)) && this.isEquivalentIndex(node1, node2);
        }

        protected boolean isEquivalentIndex(IOutlineNode node1, IOutlineNode node2) {
            IOutlineNode parent1 = node1.getParent();
            IOutlineNode parent2 = node2.getParent();
            if (parent1 == null && parent2 == null) {
                return true;
            }
            if (parent1 != null && parent2 != null) {
                int index2;
                List<IOutlineNode> siblings1 = parent1.getChildren();
                List<IOutlineNode> siblings2 = parent2.getChildren();
                int index1 = siblings1.indexOf(node1);
                if (index1 == (index2 = siblings2.indexOf(node2)) || siblings1.size() - index1 == siblings2.size() - index2) {
                    return true;
                }
            }
            return false;
        }

        protected ImageDescriptor getImageDescriptor(IOutlineNode node) {
            return node instanceof IOutlineNode.Extension ? ((IOutlineNode.Extension)((Object)node)).getImageDescriptor() : null;
        }

        protected boolean equalsNullSafe(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

