/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.IProjectDescriptionFactory;
import org.eclipse.xtext.ide.server.IWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class WorkspaceManager {
    @Inject
    private Provider<ProjectManager> projectManagerProvider;
    @Inject
    private IWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private IProjectDescriptionFactory projectDescriptionFactory;
    private BuildManager buildManager;
    private Map<String, ProjectManager> projectName2ProjectManager = CollectionLiterals.newHashMap();
    private URI baseDir;
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private IWorkspaceConfig _workspaceConfig;
    private List<ILanguageServerAccess.IBuildListener> buildListeners = CollectionLiterals.newArrayList();
    private Map<String, ResourceDescriptionsData> fullIndex = CollectionLiterals.newHashMap();
    private Map<URI, Document> openDocuments = CollectionLiterals.newHashMap();
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            Document _get = (Document)WorkspaceManager.this.openDocuments.get(uri);
            String _contents = null;
            if (_get != null) {
                _contents = _get.getContents();
            }
            return _contents;
        }

        public boolean hasContent(URI uri) {
            return WorkspaceManager.this.openDocuments.containsKey(uri);
        }
    };
    private static final Logger LOG = Logger.getLogger(WorkspaceManager.class);

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    @Inject
    public void setBuildManager(BuildManager buildManager) {
        buildManager.setWorkspaceManager(this);
        this.buildManager = buildManager;
    }

    public void initialize(URI baseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor, CancelIndicator cancelIndicator) {
        this.baseDir = baseDir;
        this.issueAcceptor = issueAcceptor;
        this.refreshWorkspaceConfig(cancelIndicator);
    }

    protected void refreshWorkspaceConfig(CancelIndicator cancelIndicator) {
        this.setWorkspaceConfig(this.workspaceConfigFactory.getWorkspaceConfig(this.baseDir));
        ArrayList newProjects = CollectionLiterals.newArrayList();
        Set<String> _keySet = this.projectName2ProjectManager.keySet();
        HashSet<String> remainingProjectNames = new HashSet<String>(_keySet);
        Consumer<IProjectConfig> _function = projectConfig -> {
            boolean _containsKey = this.projectName2ProjectManager.containsKey(projectConfig.getName());
            if (_containsKey) {
                remainingProjectNames.remove(projectConfig.getName());
            } else {
                ProjectManager projectManager = (ProjectManager)this.projectManagerProvider.get();
                ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription((IProjectConfig)projectConfig);
                Provider _function_1 = () -> this.fullIndex;
                projectManager.initialize(projectDescription, (IProjectConfig)projectConfig, this.issueAcceptor, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)_function_1, cancelIndicator);
                this.projectName2ProjectManager.put(projectDescription.getName(), projectManager);
                newProjects.add(projectDescription);
            }
        };
        this.getWorkspaceConfig().getProjects().forEach(_function);
        for (String deletedProject : remainingProjectNames) {
            this.projectName2ProjectManager.remove(deletedProject);
            this.fullIndex.remove(deletedProject);
        }
        List<IResourceDescription.Delta> result = this.buildManager.doInitialBuild(newProjects, cancelIndicator);
        this.afterBuild(result);
    }

    protected IWorkspaceConfig getWorkspaceConfig() {
        if (this._workspaceConfig == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.serverNotInitialized, "Workspace has not been initialized yet.", null);
            throw new ResponseErrorException(error);
        }
        return this._workspaceConfig;
    }

    protected void setWorkspaceConfig(IWorkspaceConfig workspaceConfig) {
        this._workspaceConfig = workspaceConfig;
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public BuildManager.Buildable didChangeFiles(List<URI> dirtyFiles, List<URI> deletedFiles) {
        BuildManager.Buildable buildable = this.buildManager.submit(dirtyFiles, deletedFiles);
        BuildManager.Buildable _function = cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            return deltas;
        };
        return _function;
    }

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        return this.didChangeFiles(dirtyFiles, deletedFiles).build(cancelIndicator);
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    public URI getProjectBaseDir(URI uri) {
        IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        URI _path = null;
        if (projectConfig != null) {
            _path = projectConfig.getPath();
        }
        return _path;
    }

    public ProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        String _name = null;
        if (projectConfig != null) {
            _name = projectConfig.getName();
        }
        return this.projectName2ProjectManager.get(_name);
    }

    public ProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public List<ProjectManager> getProjectManagers() {
        Collection<ProjectManager> _values = this.projectName2ProjectManager.values();
        return new ArrayList<ProjectManager>(_values);
    }

    public List<IResourceDescription.Delta> didChange(URI uri, int version, Iterable<TextEdit> changes, CancelIndicator cancelIndicator) {
        return this.didChange(uri, version, changes).build(cancelIndicator);
    }

    public BuildManager.Buildable didChange(URI uri, int version, Iterable<TextEdit> changes) {
        boolean _not;
        boolean _containsKey = this.openDocuments.containsKey(uri);
        boolean bl = _not = !_containsKey;
        if (_not) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            BuildManager.Buildable _function = it -> null;
            return _function;
        }
        Document contents = this.openDocuments.get(uri);
        this.openDocuments.put(uri, contents.applyChanges(changes));
        return this.didChangeFiles(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), CollectionLiterals.newArrayList());
    }

    public List<IResourceDescription.Delta> didOpen(URI uri, int version, String contents, CancelIndicator cancelIndicator) {
        return this.didOpen(uri, version, contents).build(cancelIndicator);
    }

    public BuildManager.Buildable didOpen(URI uri, int version, String contents) {
        Document _document = new Document(version, contents);
        this.openDocuments.put(uri, _document);
        return this.didChangeFiles(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), CollectionLiterals.newArrayList());
    }

    public List<IResourceDescription.Delta> didClose(URI uri, CancelIndicator cancelIndicator) {
        return this.didClose(uri).build(cancelIndicator);
    }

    public BuildManager.Buildable didClose(URI uri) {
        this.openDocuments.remove(uri);
        boolean _exists = this.exists(uri);
        if (_exists) {
            return this.didChangeFiles(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), CollectionLiterals.newArrayList());
        }
        return this.didChangeFiles(CollectionLiterals.newArrayList(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})));
    }

    protected boolean exists(URI uri) {
        XtextResourceSet rs;
        ProjectManager _projectManager = this.getProjectManager(uri);
        XtextResourceSet _resourceSet = null;
        if (_projectManager != null) {
            _resourceSet = _projectManager.getResourceSet();
        }
        if ((rs = _resourceSet) == null) {
            return false;
        }
        return rs.getURIConverter().exists(uri, null);
    }

    public <T> T doRead(URI uri, Functions.Function2<? super Document, ? super XtextResource, ? extends T> work) {
        XtextResource resource;
        URI resourceURI = uri.trimFragment();
        ProjectManager projectMnr = this.getProjectManager(resourceURI);
        Resource _resource = null;
        if (projectMnr != null) {
            _resource = projectMnr.getResource(resourceURI);
        }
        if ((resource = (XtextResource)_resource) == null) {
            return (T)work.apply(null, null);
        }
        Document doc = this.getDocument(resource);
        Resource _resource_1 = projectMnr.getResource(resourceURI);
        return (T)work.apply((Object)doc, (Object)((XtextResource)_resource_1));
    }

    protected Document getDocument(XtextResource resource) {
        Document _elvis = null;
        Document _get = this.openDocuments.get(resource.getURI());
        if (_get != null) {
            _elvis = _get;
        } else {
            Document _document;
            String _text = resource.getParseResult().getRootNode().getText();
            _elvis = _document = new Document(1, _text);
        }
        return _elvis;
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }
}

