/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

public abstract class AbstractHighlightingTest
extends AbstractEditorTest {
    @Inject
    @Extension
    private SyncUtil _syncUtil;
    @Inject
    @Extension
    private FileExtensionProvider _fileExtensionProvider;

    public void testHighlighting(CharSequence it, String text, TextStyle style) {
        int _style = style.getStyle();
        int _xifexpression = 0;
        RGB _color = style.getColor();
        boolean _tripleEquals = _color == null;
        _xifexpression = _tripleEquals ? 0 : style.getColor().red;
        int _xifexpression_1 = 0;
        RGB _color_1 = style.getColor();
        boolean _tripleEquals_1 = _color_1 == null;
        _xifexpression_1 = _tripleEquals_1 ? 0 : style.getColor().green;
        int _xifexpression_2 = 0;
        RGB _color_2 = style.getColor();
        boolean _tripleEquals_2 = _color_2 == null;
        _xifexpression_2 = _tripleEquals_2 ? 0 : style.getColor().blue;
        int _xifexpression_3 = 0;
        RGB _backgroundColor = style.getBackgroundColor();
        boolean _tripleEquals_3 = _backgroundColor == null;
        _xifexpression_3 = _tripleEquals_3 ? 255 : style.getBackgroundColor().red;
        int _xifexpression_4 = 0;
        RGB _backgroundColor_1 = style.getBackgroundColor();
        boolean _tripleEquals_4 = _backgroundColor_1 == null;
        _xifexpression_4 = _tripleEquals_4 ? 255 : style.getBackgroundColor().green;
        int _xifexpression_5 = 0;
        RGB _backgroundColor_2 = style.getBackgroundColor();
        boolean _tripleEquals_5 = _backgroundColor_2 == null;
        _xifexpression_5 = _tripleEquals_5 ? 255 : style.getBackgroundColor().blue;
        this.testHighlighting(it, text, _style, _xifexpression, _xifexpression_1, _xifexpression_2, _xifexpression_3, _xifexpression_4, _xifexpression_5);
    }

    public void testHighlighting(CharSequence it, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB) {
        this.testHighlighting(it, text, fontStyle, foregroundR, foregroundG, foregroundB, 255, 255, 255);
    }

    public void testHighlighting(CharSequence it, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB, int backgroundR, int backgroundG, int backgroundB) {
        this.testHighlighting(this.openInEditor(this.dslFile(it)), text, fontStyle, foregroundR, foregroundG, foregroundB, backgroundR, backgroundG, backgroundB);
    }

    protected IFile dslFile(CharSequence content) {
        try {
            boolean _not;
            IFile _xblockexpression = null;
            IFile file = IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content.toString());
            IProject project = file.getProject();
            boolean _hasNature = project.hasNature("org.eclipse.xtext.ui.shared.xtextNature");
            boolean bl = _not = !_hasNature;
            if (_not) {
                IResourcesSetupUtil.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            _xblockexpression = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getProjectName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("HighlightingTestProject");
        return _builder.toString();
    }

    protected String getFileName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("highlighting");
        return _builder.toString();
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected StyledText openInEditor(IFile dslFile) {
        try {
            StyledText _xblockexpression = null;
            XtextEditor editor = this.openEditor(dslFile);
            this._syncUtil.waitForReconciler(editor);
            _xblockexpression = editor.getInternalSourceViewer().getTextWidget();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testHighlighting(StyledText styledText, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB, int backgroundR, int backgroundG, int backgroundB) {
        Color expectedForegroundColor = new Color(null, foregroundR, foregroundG, foregroundB);
        Color expectedBackgroundColor = new Color(null, backgroundR, backgroundG, backgroundB);
        String content = styledText.getText();
        int offset = content.indexOf(text);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot locate '");
        _builder.append(text);
        _builder.append("' in ");
        _builder.append(content);
        Assert.assertNotEquals((String)_builder.toString(), (long)-1L, (long)offset);
        int i = 0;
        while (i < text.length()) {
            int currentPosition = offset + i;
            String character = styledText.getTextRange(currentPosition, 1);
            StyleRange styleRange = styledText.getStyleRangeAtOffset(currentPosition);
            boolean _isRelevant = this.isRelevant(character);
            if (_isRelevant) {
                Procedures.Procedure1 _function = it -> {
                    this.assertFontStyle((StyleRange)it, character, fontStyle);
                    this.assertForegroundColor((StyleRange)it, character, expectedForegroundColor);
                    this.assertBackgroundColor((StyleRange)it, character, expectedBackgroundColor);
                };
                ObjectExtensions.operator_doubleArrow((Object)styleRange, (Procedures.Procedure1)_function);
            }
            ++i;
        }
    }

    protected boolean isRelevant(String character) {
        String _trim = character.trim();
        return Objects.equal((Object)character, (Object)_trim);
    }

    protected void assertFontStyle(StyleRange it, String character, int expected) {
        int actual = it.fontStyle;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Expected font style does not correspond to the actual font style on character ");
        _builder.append(character);
        Assert.assertEquals((String)_builder.toString(), (long)expected, (long)actual);
    }

    protected void assertForegroundColor(StyleRange it, String character, Color expected) {
        Color _color;
        Color _elvis = null;
        _elvis = it.foreground != null ? it.foreground : (_color = new Color(null, 0, 0, 0));
        Color actual = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Expected foreground color does not correspond to the actual foreground color on character ");
        _builder.append(character);
        Assert.assertEquals((String)_builder.toString(), (Object)expected, (Object)actual);
    }

    protected void assertBackgroundColor(StyleRange it, String character, Color expected) {
        Color _color;
        Color _elvis = null;
        _elvis = it.background != null ? it.background : (_color = new Color(null, 255, 255, 255));
        Color actual = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Expected background color does not correspond to the actual background color on character ");
        _builder.append(character);
        Assert.assertEquals((String)_builder.toString(), (Object)expected, (Object)actual);
    }
}

