/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.serializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.xtext.generator.serializer.NamedSerializationContexts;

public class NamedSerializationContextProvider {
    private final Map<ParserRule, Integer> rules = new HashMap<ParserRule, Integer>();

    public NamedSerializationContextProvider(Grammar grammar) {
        int index = 0;
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            this.rules.put(rule, index++);
        }
    }

    public <T> List<NamedSerializationContexts<T>> getNamedContexts(SerializationContextMap<T> map) {
        ArrayList<NamedSerializationContexts<T>> result = new ArrayList<NamedSerializationContexts<T>>();
        LinkedHashMap<String, Integer> names = new LinkedHashMap<String, Integer>();
        for (SerializationContextMap.Entry e : map.values()) {
            for (EClass t : e.getTypes()) {
                List ctx = e.getContexts(t);
                String namePrefix = t == null ? "" : t.getName();
                String name = String.valueOf(namePrefix) + "_" + this.getSignificantGrammarElement(ctx);
                Integer dup = (Integer)((HashMap)names).get(name);
                String unique = null;
                if (dup == null) {
                    names.put(name, 1);
                    unique = name;
                } else {
                    names.put(name, dup + 1);
                    unique = String.valueOf(name) + "_" + dup;
                }
                result.add(new NamedSerializationContexts<Object>(unique, t, ctx, e.getValue()));
            }
        }
        return result;
    }

    public String getSignificantGrammarElement(Iterable<ISerializationContext> contexts) {
        ParserRule rule = null;
        int index = Integer.MAX_VALUE;
        for (ISerializationContext ctx : contexts) {
            Integer i;
            Action action;
            ParserRule pr = ctx.getParserRule();
            if (pr == null && (action = ctx.getAssignedAction()) != null) {
                pr = GrammarUtil.containingParserRule((EObject)action);
            }
            if (pr == null || (i = this.rules.get(pr)) >= index) continue;
            index = i;
            rule = pr;
        }
        if (rule != null) {
            return rule.getName();
        }
        return "unknown";
    }
}

