/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.serializer.EqualAmbiguousTransitions;
import org.eclipse.xtext.generator.serializer.SyntacticSequencerPDA2ExtendedDot;
import org.eclipse.xtext.generator.serializer.SyntacticSequencerUtil;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToDot;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaToDot;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;

public class DebugGraphGenerator {
    @Inject
    @Extension
    private IContextProvider contextProvider;
    @Inject
    private Grammar grammar;
    @Inject
    @Extension
    private Naming naming;
    @Inject
    @Extension
    private Context2NameFunction nameFunction;
    @Inject
    private IContextPDAProvider contextPDAProvider;
    @Inject
    private IContextTypePDAProvider contextTypePDAProvider;
    @Inject
    private ISyntacticSequencerPDAProvider syntacticSequencerPDAProvider;
    @Inject
    private ISemanticSequencerNfaProvider semanticSequencerNFAProvider;
    @Inject
    private SyntacticSequencerPDA2ExtendedDot syntacticSequencerPDA2Dot;
    @Inject
    private SyntacticSequencerUtil syntacticSequencerUtil;
    @Inject
    private PdaToDot<?, ?> pdaToDot;
    @Inject
    private NfaToDot<?> nfaToDot;

    public Iterable<Pair<String, String>> generateDebugGraphs() {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Pair[0]);
        List _allContexts = this.contextProvider.getAllContexts(this.grammar);
        for (EObject context : _allContexts) {
            try {
                String _file = this.file("context", context);
                Pda _contextPDA = this.contextPDAProvider.getContextPDA(context);
                String _draw = this.pdaToDot.draw((Object)_contextPDA);
                Pair _mappedTo = Pair.of((Object)_file, (Object)_draw);
                result.add(_mappedTo);
                Set _typesForContext = this.contextProvider.getTypesForContext(context);
                for (EClass type : _typesForContext) {
                    try {
                        String _file_1 = this.file("context_type", context, type);
                        Pda _contextTypePDA = this.contextTypePDAProvider.getContextTypePDA(context, type);
                        String _draw_1 = this.pdaToDot.draw((Object)_contextTypePDA);
                        Pair _mappedTo_1 = Pair.of((Object)_file_1, (Object)_draw_1);
                        result.add(_mappedTo_1);
                        String _file_2 = this.file("syntactic_sequencer", context, type);
                        ISyntacticSequencerPDAProvider.ISynAbsorberState _pDA = this.syntacticSequencerPDAProvider.getPDA(context, type);
                        String _draw_2 = this.syntacticSequencerPDA2Dot.draw(_pDA);
                        Pair _mappedTo_2 = Pair.of((Object)_file_2, (Object)_draw_2);
                        result.add(_mappedTo_2);
                        String _file_3 = this.file("semantic_sequencer", context, type);
                        Nfa _nFA = this.semanticSequencerNFAProvider.getNFA(context, type);
                        String _draw_3 = this.nfaToDot.draw((Object)_nFA);
                        Pair _mappedTo_3 = Pair.of((Object)_file_3, (Object)_draw_3);
                        result.add(_mappedTo_3);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable t = _t;
                            String _contextName = this.nameFunction.getContextName(context);
                            String _plus = "Context: " + _contextName;
                            String _plus_1 = String.valueOf(_plus) + " Type:";
                            String _name = null;
                            if (type != null) {
                                _name = type.getName();
                            }
                            String _plus_2 = String.valueOf(_plus_1) + _name;
                            System.out.println(_plus_2);
                            t.printStackTrace();
                            continue;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof Throwable) {
                    Throwable t_1 = _t_1;
                    String _contextName_1 = this.nameFunction.getContextName(context);
                    String _plus_3 = "Context: " + (String)_contextName_1;
                    System.out.println(_plus_3);
                    t_1.printStackTrace();
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
        try {
            int i = 0;
            HashMap trans2id = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Set<ISyntacticSequencerPDAProvider.ISynTransition> _allAmbiguousTransitions = this.syntacticSequencerUtil.getAllAmbiguousTransitions();
            for (ISyntacticSequencerPDAProvider.ISynTransition transition : _allAmbiguousTransitions) {
                String name = "ambiguity_" + Integer.valueOf(i);
                String _directory = this.directory("syntactic_sequencer");
                String _plus_4 = String.valueOf(_directory) + name;
                String _plus_5 = String.valueOf(_plus_4) + ".dot";
                Nfa _ambiguousNfa = transition.getAmbiguousNfa();
                String _draw_4 = this.nfaToDot.draw((Object)_ambiguousNfa);
                Pair _mappedTo_4 = Pair.of((Object)_plus_5, (Object)_draw_4);
                result.add(_mappedTo_4);
                trans2id.put(transition, name);
                ++i;
            }
            StringBuffer ambiguities = new StringBuffer();
            List<EqualAmbiguousTransitions> _allAmbiguousTransitionsBySyntax = this.syntacticSequencerUtil.getAllAmbiguousTransitionsBySyntax();
            for (EqualAmbiguousTransitions group : _allAmbiguousTransitionsBySyntax) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"id: ");
                String _identifyer = group.getIdentifyer();
                _builder.append((Object)_identifyer, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"Ambiguous syntax:\u00bb:");
                _builder.newLine();
                _builder.append((Object)"        ");
                GrammarAlias.AbstractElementAlias _elementAlias = group.getElementAlias();
                String _string = _elementAlias.toString();
                String _replace = _string.replace("\n", "\n        ");
                _builder.append((Object)_replace, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"This ambiguous syntax occurs at:");
                _builder.newLine();
                List<ISyntacticSequencerPDAProvider.ISynTransition> _transitions = group.getTransitions();
                for (ISyntacticSequencerPDAProvider.ISynTransition trans : _transitions) {
                    _builder.append((Object)"\t");
                    String _get = (String)trans2id.get(trans);
                    _builder.append((Object)_get, "\t");
                    _builder.append((Object)":");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"    ");
                    String _ambiguityInsideTransition = group.ambiguityInsideTransition(trans);
                    String _replace_1 = _ambiguityInsideTransition.replace("\n", "\n        ");
                    _builder.append((Object)_replace_1, "\t    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.newLine();
                ambiguities.append((CharSequence)_builder);
            }
            String _directory = this.directory("syntactic_sequencer");
            String _plus_4 = String.valueOf(_directory) + "ambiguities.txt";
            String _string_1 = ambiguities.toString();
            Pair _mappedTo_4 = Pair.of((Object)_plus_4, (Object)_string_1);
            result.add(_mappedTo_4);
        }
        catch (Throwable _t_2) {
            if (_t_2 instanceof Throwable) {
                Throwable t_2 = _t_2;
                t_2.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t_2);
        }
        return result;
    }

    public String directory(String name) {
        String _basePackageRuntime = this.naming.basePackageRuntime(this.grammar);
        String _asPath = this.naming.asPath(_basePackageRuntime);
        String _plus = String.valueOf(_asPath) + "/serializer/";
        String _name = this.grammar.getName();
        String _simpleName = this.naming.toSimpleName(_name);
        String _lowerCase = _simpleName.toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        String _plus_3 = String.valueOf(_plus_2) + name;
        return String.valueOf(_plus_3) + "/";
    }

    public String file(String name, EObject ctx, EClass type) {
        String _directory = this.directory(name);
        String _contextName = this.nameFunction.getContextName(ctx);
        String _plus = String.valueOf(_directory) + _contextName;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name = null;
        if (type != null) {
            _name = type.getName();
        }
        String _plus_2 = String.valueOf(_plus_1) + _name;
        return String.valueOf(_plus_2) + ".dot";
    }

    public String file(String name, EObject ctx) {
        String _directory = this.directory(name);
        String _contextName = this.nameFunction.getContextName(ctx);
        String _plus = String.valueOf(_directory) + _contextName;
        return String.valueOf(_plus) + ".dot";
    }
}

