/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.IConcreteSyntaxDiagnosticProvider;

public interface IConcreteSyntaxValidator {
    public boolean validateObject(EObject var1, IDiagnosticAcceptor var2, Map<Object, Object> var3);

    public boolean validateRecursive(EObject var1, IDiagnosticAcceptor var2, Map<Object, Object> var3);

    public static class DiagnosticChainAcceptor
    implements IDiagnosticAcceptor {
        private DiagnosticChain chain;

        public DiagnosticChainAcceptor(DiagnosticChain chain) {
            this.chain = chain;
        }

        @Override
        public void accept(IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic diag) {
            this.chain.add((Diagnostic)diag);
        }
    }

    public static class DiagnosticListAcceptor
    implements IDiagnosticAcceptor {
        private List<Diagnostic> chain;

        public DiagnosticListAcceptor(List<Diagnostic> chain) {
            this.chain = chain;
        }

        @Override
        public void accept(IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic diag) {
            this.chain.add(diag);
        }
    }

    public static interface IDiagnosticAcceptor {
        public void accept(IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic var1);
    }

    public static class InvalidConcreteSyntaxException
    extends RuntimeException {
        private static final long serialVersionUID = -6599356530663272947L;
        private List<Diagnostic> diagnostics;

        public InvalidConcreteSyntaxException(String msg, List<Diagnostic> diagnostics) {
            super(msg);
            this.diagnostics = diagnostics;
        }

        @Override
        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append(super.getMessage());
            msg.append("\n");
            for (Diagnostic d : this.diagnostics) {
                msg.append(d.getSource());
                msg.append(": ");
                msg.append(d.getMessage());
                msg.append("\n");
            }
            return msg.toString();
        }
    }
}

