/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.actions;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.outline.actions.AbstractToggleOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.actions.OutlineWithEditorLinker;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

public class LinkWithEditorOutlineContribution
extends AbstractToggleOutlineContribution {
    public static final String PREFERENCE_KEY = "ui.outline.linkWithEditor";
    @Inject
    private Provider<OutlineWithEditorLinker> outlineWithEditorLinkerProvider;
    private Map<OutlinePage, OutlineWithEditorLinker> page2linker = Maps.newHashMap();

    public String getPreferenceKey() {
        return PREFERENCE_KEY;
    }

    protected void stateChanged(boolean newState) {
    }

    protected void configureAction(Action action) {
        action.setText(XtextUIMessages.ToggleLinkWithEditorAction_label);
        action.setToolTipText(XtextUIMessages.ToggleLinkWithEditorAction_toolTip);
        action.setDescription(XtextUIMessages.ToggleLinkWithEditorAction_description);
        action.setImageDescriptor(XtextPluginImages.DESC_LINK_WITH_EDITOR);
        action.setDisabledImageDescriptor(XtextPluginImages.DESC_LINK_WITH_EDITOR_DISABLED);
    }

    public void register(OutlinePage outlinePage) {
        super.register(outlinePage);
        OutlineWithEditorLinker outlineWithEditorLinker = (OutlineWithEditorLinker)this.outlineWithEditorLinkerProvider.get();
        outlineWithEditorLinker.activate(outlinePage);
        this.getPreferenceStoreAccess().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)outlineWithEditorLinker);
        this.page2linker.put(outlinePage, outlineWithEditorLinker);
    }

    public void deregister(OutlinePage outlinePage) {
        super.deregister(outlinePage);
        OutlineWithEditorLinker outlineWithEditorLinker = this.page2linker.remove(outlinePage);
        outlineWithEditorLinker.deactivate();
        this.getPreferenceStoreAccess().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)outlineWithEditorLinker);
    }
}

