/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.refactoring.IRenameProcessorAdapter;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessorBasedRenameParticipant
extends RenameParticipant {
    private static final Logger LOG = Logger.getLogger(AbstractProcessorBasedRenameParticipant.class);
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private IRenameProcessorAdapter.Factory processorAdapterFactory;
    @Inject
    @Named(value="languageName")
    private String languageName;
    private RefactoringStatus status;
    private List<IRenameProcessorAdapter> wrappedProcessors;

    protected boolean initialize(Object element) {
        this.status = new RefactoringStatus();
        try {
            this.wrappedProcessors = this.getRenameProcessors(element);
            return this.wrappedProcessors != null;
        }
        catch (Exception exc) {
            this.status.addError("Error initializing refactoring participant. See log for details");
            LOG.error((Object)"Error initializing refactoring participant", (Throwable)exc);
            return false;
        }
    }

    protected List<IRenameProcessorAdapter> getRenameProcessors(Object element) {
        List<? extends IRenameElementContext> participantContexts = this.createRenameElementContexts(element);
        if (participantContexts != null) {
            ArrayList processors = Lists.newArrayList();
            for (IRenameElementContext iRenameElementContext : participantContexts) {
                IRenameRefactoringProvider renameRefactoringProvider = this.getRenameRefactoringProvider(iRenameElementContext);
                RenameProcessor processor = renameRefactoringProvider.getRenameProcessor(iRenameElementContext);
                processors.add(this.processorAdapterFactory.create(processor));
            }
            return processors;
        }
        return null;
    }

    protected IRenameRefactoringProvider getRenameRefactoringProvider(IRenameElementContext renameElementContext) {
        return (IRenameRefactoringProvider)this.globalServiceProvider.findService(renameElementContext.getTargetElementURI(), IRenameRefactoringProvider.class);
    }

    public String getName() {
        return this.languageName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm).setWorkRemaining(100);
        try {
            for (IRenameProcessorAdapter wrappedProcessor : this.wrappedProcessors) {
                this.status.merge(wrappedProcessor.checkInitialConditions((IProgressMonitor)progress.newChild(20)));
                wrappedProcessor.setNewName(this.getNewName());
                this.status.merge(wrappedProcessor.checkFinalConditions((IProgressMonitor)progress.newChild(80), context));
            }
        }
        catch (Exception ce) {
            this.status.addError("Error checking conditions in refactoring participant: " + Strings.notNull((Object)ce.getMessage()) + ". See log for details");
            LOG.error((Object)"Error checking conditions in refactoring participant", (Throwable)ce);
        }
        return this.status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = null;
        try {
            for (IRenameProcessorAdapter wrappedProcessor : this.wrappedProcessors) {
                Change processorChange = wrappedProcessor.createChange(pm);
                if (processorChange == null) continue;
                if (compositeChange == null) {
                    compositeChange = new CompositeChange("Changes form participant: " + this.getName());
                }
                compositeChange.add(processorChange);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.xtext.ui", "Error creating change", (Throwable)e));
        }
        return compositeChange;
    }

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        if (element instanceof IRenameElementContext) {
            IRenameElementContext triggeringContext = (IRenameElementContext)element;
            ResourceSet resourceSet = this.resourceSetProvider.get(this.projectUtil.getProject(triggeringContext.getTargetElementURI()));
            EObject originalTarget = resourceSet.getEObject(triggeringContext.getTargetElementURI(), true);
            List<EObject> renamedElements = this.getRenamedElementsOrProxies(originalTarget);
            if (renamedElements == null || renamedElements.isEmpty()) {
                return null;
            }
            ArrayList contexts = Lists.newArrayListWithCapacity((int)renamedElements.size());
            for (EObject renamedElement : renamedElements) {
                contexts.add(new IRenameElementContext.Impl(EcoreUtil.getURI((EObject)renamedElement), renamedElement.eClass(), triggeringContext.getTriggeringEditor(), triggeringContext.getTriggeringEditorSelection(), triggeringContext.getContextResourceURI()));
            }
            return contexts;
        }
        return null;
    }

    protected abstract List<EObject> getRenamedElementsOrProxies(EObject var1);

    protected String getNewName() {
        return this.getArguments().getNewName();
    }

    protected RefactoringStatus getStatus() {
        return this.status;
    }

    protected IGlobalServiceProvider getGlobalServiceProvider() {
        return this.globalServiceProvider;
    }
}

