/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.impl.ReferenceDescriptionSorter;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceUpdater
implements IReferenceUpdater {
    @Inject
    private ReferenceDescriptionSorter sorter;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;

    @Override
    public void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Iterable<IReferenceDescription> referenceDescriptions, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask("Sort references by project", 1);
        Multimap<IProject, IReferenceDescription> project2references = this.sorter.sortByProject(referenceDescriptions);
        SubMonitor allProjectsProgress = progress.newChild(98).setWorkRemaining(project2references.keySet().size());
        for (IProject project : project2references.keySet()) {
            if (allProjectsProgress.isCanceled()) break;
            Multimap<URI, IReferenceDescription> resource2references = this.sorter.sortByResource(project2references.get((Object)project));
            SubMonitor projectProgress = allProjectsProgress.newChild(1).setWorkRemaining(100);
            ResourceSet resourceSet = this.resourceSetProvider.get(project);
            this.loadTargetResource(resourceSet, elementRenameArguments, (IProgressMonitor)projectProgress.newChild(1));
            this.loadReferringResources(resourceSet, resource2references.keySet(), (IProgressMonitor)projectProgress.newChild(5));
            this.resolveReferenceProxies(resourceSet, resource2references.values(), projectProgress.newChild(10));
            elementRenameArguments.applyDeclarationChange(resourceSet);
            this.createReferenceUpdates(elementRenameArguments, resource2references, resourceSet, updateAcceptor, (IProgressMonitor)projectProgress.newChild(94));
        }
    }

    protected void resolveReferenceProxies(ResourceSet resourceSet, Collection<IReferenceDescription> values, SubMonitor newChild) {
        for (IReferenceDescription referenceDescription : values) {
            EObject sourceEObject = resourceSet.getEObject(referenceDescription.getSourceEObjectUri(), false);
            if (sourceEObject == null) {
                throw new RefactoringStatusException("Cannot find referring element " + Strings.notNull((Object)referenceDescription.getSourceEObjectUri()) + ". Maybe the index is be corrupt. Consider a rebuild.", true);
            }
            this.resolveReference(sourceEObject, referenceDescription);
        }
    }

    protected abstract void createReferenceUpdates(ElementRenameArguments var1, Multimap<URI, IReferenceDescription> var2, ResourceSet var3, IRefactoringUpdateAcceptor var4, IProgressMonitor var5);

    protected Resource loadTargetResource(ResourceSet resourceSet, ElementRenameArguments elementRenameArguments, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading target resource", (int)1);
        Resource targetResource = resourceSet.getResource(elementRenameArguments.getTargetElementURI().trimFragment(), true);
        if (targetResource == null) {
            throw new RefactoringStatusException("Cannot load target resource", true);
        }
        progress.worked(1);
        return targetResource;
    }

    protected void loadReferringResources(ResourceSet resourceSet, Iterable<URI> referringResourceURIs, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading referencing resources", (int)Iterables.size(referringResourceURIs));
        for (URI referringResourceURI : referringResourceURIs) {
            Resource referringResource = resourceSet.getResource(referringResourceURI, true);
            if (referringResource == null) {
                throw new RefactoringStatusException("Resource " + Strings.notNull((Object)referringResourceURI) + " cannot be loaded", true);
            }
            progress.worked(1);
        }
    }

    protected void resolveReference(EObject referringElement, IReferenceDescription referenceDescription) {
        Object unresolvedValue = referringElement.eGet((EStructuralFeature)referenceDescription.getEReference());
        if (referenceDescription.getEReference().isMany()) {
            List list = (List)unresolvedValue;
            list.get(referenceDescription.getIndexInList());
        }
    }
}

