/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class DefaultRenameStrategy
extends AbstractRenameStrategy {
    protected ITextRegion originalNameRegion;
    protected String nameRuleName;
    protected IValueConverterService valueConverterService;
    @Deprecated
    private EObject temporaryObjectReference;

    protected DefaultRenameStrategy(EObject targetElement, EAttribute nameAttribute, ITextRegion originalNameRegion, String nameRuleName, IValueConverterService valueConverterService) {
        super(targetElement, nameAttribute);
        this.originalNameRegion = originalNameRegion;
        this.nameRuleName = nameRuleName;
        this.valueConverterService = valueConverterService;
    }

    @Deprecated
    protected DefaultRenameStrategy(EObject targetElement, ILocationInFileProvider locationInFileProvider) {
        super(targetElement);
        this.originalNameRegion = locationInFileProvider.getFullTextRegion(targetElement, (EStructuralFeature)this.getNameAttribute(), 0);
        this.temporaryObjectReference = targetElement;
    }

    @Deprecated
    @Inject
    private void injectServicesForDeprecationReasons(IValueConverterService valueConverter) {
        try {
            if (this.nameRuleName != null) {
                return;
            }
            this.valueConverterService = valueConverter;
            this.nameRuleName = this.getNameRuleName(this.temporaryObjectReference, this.getNameAttribute());
        }
        finally {
            this.temporaryObjectReference = null;
        }
    }

    @Deprecated
    private String getNameRuleName(EObject targetElement, EAttribute nameAttribute) {
        List nameNodes = NodeModelUtils.findNodesForFeature((EObject)targetElement, (EStructuralFeature)nameAttribute);
        if (nameNodes.size() != 1 || !(((INode)nameNodes.get(0)).getGrammarElement() instanceof RuleCall)) {
            return null;
        }
        return ((RuleCall)((INode)nameNodes.get(0)).getGrammarElement()).getRule().getName();
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), this.getDeclarationTextEdit(newName));
    }

    protected TextEdit getDeclarationTextEdit(String newName) {
        String text = newName;
        return new ReplaceEdit(this.originalNameRegion.getOffset(), this.originalNameRegion.getLength(), text);
    }

    protected String getNameAsText(String nameAsValue) {
        return this.nameRuleName != null ? this.valueConverterService.toString((Object)nameAsValue, this.nameRuleName) : nameAsValue;
    }

    protected String getNameAsValue(String nameAsText) {
        return this.nameRuleName != null ? this.valueConverterService.toValue(nameAsText, this.nameRuleName, null).toString() : nameAsText;
    }

    public String getOriginalName() {
        return this.getNameAsText(super.getOriginalName());
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        super.applyDeclarationChange(this.getNameAsValue(newName), resourceSet);
    }

    public static class Provider
    implements IRenameStrategy.Provider {
        @Inject
        private ILocationInFileProvider locationInFileProvider;
        @Inject
        private IValueConverterService valueConverterService;

        public IRenameStrategy get(EObject targetElement, IRenameElementContext renameElementContext) {
            EAttribute nameAttribute = this.getNameAttribute(targetElement);
            if (nameAttribute == null) {
                return null;
            }
            return new DefaultRenameStrategy(targetElement, nameAttribute, this.getOriginalNameRegion(targetElement, nameAttribute), this.getNameRuleName(targetElement, nameAttribute), this.getValueConverterService());
        }

        protected ITextRegion getOriginalNameRegion(EObject targetElement, EAttribute nameAttribute) {
            return this.getLocationInFileProvider().getFullTextRegion(targetElement, (EStructuralFeature)nameAttribute, 0);
        }

        protected ILocationInFileProvider getLocationInFileProvider() {
            return this.locationInFileProvider;
        }

        protected IValueConverterService getValueConverterService() {
            return this.valueConverterService;
        }

        protected EAttribute getNameAttribute(EObject targetElement) {
            return SimpleAttributeResolver.NAME_RESOLVER.getAttribute(targetElement);
        }

        protected String getNameRuleName(EObject targetElement, EAttribute nameAttribute) {
            List nameNodes = NodeModelUtils.findNodesForFeature((EObject)targetElement, (EStructuralFeature)nameAttribute);
            if (nameNodes.size() != 1 || !(((INode)nameNodes.get(0)).getGrammarElement() instanceof RuleCall)) {
                return null;
            }
            return ((RuleCall)((INode)nameNodes.get(0)).getGrammarElement()).getRule().getName();
        }
    }
}

