/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IReferenceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDescriptionSorter {
    @Inject
    private IWorkspace workspace;

    public Multimap<IProject, IReferenceDescription> sortByProject(Iterable<IReferenceDescription> referenceDescriptions) {
        HashMultimap referencesByProject = HashMultimap.create();
        for (IReferenceDescription referenceDescription : referenceDescriptions) {
            URI sourceEObjectUri = referenceDescription.getSourceEObjectUri();
            String projectName = sourceEObjectUri.segment(1);
            IProject project = this.workspace.getRoot().getProject(projectName);
            referencesByProject.put((Object)project, (Object)referenceDescription);
        }
        return referencesByProject;
    }

    public Multimap<URI, IReferenceDescription> sortByResource(Iterable<IReferenceDescription> referenceDescriptions) {
        HashMultimap referencesByResourceURI = HashMultimap.create();
        for (IReferenceDescription referenceDescription : referenceDescriptions) {
            URI sourceResourceUri = referenceDescription.getSourceEObjectUri().trimFragment();
            referencesByResourceURI.put((Object)sourceResourceUri, (Object)referenceDescription);
        }
        return referencesByResourceURI;
    }
}

