/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.LinkedEditingUndoSupport;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameLinkedMode;
import org.eclipse.xtext.ui.refactoring.ui.ViewFreezer;
import org.eclipse.xtext.util.Strings;

@Singleton
public class RenameRefactoringController {
    @Inject
    private IWorkbench workbench;
    @Inject
    private Provider<RenameLinkedMode> renameLinkedModeProvider;
    @Inject
    private IRenameSupport.Factory renameSupportFactory;
    private RenameLinkedMode activeLinkedMode;
    private IRenameElementContext renameElementContext;
    private LinkedEditingUndoSupport undoSupport;
    private String newName;

    public void initialize(IRenameElementContext renameElementContext) {
        this.renameElementContext = renameElementContext;
    }

    public void startRefactoring(RefactoringType refactoringType) {
        ViewFreezer freezer = null;
        try {
            if (refactoringType == RefactoringType.LINKED_EDITING) {
                this.startLinkedEditing();
                return;
            }
            try {
                if (this.activeLinkedMode != null) {
                    this.newName = this.activeLinkedMode.getCurrentName();
                }
                freezer = new ViewFreezer(this.getXtextEditor().getInternalSourceViewer());
                freezer.freeze();
                this.undoSupport.undoDocumentChanges();
                this.undoSupport = null;
                this.cancelLinkedMode();
                switch (refactoringType) {
                    case REFACTORING_DIRECT: {
                        this.startDirectRefactoring();
                        break;
                    }
                    case REFACTORING_DIALOG: {
                        this.startRefactoringWithDialog(false);
                        break;
                    }
                    case REFACTORING_PREVIEW: {
                        this.startRefactoringWithDialog(true);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid refactoring type " + refactoringType.toString());
                    }
                }
            }
            catch (InterruptedException exc) {
                this.restoreOriginalSelection();
            }
        }
        finally {
            if (freezer != null) {
                freezer.release();
            }
        }
    }

    protected void startLinkedEditing() throws InterruptedException {
        if (this.activeLinkedMode != null) {
            if (this.activeLinkedMode.isSameRenameElementContext(this.renameElementContext)) {
                this.startRefactoring(RefactoringType.REFACTORING_DIALOG);
                return;
            }
            this.cancelLinkedMode();
        }
        try {
            this.workbench.getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RenameRefactoringController.this.activeLinkedMode = (RenameLinkedMode)RenameRefactoringController.this.renameLinkedModeProvider.get();
                    RenameRefactoringController.this.activeLinkedMode.start(RenameRefactoringController.this.renameElementContext, monitor);
                    RenameRefactoringController.this.undoSupport = new LinkedEditingUndoSupport(RenameRefactoringController.this.getXtextEditor());
                }
            });
        }
        catch (Exception exc) {
            throw new WrappedException(exc);
        }
    }

    public RenameLinkedMode getActiveLinkedMode() {
        return this.activeLinkedMode;
    }

    public void cancelLinkedMode() {
        if (this.activeLinkedMode != null) {
            this.activeLinkedMode.linkedModeLeft();
            this.activeLinkedMode = null;
        }
    }

    protected void startDirectRefactoring() throws InterruptedException {
        if (Strings.isEmpty((String)this.newName)) {
            this.restoreOriginalSelection();
        } else {
            this.createRenameSupport(this.renameElementContext, this.newName).startDirectRefactoring();
        }
    }

    protected void startRefactoringWithDialog(boolean previewOnly) throws InterruptedException {
        this.createRenameSupport(this.renameElementContext, this.newName).startRefactoringWithDialog(previewOnly);
    }

    protected IRenameSupport createRenameSupport(IRenameElementContext context, String name) {
        return this.renameSupportFactory.create(context, this.newName);
    }

    protected void restoreOriginalSelection() {
        ISelection originalSelection = this.renameElementContext.getTriggeringEditorSelection();
        if (originalSelection instanceof ITextSelection) {
            this.getXtextEditor().getInternalSourceViewer().setSelectedRange(((ITextSelection)originalSelection).getOffset(), ((ITextSelection)originalSelection).getLength());
        }
    }

    protected XtextEditor getXtextEditor() {
        IEditorPart part = this.renameElementContext.getTriggeringEditor();
        if (part instanceof XtextEditor) {
            return (XtextEditor)part;
        }
        return null;
    }
}

