/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.Strings;

public class JvmElementFinder {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    public EObject getCorrespondingJvmElement(IJavaElement javaElement, ResourceSet resourceSet) {
        this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        URI jvmElementURI = this.typeURIHelper.getFullURI(javaElement);
        return resourceSet.getEObject(jvmElementURI, true);
    }

    public JvmIdentifiableElement findJvmElementDeclarationInIndex(EObject jvmElement, IProject project) {
        IEObjectDescription indexedElementDescription;
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(jvmElement);
        if (qualifiedName != null && (indexedElementDescription = this.findIndexedElement(project, qualifiedName, jvmElement.eClass())) != null) {
            return (JvmIdentifiableElement)EcoreUtil.resolve((EObject)indexedElementDescription.getEObjectOrProxy(), (EObject)jvmElement);
        }
        return null;
    }

    protected IEObjectDescription findIndexedElement(IProject project, QualifiedName qualifiedName, EClass expectedJvmType) {
        for (IEObjectDescription candidate : this.resourceDescriptions.getExportedObjects(expectedJvmType, qualifiedName, true)) {
            if (!candidate.getEObjectURI().isPlatformResource() || !Strings.equal((String)project.getName(), (String)candidate.getEObjectURI().segment(1))) continue;
            return candidate;
        }
        return null;
    }
}

