/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.AbstractXbaseCompiler;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.typing.FunctionConversion;

public class TypeConvertingCompiler
extends AbstractXbaseCompiler {
    @Inject
    private FunctionConversion funcConversion;
    @Inject
    private TypeArgumentContextProvider contextProvider;

    protected void internalToJavaExpression(XExpression obj, IAppendable appendable) {
        JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(obj);
        this.internalToConvertedExpression(obj, appendable, expectedType);
    }

    protected void internalToConvertedExpression(final XExpression obj, final IAppendable appendable, JvmTypeReference toBeConvertedTo) {
        JvmTypeReference actualType;
        if (toBeConvertedTo != null && !EcoreUtil.equals((EObject)toBeConvertedTo, (EObject)(actualType = this.getTypeProvider().getType(obj)))) {
            this.doConversion(toBeConvertedTo, actualType, appendable, obj, new Later(){

                public void exec() {
                    String finalVariable = appendable.getName(Tuples.create((Object)"Convertable", (Object)obj));
                    if (finalVariable != null) {
                        appendable.append(finalVariable);
                    } else {
                        TypeConvertingCompiler.super.internalToJavaExpression(obj, appendable);
                    }
                }
            });
            return;
        }
        super.internalToJavaExpression(obj, appendable);
    }

    protected void doConversion(JvmTypeReference left, JvmTypeReference right, IAppendable appendable, XExpression context, Later expression) {
        if (this.getPrimitives().isPrimitive(right) && !this.getPrimitives().isPrimitive(left)) {
            this.convertPrimitiveToWrapper(this.getPrimitives().asWrapperTypeIfPrimitive(right), appendable, expression);
        } else if (right instanceof JvmMultiTypeReference) {
            this.convertMultiType(left, (JvmMultiTypeReference)right, context, appendable, expression);
        } else if (this.getTypeReferences().isArray(right) && this.isList(left)) {
            this.convertArrayToList(left, appendable, context, expression);
        } else if (this.isList(right) && this.getTypeReferences().isArray(left)) {
            this.convertListToArray(left, appendable, context, expression);
        } else if (right.getType().getIdentifier().startsWith(Functions.class.getCanonicalName())) {
            this.convertFunctionType(left, right, appendable, expression);
        } else {
            expression.exec();
        }
    }

    protected void convertMultiType(JvmTypeReference expectation, JvmMultiTypeReference multiType, XExpression context, IAppendable b, Later expression) {
        JvmTypeReference castTo = null;
        for (JvmTypeReference candidate : multiType.getReferences()) {
            if (!this.getTypeConformanceComputer().isConformant(expectation, candidate, true)) continue;
            castTo = candidate;
            break;
        }
        if (castTo != null) {
            b.append("((");
            this.serialize(castTo, context, b, true, false);
            b.append(")");
        }
        expression.exec();
        if (castTo != null) {
            b.append(")");
        }
    }

    protected void convertFunctionType(JvmTypeReference expectedType, JvmTypeReference functionType, IAppendable appendable, Later expression) {
        String name;
        JvmFormalParameter p;
        JvmTypeReference resolvedLeft = this.funcConversion.getResolvedExpectedType(expectedType, functionType);
        if (resolvedLeft == null || resolvedLeft.getIdentifier().equals(Object.class.getName()) || EcoreUtil.equals((EObject)resolvedLeft.getType(), (EObject)functionType.getType())) {
            expression.exec();
            return;
        }
        JvmOperation operation = this.funcConversion.findSingleMethod(expectedType);
        if (operation == null) {
            throw new IllegalStateException("expected type " + resolvedLeft + " not mappable from " + functionType);
        }
        TypeArgumentContext typeArgumentContext = this.contextProvider.getReceiverContext(resolvedLeft);
        appendable.append("new ");
        this.serialize(resolvedLeft, null, appendable, true, false);
        appendable.append("() {");
        appendable.increaseIndentation().increaseIndentation();
        appendable.append("\npublic ");
        this.serialize(typeArgumentContext.resolve(operation.getReturnType()), null, appendable, true, false);
        appendable.append(" ").append(operation.getSimpleName()).append("(");
        EList params = operation.getParameters();
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            p = (JvmFormalParameter)iterator.next();
            name = p.getName();
            this.serialize(typeArgumentContext.resolve(p.getParameterType()), null, appendable, true, false);
            appendable.append(" ").append(name);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(") {");
        appendable.increaseIndentation();
        appendable.append("\nreturn ");
        expression.exec();
        appendable.append(".apply(");
        iterator = params.iterator();
        while (iterator.hasNext()) {
            p = (JvmFormalParameter)iterator.next();
            name = p.getName();
            appendable.append(name);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(");");
        appendable.decreaseIndentation();
        appendable.append("\n}");
        appendable.decreaseIndentation().decreaseIndentation();
        appendable.append("\n}");
    }

    protected void convertListToArray(JvmTypeReference listType, IAppendable appendable, XExpression context, Later expression) {
        appendable.append("((");
        this.serialize(listType, context, appendable);
        appendable.append(")");
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (EObject)context, new JvmTypeReference[0]);
        appendable.append(conversions).append(".unwrapArray(");
        expression.exec();
        appendable.append("))");
    }

    protected void convertArrayToList(JvmTypeReference left, IAppendable appendable, XExpression context, Later expression) {
        appendable.append("((");
        this.serialize(left, context, appendable);
        appendable.append(")");
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (EObject)context, new JvmTypeReference[0]);
        this.serialize(conversions, context, appendable);
        appendable.append(".doWrapArray(");
        expression.exec();
        appendable.append("))");
    }

    protected void convertPrimitiveToWrapper(JvmTypeReference wrapper, IAppendable appendable, Later expression) {
        appendable.append("((");
        this.serialize(wrapper, null, appendable);
        appendable.append(")");
        expression.exec();
        appendable.append(")");
    }

    protected boolean isList(JvmTypeReference type) {
        TypeReferences typeRefs = this.getTypeReferences();
        return typeRefs.is(type, List.class) || typeRefs.is(type, Iterable.class) || typeRefs.is(type, Collection.class);
    }

    protected TypeArgumentContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

