/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;

public class JavaIoFileSystemAccess
extends AbstractFileSystemAccess {
    public void generateFile(String fileName, String slot, CharSequence contents) {
        String outlet = this.getPathes().get(slot);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + slot + "' has not been configured.");
        }
        String pathName = this.toSystemFileName(String.valueOf(outlet) + "/" + fileName);
        File file = new File(pathName);
        try {
            this.createFolder(file.getParentFile());
            FileWriter writer = new FileWriter(file);
            writer.append(contents);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createFolder(File parent) {
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public void deleteFile(String fileName) {
        new File(this.toSystemFileName(fileName)).delete();
    }

    protected String toSystemFileName(String fileName) {
        return fileName.replace("/", File.separator);
    }
}

