/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.hover.XbaseDeclarativeHoverSignatureProvider;

public class XtendHoverSignatureProvider
extends XbaseDeclarativeHoverSignatureProvider {
    @Inject
    protected IXtendJvmAssociations associations;
    @Inject
    protected ITypeProvider typeProvider;

    protected String _signature(XtendClass clazz, boolean typeAtEnd) {
        return String.valueOf(clazz.getSimpleName()) + this.hoverUiStrings.typeParameters((Iterable)clazz.getTypeParameters());
    }

    protected String _signature(XtendFunction function, boolean typeAtEnd) {
        JvmOperation inferredOperation = this.associations.getDirectlyInferredOperation(function);
        String returnTypeString = "void";
        JvmTypeReference returnType = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)inferredOperation);
        if (returnType != null) {
            returnTypeString = returnType instanceof JvmAnyTypeReference ? "Object" : returnType.getSimpleName();
        }
        String signature = String.valueOf(function.getName()) + this.hoverUiStrings.parameters((JvmIdentifiableElement)inferredOperation) + this.getThrowsDeclaration((JvmExecutable)inferredOperation);
        String typeParameter = this.uiStrings.typeParameters((Iterable)function.getTypeParameters());
        if (typeParameter != null && typeParameter.length() > 0) {
            return String.valueOf(typeParameter) + " " + returnTypeString + " " + signature;
        }
        return String.valueOf(returnTypeString) + " " + signature;
    }

    protected String _signature(XtendField field, boolean typeAtEnd) {
        JvmTypeReference type;
        if (field.getName() == null && field.isExtension()) {
            return field.getType().getSimpleName();
        }
        JvmField jvmField = this.associations.getJvmField(field);
        if (jvmField != null && (type = jvmField.getType()) != null) {
            if (field.getName() == null) {
                return type.getSimpleName();
            }
            return String.valueOf(type.getSimpleName()) + " " + field.getName();
        }
        if (field.getName() == null) {
            return "";
        }
        return field.getName();
    }

    protected String _signature(XtendParameter parameter, boolean typeAtEnd) {
        EObject container = parameter.eContainer();
        JvmTypeReference type = parameter.getParameterType();
        if (type != null) {
            String signature = parameter.getName();
            String signatureOfFather = this.getSimpleSignature(container);
            if (signatureOfFather != null) {
                signature = String.valueOf(signature) + JavaElementLabels.CONCAT_STRING + signatureOfFather;
            }
            if (typeAtEnd) {
                return String.valueOf(signature) + " : " + type.getSimpleName();
            }
            return String.valueOf(type.getSimpleName()) + " " + signature;
        }
        return parameter.getName();
    }

    protected String _signature(XtendConstructor constructor, boolean typeAtEnd) {
        JvmConstructor inferredConstructor = this.associations.getInferredConstructor(constructor);
        XtendClass xtendClazz = (XtendClass)EcoreUtil2.getContainerOfType((EObject)constructor, XtendClass.class);
        return String.valueOf(xtendClazz.getName()) + this.hoverUiStrings.parameters((JvmIdentifiableElement)inferredConstructor) + this.getThrowsDeclaration((JvmExecutable)inferredConstructor);
    }

    protected String getSimpleSignature(EObject container) {
        if (container instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)container;
            JvmOperation inferredOperation = this.associations.getDirectlyInferredOperation(function);
            return String.valueOf(function.getName()) + this.uiStrings.parameters((JvmIdentifiableElement)inferredOperation);
        }
        if (container instanceof XtendConstructor) {
            XtendConstructor constructor = (XtendConstructor)container;
            XtendClass xtendClazz = (XtendClass)EcoreUtil2.getContainerOfType((EObject)constructor, XtendClass.class);
            JvmConstructor inferredConstructor = this.associations.getInferredConstructor(constructor);
            return String.valueOf(xtendClazz.getName()) + " " + this.uiStrings.parameters((JvmIdentifiableElement)inferredConstructor);
        }
        return super.getSimpleSignature(container);
    }

    public String getImageTag(EObject object) {
        if (object instanceof XtendParameter) {
            return super.getImageTag((EObject)this.getFormalParameter(object));
        }
        return super.getImageTag(object);
    }

    private JvmFormalParameter getFormalParameter(EObject parameter) {
        Set jvmElements = this.associations.getJvmElements(parameter);
        if (jvmElements.size() > 0) {
            return (JvmFormalParameter)Lists.newArrayList((Iterable)jvmElements).get(0);
        }
        return null;
    }
}

