/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementHandler;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringPreferences;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringController;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultRenameElementHandler
extends AbstractHandler
implements IRenameElementHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    protected RenameRefactoringController renameRefactoringController;
    @Inject
    protected IGlobalServiceProvider globalServiceProvider;
    @Inject
    protected RefactoringPreferences preferences;
    protected static final Logger LOG = Logger.getLogger(DefaultRenameElementHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IRenameElementContext renameElementContext = (IRenameElementContext)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<IRenameElementContext, XtextResource>(){

                    public IRenameElementContext exec(XtextResource resource) throws Exception {
                        IRenameElementContext renameElementContext;
                        EObject selectedElement = DefaultRenameElementHandler.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                        if (selectedElement != null && DefaultRenameElementHandler.this.isRefactoringEnabled(renameElementContext = DefaultRenameElementHandler.this.createRenameElementContext(selectedElement, editor, selection, resource), resource)) {
                            return renameElementContext;
                        }
                        return null;
                    }
                });
                if (renameElementContext != null) {
                    this.startRenameElement(renameElementContext);
                }
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error initializing refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error initializing refactoring", (String)(String.valueOf(exc.getMessage()) + "\nSee log for details"));
        }
        return null;
    }

    protected boolean isRefactoringEnabled(IRenameElementContext renameElementContext, XtextResource resource) {
        EObject targetElement;
        ResourceSet resourceSet = resource.getResourceSet();
        if (renameElementContext != null && resourceSet != null && (targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true)) != null && !targetElement.eIsProxy()) {
            ITextRegion significantRegion;
            ITextSelection textSelection;
            TextRegion selectedRegion;
            INode crossReferenceNode;
            if (targetElement.eResource() == resource && renameElementContext.getTriggeringEditorSelection() instanceof ITextSelection && (crossReferenceNode = this.eObjectAtOffsetHelper.getCrossReferenceNode(resource, (ITextRegion)(selectedRegion = new TextRegion((textSelection = (ITextSelection)renameElementContext.getTriggeringEditorSelection()).getOffset(), textSelection.getLength())))) == null && !(significantRegion = this.locationInFileProvider.getSignificantTextRegion(targetElement)).contains((ITextRegion)selectedRegion)) {
                return false;
            }
            IRenameStrategy.Provider renameStrategyProvider = (IRenameStrategy.Provider)this.globalServiceProvider.findService(targetElement, IRenameStrategy.Provider.class);
            return renameStrategyProvider.get(targetElement, renameElementContext) != null;
        }
        return false;
    }

    public IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        URI targetElementURI = EcoreUtil2.getNormalizedURI((EObject)targetElement);
        IRenameElementContext.Impl renameElementContext = new IRenameElementContext.Impl(targetElementURI, targetElement.eClass(), (IEditorPart)editor, (ISelection)selection, resource.getURI());
        return renameElementContext;
    }

    protected void startRenameElement(IRenameElementContext renameElementContext) throws InterruptedException {
        this.renameRefactoringController.initialize(renameElementContext);
        if (this.preferences.useInlineRefactoring()) {
            this.renameRefactoringController.startRefactoring(RefactoringType.LINKED_EDITING);
        } else {
            this.renameRefactoringController.startRefactoring(RefactoringType.REFACTORING_DIALOG);
        }
    }
}

