/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.ide.refactoring.DispatchMethodRenameContext;
import org.eclipse.xtend.ide.refactoring.DispatchRenameSupport;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.CombinedJvmJdtRenameContextFactory;

public class XtendRenameContextFactory
extends CombinedJvmJdtRenameContextFactory {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchRenameSupport dispatchRenameSupport;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private ProjectUtil projectUtil;

    public IRenameElementContext createLocalRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        EObject declarationTarget = this.getDeclarationTarget(targetElement);
        if (declarationTarget instanceof XtendFunction && ((XtendFunction)declarationTarget).isDispatch()) {
            IProject project = this.projectUtil.getProject(declarationTarget.eResource().getURI());
            ResourceSet resourceSet = this.resourceSetProvider.get(project);
            XtendFunction relaodedDispatchFunction = (XtendFunction)resourceSet.getEObject(EcoreUtil2.getNormalizedURI((EObject)declarationTarget), true);
            Iterable<JvmOperation> allDispatchOperations = this.dispatchRenameSupport.getAllDispatchOperations(relaodedDispatchFunction);
            LinkedHashMap jvm2javaElement = Maps.newLinkedHashMap();
            for (JvmOperation jvmOperation : allDispatchOperations) {
                IJavaElement javaElement = this.getJavaElementFinder().findExactElementFor((JvmIdentifiableElement)jvmOperation);
                if (javaElement == null) continue;
                URI jvmOperationURI = EcoreUtil.getURI((EObject)jvmOperation);
                jvm2javaElement.put(jvmOperationURI, javaElement);
            }
            if (!jvm2javaElement.isEmpty()) {
                return new DispatchMethodRenameContext(relaodedDispatchFunction, jvm2javaElement, editor, selection, resource);
            }
        }
        return super.createLocalRenameElementContext(targetElement, editor, selection, resource);
    }

    protected EObject getDeclarationTarget(EObject targetElement) {
        EObject declarationTarget = super.getDeclarationTarget(targetElement);
        if (declarationTarget instanceof XtendConstructor) {
            return declarationTarget.eContainer();
        }
        return declarationTarget;
    }
}

