/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.refactoring.IChangeRedirector;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.DefaultJvmModelRenameStrategy;

public class XtendRenameStrategy
extends DefaultJvmModelRenameStrategy {
    private IRenameElementContext context;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        this.context = context;
        return super.initialize(targetElement, context);
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        IPath path = this.getPathToRename(this.getTargetElementOriginalURI(), resourceSet);
        if (path != null && path.lastSegment().equals(String.valueOf(this.getOriginalName()) + ".xtend")) {
            updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), (Change)new RenameResourceChange(path, String.valueOf(newName) + "." + path.getFileExtension()));
        }
    }

    protected IPath getPathToRename(URI elementURI, ResourceSet resourceSet) {
        EObject targetObject = resourceSet.getEObject(elementURI, false);
        if (targetObject instanceof XtendTypeDeclaration) {
            URI resourceURI = EcoreUtil2.getNormalizedResourceURI((EObject)targetObject);
            if (!resourceURI.isPlatformResource()) {
                throw new RefactoringException("Renamed type does not reside in the workspace");
            }
            IPath path = new Path("/").append(new Path(resourceURI.path()).removeFirstSegments(1));
            if (this.context instanceof IChangeRedirector.Aware && ((IChangeRedirector.Aware)this.context).getChangeRedirector().getRedirectedPath(path) != path) {
                return null;
            }
            return path;
        }
        return null;
    }
}

