/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ResourceForIEditorInputFactory
implements IResourceForEditorInputFactory {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private IExternalContentSupport externalContentSupport;
    @Inject
    private IExternalContentSupport.IExternalContentProvider externalContentProvider;
    @Inject(optional=true)
    private IWorkspace workspace;

    public Resource createResource(IEditorInput editorInput) {
        try {
            Resource result;
            if (editorInput instanceof IStorageEditorInput) {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                Resource result2 = this.createResource(storage);
                if (result2 != null) {
                    return result2;
                }
            } else if (editorInput instanceof IURIEditorInput && (result = this.createResource(((IURIEditorInput)editorInput).getURI())) != null) {
                return result;
            }
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        throw new IllegalArgumentException("Couldn't create EMF Resource for input " + editorInput);
    }

    protected Resource createResource(java.net.URI uri) {
        ResourceSet resourceSet = this.getResourceSet(null);
        URI emfUri = URI.createURI((String)uri.toString());
        this.configureResourceSet(resourceSet, emfUri);
        XtextResource resource = (XtextResource)this.resourceFactory.createResource(emfUri);
        resourceSet.getResources().add((Object)resource);
        resource.setValidationDisabled(true);
        return resource;
    }

    protected Resource createResource(IStorage storage) throws CoreException {
        return this.createResourceFor(storage);
    }

    protected Resource createResourceFor(IStorage storage) throws CoreException {
        ResourceSet resourceSet = this.getResourceSet(storage);
        URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        this.configureResourceSet(resourceSet, uri);
        URI normalized = resourceSet.getURIConverter().normalize(uri);
        XtextResource resource = (XtextResource)this.resourceFactory.createResource(normalized);
        resourceSet.getResources().add((Object)resource);
        resource.setValidationDisabled(this.isValidationDisabled(storage));
        return resource;
    }

    protected boolean isValidationDisabled(IStorage storage) {
        return false;
    }

    protected XtextResource createResource(ResourceSet resourceSet, URI uri) {
        Resource aResource = resourceSet.createResource(uri, "");
        if (!(aResource instanceof XtextResource)) {
            throw new IllegalStateException("The resource factory registered for " + uri + " does not yield an XtextResource. Make sure the file name extension is correct (case matters).");
        }
        return (XtextResource)aResource;
    }

    protected ResourceSet getResourceSet(@Nullable IStorage storage) {
        IProject project;
        String firstSegment;
        IPath path;
        if (storage instanceof IFile) {
            return this.resourceSetProvider.get(((IFile)storage).getProject());
        }
        if (this.workspace != null && storage != null && (path = storage.getFullPath()) != null && !path.isEmpty() && (firstSegment = path.segment(0)) != null && (project = this.workspace.getRoot().getProject(firstSegment)).isAccessible()) {
            return this.resourceSetProvider.get(project);
        }
        return this.resourceSetProvider.get(null);
    }

    protected void configureResourceSet(ResourceSet resourceSet, URI primaryURI) {
        this.externalContentSupport.configureResourceSet(resourceSet, this.externalContentProvider);
    }

    protected IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected IExternalContentSupport getExternalContentSupport() {
        return this.externalContentSupport;
    }

    protected IExternalContentSupport.IExternalContentProvider getExternalContentProvider() {
        return this.externalContentProvider;
    }

    protected IResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }
}

