/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.validation.XbaseJavaValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseWithAnnotationsJavaValidator
extends XbaseJavaValidator {
    @Inject
    private XAnnotationUtil annotationUtil;
    public static final List<EClass> expressionTypesAllowedAsValues = ImmutableList.builder().add((Object[])new EClass[]{XAnnotationsPackage.Literals.XANNOTATION, XbasePackage.Literals.XLIST_LITERAL, XbasePackage.Literals.XSTRING_LITERAL, XbasePackage.Literals.XBOOLEAN_LITERAL, XbasePackage.Literals.XNUMBER_LITERAL, XbasePackage.Literals.XTYPE_LITERAL, XbasePackage.Literals.XFEATURE_CALL, XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_BINARY_OPERATION}).build();

    @Override
    protected List<EPackage> getEPackages() {
        ArrayList ePackages = Lists.newArrayList(super.getEPackages());
        ePackages.add(XAnnotationsPackage.eINSTANCE);
        return ePackages;
    }

    @Check
    public void checkAllAttributesConfigured(XAnnotation annotation) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) {
            return;
        }
        Iterable attributes = ((JvmAnnotationType)annotationType).getDeclaredOperations();
        for (JvmOperation jvmOperation : attributes) {
            XExpression value = this.annotationUtil.findValue(annotation, jvmOperation);
            if (value == null) {
                if (jvmOperation.getDefaultValue() != null) continue;
                this.error("The annotation must define the attribute '" + jvmOperation.getSimpleName() + "'.", annotation, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_attribute_definition", new String[0]);
                continue;
            }
            this.checkAllowedAnnotationValueExpression(value);
        }
    }

    protected void checkAllowedAnnotationValueExpression(EObject value) {
        for (EObject subExpression : EcoreUtil2.eAllContents((EObject)value)) {
            if (expressionTypesAllowedAsValues.contains(subExpression.eClass())) continue;
            this.error("The value for an annotation attribute must be a constant expression", null, "org.eclipse.xtext.xbase.validation.IssueCodes.no_illegal_value", new String[0]);
        }
    }

    @Override
    protected boolean isImplicitReturn(XExpression expr) {
        if (expr instanceof XAnnotation) {
            return false;
        }
        return super.isImplicitReturn(expr);
    }
}

