/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import org.apache.log4j.Logger;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.xbase.formatting.BooleanKey;
import org.eclipse.xtext.xbase.formatting.IntegerKey;
import org.eclipse.xtext.xbase.formatting.StringKey;

public class FormattingPreferenceValues {
    private static final Logger log = Logger.getLogger(FormattingPreferenceValues.class);
    private IPreferenceValues values;

    public FormattingPreferenceValues(IPreferenceValues values) {
        this.values = values;
    }

    public int get(IntegerKey key) {
        String preference = this.values.getPreference((PreferenceKey)key);
        try {
            if (preference != null) {
                return Integer.valueOf(preference);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Couldn't parse value '" + preference + "' of formatting preference '" + key.getId() + "'."));
        }
        return Integer.valueOf(key.getDefaultValue());
    }

    public boolean get(BooleanKey key) {
        String preference = this.values.getPreference((PreferenceKey)key);
        if (preference != null) {
            return Boolean.valueOf(preference);
        }
        return Boolean.valueOf(key.getDefaultValue());
    }

    public String get(StringKey key) {
        String preference = this.values.getPreference((PreferenceKey)key);
        if (preference != null) {
            return preference;
        }
        return key.getDefaultValue();
    }
}

