/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.ParameterizedTypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FunctionTypeConformanceStrategy
extends ParameterizedTypeConformanceStrategy<FunctionTypeReference> {
    public FunctionTypeConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitParameterizedTypeReference(FunctionTypeReference leftReference, ParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<FunctionTypeReference> param) {
        if (!rightReference.isRawType()) {
            TypeConformanceResult functionsAreConformant;
            FunctionTypeReference converted;
            FunctionTypeReference functionType = rightReference.getAsFunctionTypeReference();
            if (functionType != null) {
                return this.conformanceComputer.isConformant((LightweightTypeReference)leftReference, (LightweightTypeReference)functionType, param);
            }
            if (leftReference.isFunctionType() && (converted = rightReference.tryConvertToFunctionTypeReference(param.rawType)) != null && (functionsAreConformant = this.conformanceComputer.isConformant((LightweightTypeReference)leftReference, (LightweightTypeReference)converted, param)).isConformant()) {
                return TypeConformanceResult.merge(functionsAreConformant, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION));
            }
        }
        return super.doVisitParameterizedTypeReference(leftReference, rightReference, param);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected TypeConformanceResult doVisitFunctionTypeReference(FunctionTypeReference left, FunctionTypeReference right, TypeConformanceComputationArgument.Internal<FunctionTypeReference> param) {
        boolean rightIsVoid;
        LightweightTypeReference rightReturnType;
        List<LightweightTypeReference> leftParameterTypes = left.getParameterTypes();
        List<LightweightTypeReference> rightParameterTypes = right.getParameterTypes();
        if (leftParameterTypes.size() != rightParameterTypes.size()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        LightweightTypeReference leftReturnType = left.getReturnType();
        if (leftReturnType != (rightReturnType = right.getReturnType()) && (leftReturnType == null || rightReturnType == null)) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        boolean leftIsVoid = leftReturnType != null && leftReturnType.isPrimitiveVoid();
        boolean bl = rightIsVoid = rightReturnType != null && rightReturnType.isPrimitiveVoid();
        if (leftIsVoid) {
            if (!rightIsVoid) return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            if (param.rawType) {
                return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
            }
        } else {
            if (rightIsVoid) {
                return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            }
            if (param.rawType) {
                return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
            }
        }
        if (param.rawType) {
            throw new IllegalStateException("rawTypeComputation should have exited earlier");
        }
        TypeConformanceComputationArgument argument = new TypeConformanceComputationArgument(false, false, true, false, param.unboundComputationAddsHints, param.allowSynonyms);
        if (leftReturnType != rightReturnType && !this.conformanceComputer.isConformant(leftReturnType, rightReturnType, argument).isConformant()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        int i = 0;
        while (i < leftParameterTypes.size()) {
            LightweightTypeReference rightParameterType;
            LightweightTypeReference leftParameterType = leftParameterTypes.get(i);
            if (leftParameterType != (rightParameterType = rightParameterTypes.get(i)) && (leftParameterType == null || rightParameterType == null)) {
                return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            }
            if (!this.conformanceComputer.isConformant(rightParameterType, leftParameterType, argument).isConformant()) {
                return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            }
            ++i;
        }
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
    }
}

