/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.io.Serializable;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ParameterizedTypeConformanceStrategy<TypeReference extends ParameterizedTypeReference>
extends TypeConformanceStrategy<TypeReference> {
    public ParameterizedTypeConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitArrayTypeReference(TypeReference left, ArrayTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        ParameterizedTypeReference rightAsList;
        TypeConformanceResult result;
        if (((ParameterizedTypeReference)left).isType(Object.class)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUBTYPE);
        }
        if (((ParameterizedTypeReference)left).isType(Serializable.class)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUBTYPE);
        }
        if (((ParameterizedTypeReference)left).isType(Cloneable.class)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUBTYPE);
        }
        if (((LightweightTypeReference)left).isSubtypeOf(Iterable.class) && param.allowSynonyms && (result = this.conformanceComputer.isConformant((LightweightTypeReference)left, (LightweightTypeReference)(rightAsList = right.tryConvertToListType()), param)).isConformant()) {
            return TypeConformanceResult.merge(result, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION, ConformanceHint.SYNONYM));
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected TypeConformanceResult doVisitParameterizedTypeReference(TypeReference leftReference, ParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        ArrayTypeReference rightAsArray;
        TypeConformanceResult result;
        JvmGenericType castedLeftType;
        if (((ParameterizedTypeReference)leftReference).getType() == rightReference.getType()) {
            return this.getConformanceResultForEqualTypes(leftReference, rightReference, param);
        }
        if (((ParameterizedTypeReference)leftReference).isType(Void.TYPE) || rightReference.isType(Void.TYPE)) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        if (param.allowPrimitiveConversion || param.allowPrimitiveWidening) {
            if (((ParameterizedTypeReference)leftReference).isPrimitive()) {
                CommonTypeComputationServices services = ((LightweightTypeReference)leftReference).getOwner().getServices();
                Primitives primitives = services.getPrimitives();
                JvmPrimitiveType leftType = (JvmPrimitiveType)((ParameterizedTypeReference)leftReference).getType();
                JvmType rightType = rightReference.getType();
                if (rightReference.isPrimitive()) {
                    if (!param.allowPrimitiveWidening || !this.isWideningConversion(primitives, leftType, (JvmPrimitiveType)rightType)) return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                    return TypeConformanceResult.create(param, ConformanceHint.PRIMITIVE_WIDENING);
                }
                if (!param.allowPrimitiveConversion) return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                LightweightTypeReference primitive = rightReference.getPrimitiveIfWrapperType();
                if (primitive.isPrimitive()) {
                    JvmPrimitiveType rightPrimitiveType = (JvmPrimitiveType)primitive.getType();
                    if (rightPrimitiveType == null || rightPrimitiveType != leftType && !this.isWideningConversion(primitives, leftType, rightPrimitiveType)) return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                    return TypeConformanceResult.create(param, ConformanceHint.UNBOXING);
                }
            } else if (param.allowPrimitiveConversion && rightReference.isPrimitive()) {
                if (((ParameterizedTypeReference)leftReference).isType(Object.class)) {
                    return TypeConformanceResult.create(param, ConformanceHint.BOXING);
                }
                if (((ParameterizedTypeReference)leftReference).isType(String.class)) {
                    return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                }
                LightweightTypeReference wrapper = rightReference.getWrapperTypeIfPrimitive();
                TypeConformanceResult result2 = this.conformanceComputer.isConformant((LightweightTypeReference)leftReference, wrapper, param);
                if (result2.isConformant()) {
                    return TypeConformanceResult.create(param, ConformanceHint.BOXING);
                }
            }
        }
        if (param.asTypeArgument) return this.isAssignableAsFunctionType(leftReference, rightReference, param);
        if (((ParameterizedTypeReference)leftReference).isType(Object.class)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        JvmType leftType = ((ParameterizedTypeReference)leftReference).getType();
        if (leftType instanceof JvmGenericType ? (castedLeftType = (JvmGenericType)leftType).isFinal() && !(rightReference.getType() instanceof JvmTypeParameter) : leftType instanceof JvmTypeParameter && !(rightReference.getType() instanceof JvmTypeParameter)) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        TypeConformanceComputationArgument paramWithoutSuperTypeCheck = new TypeConformanceComputationArgument(param.rawType, true, param.allowPrimitiveConversion, param.allowPrimitiveWidening, param.unboundComputationAddsHints, param.allowSynonyms);
        if (leftType instanceof JvmPrimitiveType) {
            leftType = ((ParameterizedTypeReference)leftReference).getWrapperTypeIfPrimitive().getType();
        }
        if (leftType == null) {
            throw new IllegalStateException("Cannot determine raw type for " + leftType);
        }
        LightweightTypeReference rightSuperType = rightReference.getSuperType(leftType);
        if (rightSuperType != null && (result = this.conformanceComputer.isConformant((LightweightTypeReference)leftReference, rightSuperType, paramWithoutSuperTypeCheck)).isConformant()) {
            return TypeConformanceResult.merge(result, TypeConformanceResult.create(param, ConformanceHint.SUBTYPE));
        }
        if (!param.allowSynonyms || !((ParameterizedTypeReference)leftReference).isType(Serializable.class) && !((ParameterizedTypeReference)leftReference).isType(Cloneable.class) || (rightAsArray = rightReference.tryConvertToArray()) == null) return this.isAssignableAsFunctionType(leftReference, rightReference, param);
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS, ConformanceHint.SUBTYPE, ConformanceHint.DEMAND_CONVERSION, ConformanceHint.SYNONYM);
    }

    protected TypeConformanceResult getConformanceResultForEqualTypes(TypeReference leftReference, ParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        if (param.rawType) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        if (((LightweightTypeReference)leftReference).isRawType() || rightReference.isRawType()) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS, ConformanceHint.RAWTYPE_CONVERSION);
        }
        if (((ParameterizedTypeReference)leftReference).getTypeArguments().isEmpty() || rightReference.getTypeArguments().isEmpty()) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return this.areArgumentsConformant((ParameterizedTypeReference)leftReference, rightReference, param.unboundComputationAddsHints, param);
    }

    protected TypeConformanceResult isAssignableAsFunctionType(TypeReference leftReference, ParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        FunctionTypeReference leftFunctionType = ((ParameterizedTypeReference)leftReference).getAsFunctionTypeReference();
        if (leftFunctionType != null) {
            TypeConformanceResult functionsAreConformant;
            FunctionTypeReference rightFunctionType = rightReference.getAsFunctionTypeReference();
            if (rightFunctionType != null) {
                return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            }
            rightFunctionType = rightReference.tryConvertToFunctionTypeReference(param.rawType);
            if (rightFunctionType != null && (functionsAreConformant = this.conformanceComputer.isConformant((LightweightTypeReference)leftFunctionType, (LightweightTypeReference)rightFunctionType, param)).isConformant()) {
                return TypeConformanceResult.merge(functionsAreConformant, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION));
            }
        } else {
            TypeConformanceResult functionsAreConformant;
            FunctionTypeReference rightFunctionType = rightReference.getAsFunctionTypeReference();
            if (rightFunctionType != null && (leftFunctionType = ((ParameterizedTypeReference)leftReference).tryConvertToFunctionTypeReference(param.rawType)) != null && (functionsAreConformant = this.conformanceComputer.isConformant((LightweightTypeReference)leftFunctionType, (LightweightTypeReference)rightFunctionType, param)).isConformant()) {
                return TypeConformanceResult.merge(functionsAreConformant, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION));
            }
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitFunctionTypeReference(TypeReference left, FunctionTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        if (!((LightweightTypeReference)left).isRawType()) {
            TypeConformanceResult functionsAreConformant;
            FunctionTypeReference converted;
            FunctionTypeReference functionType = ((ParameterizedTypeReference)left).getAsFunctionTypeReference();
            if (functionType != null) {
                return this.conformanceComputer.isConformant((LightweightTypeReference)functionType, (LightweightTypeReference)right, param);
            }
            if (right.getFunctionTypeKind() != FunctionTypeKind.NONE && (converted = ((ParameterizedTypeReference)left).tryConvertToFunctionTypeReference(param.rawType)) != null && (functionsAreConformant = this.conformanceComputer.isConformant((LightweightTypeReference)converted, (LightweightTypeReference)right, param)).isConformant()) {
                return TypeConformanceResult.merge(functionsAreConformant, TypeConformanceResult.create(param, ConformanceHint.DEMAND_CONVERSION));
            }
        }
        return super.doVisitFunctionTypeReference(left, right, param);
    }

    @Override
    protected TypeConformanceResult doVisitWildcardTypeReference(TypeReference left, WildcardTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        if (!param.isAsTypeArgument()) {
            for (LightweightTypeReference upperBound : right.getUpperBounds()) {
                TypeConformanceResult result = this.conformanceComputer.isConformant((LightweightTypeReference)left, upperBound, param);
                if (!result.isConformant()) continue;
                return result;
            }
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    protected boolean isWideningConversion(Primitives primitives, JvmPrimitiveType leftType, JvmPrimitiveType rightType) {
        Primitives.Primitive left = primitives.primitiveKind(leftType);
        Primitives.Primitive right = primitives.primitiveKind(rightType);
        switch (right) {
            case Byte: {
                return left == Primitives.Primitive.Short || left == Primitives.Primitive.Char || left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Short: {
                return left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Char: {
                return left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Int: {
                return left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Long: {
                return left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Float: {
                return left == Primitives.Primitive.Double;
            }
        }
        return false;
    }

    protected TypeConformanceResult areArgumentsConformant(ParameterizedTypeReference leftReference, ParameterizedTypeReference rightReference, boolean unboundAddsHints, TypeConformanceComputationArgument param) {
        if (leftReference.getType() != rightReference.getType()) {
            throw new IllegalArgumentException("cannot compare type arguments for different base types");
        }
        List<LightweightTypeReference> leftTypeArguments = leftReference.getTypeArguments();
        List<LightweightTypeReference> rightTypeArguments = rightReference.getTypeArguments();
        if (leftTypeArguments.size() != rightTypeArguments.size()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        TypeConformanceComputationArgument argument = new TypeConformanceComputationArgument(false, true, false, false, unboundAddsHints, false);
        int i = 0;
        while (i < leftTypeArguments.size()) {
            if (!this.conformanceComputer.isConformant(leftTypeArguments.get(i), rightTypeArguments.get(i), argument).isConformant()) {
                return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
            }
            ++i;
        }
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
    }

    @Override
    protected TypeConformanceResult doVisitAnyTypeReference(TypeReference left, AnyTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        if (((ParameterizedTypeReference)left).isPrimitive() || ((LightweightTypeReference)left).isPrimitiveVoid()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
    }

    @Override
    protected TypeConformanceResult doVisitUnboundTypeReference(TypeReference left, UnboundTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        if (((ParameterizedTypeReference)left).getType() == right.getType()) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        if (((ParameterizedTypeReference)left).isType(Object.class)) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        boolean doesNotHaveSignificantHints = false;
        if (!param.isRawType() && (right.canResolveTo((LightweightTypeReference)left) || param.isAsTypeArgument() && (doesNotHaveSignificantHints = !right.hasSignificantHints()))) {
            if (param.unboundComputationAddsHints && doesNotHaveSignificantHints) {
                right.acceptHint((LightweightTypeReference)left, BoundTypeArgumentSource.INFERRED_LATER, left, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        right.tryResolve();
        LightweightTypeReference resolvedTo = right.getResolvedTo();
        if (resolvedTo != null) {
            return this.conformanceComputer.isConformant((LightweightTypeReference)left, (LightweightTypeReference)right, param);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitTypeReference(TypeReference left, LightweightTypeReference right, TypeConformanceComputationArgument.Internal<TypeReference> param) {
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }
}

