/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ResourceUtil {
    public static IContainer getContainer(IProject project, String path) {
        Preconditions.checkNotNull((Object)project, (Object)"parameter 'project' must not be null");
        Preconditions.checkNotNull((Object)path, (Object)"parameter 'path' must not be null");
        if (".".equals(path) || "./".equals(path) || "".equals(path)) {
            return project;
        }
        return project.getFolder(path);
    }

    public static IFile getFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return ResourceUtil.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, false);
    }

    public static IFile getUnderlyingFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return ResourceUtil.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, true);
    }

    private static IFile getFile(URI uri, URIConverter converter, boolean considerArchives) {
        URI normalized;
        IFile result = null;
        if (considerArchives && uri.isArchive()) {
            class MyArchiveURLConnection
            extends ArchiveURLConnection {
                public MyArchiveURLConnection(String url) {
                    super(url);
                }

                public String getNestedURI() {
                    try {
                        return this.getNestedURL();
                    }
                    catch (IOException exception) {
                        return "";
                    }
                }
            }
            MyArchiveURLConnection archiveURLConnection = new MyArchiveURLConnection(uri.toString());
            result = ResourceUtil.getFile(URI.createURI((String)archiveURLConnection.getNestedURI()), converter, considerArchives);
        } else if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (converter != null && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            result = ResourceUtil.getFile(normalized, converter, considerArchives);
        }
        if (result == null && !uri.isRelative()) {
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()));
                if (files.length > 0) {
                    result = files[0];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }
}

