/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.ui.refactoring.IChangeRedirector;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.FixedCompositeChange;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;

public class RefactoringUpdateAcceptor
implements IRefactoringUpdateAcceptor,
IChangeRedirector.Aware {
    private IRefactoringDocument.Provider refactoringDocumentProvider;
    @Inject
    private StatusWrapper status;
    private Map<URI, IRefactoringDocument> uri2document = Maps.newHashMap();
    private Multimap<IRefactoringDocument, TextEdit> document2textEdits = LinkedHashMultimap.create();
    private Multimap<IRefactoringDocument, Change> document2change = LinkedHashMultimap.create();

    @Inject
    public RefactoringUpdateAcceptor(IRefactoringDocument.Provider refactoringDocumentProvider) {
        this.refactoringDocumentProvider = refactoringDocumentProvider;
    }

    public void accept(URI resourceURI, TextEdit textEdit) {
        IRefactoringDocument document = this.getDocument(resourceURI);
        this.document2textEdits.put((Object)document, (Object)textEdit);
    }

    public void accept(URI resourceURI, Change change) {
        IRefactoringDocument document = this.getDocument(resourceURI);
        this.document2change.put((Object)document, (Object)change);
    }

    public IRefactoringDocument getDocument(URI resourceURI) {
        IRefactoringDocument document = this.uri2document.get(resourceURI);
        if (document != null) {
            return document;
        }
        IRefactoringDocument newDocument = this.refactoringDocumentProvider.get(resourceURI, this.status);
        this.uri2document.put(resourceURI, newDocument);
        return newDocument;
    }

    public StatusWrapper getRefactoringStatus() {
        return this.status;
    }

    public Change createCompositeChange(String name, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.document2textEdits.keySet().size() + this.document2change.keySet().size()));
        if (this.document2change.isEmpty() && this.document2textEdits.isEmpty()) {
            return null;
        }
        FixedCompositeChange compositeChange = new FixedCompositeChange(name);
        for (IRefactoringDocument document : this.document2textEdits.keySet()) {
            Collection textEdits = this.document2textEdits.get((Object)document);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            for (TextEdit textEdit : textEdits) {
                multiTextEdit.addChild(textEdit);
            }
            Change change = document.createChange(name, (TextEdit)multiTextEdit);
            compositeChange.add(change);
            progress.worked(1);
        }
        for (IRefactoringDocument document : this.document2change.keySet()) {
            Collection documentChanges = this.document2change.get((Object)document);
            FixedCompositeChange documentCompositeChange = new FixedCompositeChange(name);
            documentCompositeChange.addAll((Change[])Iterables.toArray((Iterable)documentChanges, Change.class));
            compositeChange.add((Change)documentCompositeChange);
            progress.worked(1);
        }
        return compositeChange;
    }

    public void setChangeRedirector(IChangeRedirector changeRedirector) {
        if (this.refactoringDocumentProvider instanceof IChangeRedirector.Aware) {
            ((IChangeRedirector.Aware)((Object)this.refactoringDocumentProvider)).setChangeRedirector(changeRedirector);
        }
    }

    public IChangeRedirector getChangeRedirector() {
        if (this.refactoringDocumentProvider instanceof IChangeRedirector.Aware) {
            return ((IChangeRedirector.Aware)((Object)this.refactoringDocumentProvider)).getChangeRedirector();
        }
        return IChangeRedirector.NULL;
    }
}

