/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperExtension;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.SourceAttachmentPackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.Storage2UriMapperImpl;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Storage2UriMapperJavaImpl
extends Storage2UriMapperImpl
implements IStorage2UriMapperJdtExtensions,
IStorage2UriMapperExtension {
    private static final Logger log = Logger.getLogger(Storage2UriMapperJavaImpl.class);
    @Inject
    private JarEntryLocator locator;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private IJdtHelper jdtHelper;
    private Map<String, PackageFragmentRootData> cachedPackageFragmentRootData = Maps.newLinkedHashMap();
    @Inject
    private IWorkspace workspace;
    private boolean isInitialized = false;

    @Override
    public void setUriValidator(UriValidator uriValidator) {
        super.setUriValidator(uriValidator);
        this.uriValidator = uriValidator;
    }

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }

    public void setLocator(JarEntryLocator locator) {
        this.locator = locator;
    }

    @Override
    protected boolean isHandled(IFolder folder) {
        return super.isHandled(folder) && this.jdtHelper != null && !this.jdtHelper.isFromOutputPath((IResource)folder);
    }

    @Override
    public Pair<URI, URI> getURIMapping(IPackageFragmentRoot root) throws JavaModelException {
        PackageFragmentRootData data = this.getData(root);
        if (data.uriPrefix == null) {
            return null;
        }
        IPath path = root.isExternal() ? root.getPath() : root.getUnderlyingResource().getLocation();
        URI physical = null;
        if (root.isArchive()) {
            String archiveScheme = "zip".equalsIgnoreCase(root.getPath().getFileExtension()) ? "zip" : "jar";
            physical = URI.createURI((String)(String.valueOf(archiveScheme) + ":file:" + path.toFile().getPath() + "!/"));
        } else {
            physical = URI.createFileURI((String)(String.valueOf(path.toFile().getPath()) + "/"));
        }
        return Tuples.create((Object)data.uriPrefix, (Object)physical);
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IPackageFragmentRoot root) {
        try {
            if (root.getUnderlyingResource() instanceof IFolder) {
                return this.getAllEntries((IContainer)((IFolder)root.getUnderlyingResource()));
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
        PackageFragmentRootData data = this.getData(root);
        return data.uri2Storage;
    }

    private PackageFragmentRootData getData(IPackageFragmentRoot root) {
        boolean isCachable;
        boolean bl = isCachable = root.isArchive() || root.isExternal();
        if (isCachable) {
            return this.getCachedData(root);
        }
        PackageFragmentRootData data = this.initializeData(root);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageFragmentRootData getCachedData(IPackageFragmentRoot root) {
        String id = root.getHandleIdentifier();
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            if (this.cachedPackageFragmentRootData.containsKey(id)) {
                PackageFragmentRootData data = this.cachedPackageFragmentRootData.get(id);
                if (this.isUpToDate(data, root)) {
                    return data;
                }
                this.cachedPackageFragmentRootData.remove(id);
            }
        }
        PackageFragmentRootData data = this.initializeData(root);
        Map<String, PackageFragmentRootData> map2 = this.cachedPackageFragmentRootData;
        synchronized (map2) {
            this.cachedPackageFragmentRootData.put(id, data);
        }
        return data;
    }

    private boolean isUpToDate(PackageFragmentRootData data, IPackageFragmentRoot root) {
        return Objects.equal((Object)data.modificationStamp, (Object)this.computeModificationStamp(root));
    }

    private Object computeModificationStamp(IPackageFragmentRoot root) {
        try {
            if (root.exists()) {
                IResource resource = root.getUnderlyingResource();
                if (resource != null) {
                    return resource.getLocation().toFile().lastModified();
                }
                return root.getPath().toFile().lastModified();
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Object();
    }

    protected PackageFragmentRootData initializeData(final IPackageFragmentRoot root) {
        final PackageFragmentRootData data = new PackageFragmentRootData(root, this.computeModificationStamp(root));
        try {
            SourceAttachmentPackageFragmentRootWalker<Void> walker = new SourceAttachmentPackageFragmentRootWalker<Void>(){

                @Override
                protected URI getURI(IFile file, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)file)) {
                        return null;
                    }
                    return super.getURI(file, state);
                }

                @Override
                protected URI getURI(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)jarEntry)) {
                        return null;
                    }
                    URI uri = Storage2UriMapperJavaImpl.this.locator.getURI(root, jarEntry, state);
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isValid(uri, (IStorage)jarEntry)) {
                        return null;
                    }
                    return uri;
                }

                @Override
                protected Void handle(URI uri, IStorage storage, PackageFragmentRootWalker.TraversalState state) {
                    data.uri2Storage.put(uri, storage);
                    return null;
                }
            };
            walker.traverse(root, false);
            if (walker.getBundleSymbolicName() != null) {
                data.uriPrefix = URI.createPlatformResourceURI((String)(String.valueOf(walker.getBundleSymbolicName()) + "/"), (boolean)true);
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        ArrayList packageFragmentRootDatas;
        Iterable<Pair<IStorage, IProject>> storages = super.getStorages(uri);
        if (!Iterables.isEmpty(storages)) {
            return storages;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)1);
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            packageFragmentRootDatas = Lists.newArrayList(this.cachedPackageFragmentRootData.values());
        }
        Iterator iterator = packageFragmentRootDatas.iterator();
        while (iterator.hasNext()) {
            PackageFragmentRootData data = (PackageFragmentRootData)iterator.next();
            if (data.root.exists()) {
                IStorage storage;
                if (data.uriPrefix != null && !uri.toString().startsWith(data.uriPrefix.toString()) || (storage = data.uri2Storage.get(uri)) == null) continue;
                result.add(Tuples.create((Object)storage, (Object)data.root.getJavaProject().getProject()));
                continue;
            }
            iterator.remove();
        }
        if (result.isEmpty() && uri.isArchive()) {
            String authority = uri.authority();
            URI archiveURI = URI.createURI((String)(authority = authority.substring(0, authority.length() - 1)));
            if (archiveURI.isFile() || archiveURI.isPlatformResource()) {
                Path archivePath = new Path(archiveURI.isPlatformResource() ? archiveURI.toPlatformString(true) : archiveURI.toFileString());
                for (PackageFragmentRootData data : packageFragmentRootDatas) {
                    URI prefix;
                    URI expectedURI;
                    IStorage storage;
                    if (data.uriPrefix == null || !archivePath.equals((Object)data.root.getPath()) || (storage = data.uri2Storage.get(expectedURI = (prefix = data.uriPrefix.lastSegment().length() == 0 ? data.uriPrefix.trimSegments(1) : data.uriPrefix).appendSegments(uri.segments()))) == null) continue;
                    result.add(Tuples.create((Object)storage, (Object)data.root.getJavaProject().getProject()));
                }
            }
        }
        return result;
    }

    @Override
    protected URI internalGetUri(IStorage storage) {
        if (!this.uriValidator.isPossiblyManaged(storage)) {
            return null;
        }
        URI uri = super.internalGetUri(storage);
        if (uri != null) {
            return uri;
        }
        if (storage instanceof IJarEntryResource) {
            IJarEntryResource storage2 = (IJarEntryResource)storage;
            Map<URI, IStorage> data = this.getAllEntries(storage2.getPackageFragmentRoot());
            for (Map.Entry<URI, IStorage> entry : data.entrySet()) {
                if (!entry.getValue().equals(storage2)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Deprecated
    public void elementChanged(ElementChangedEvent changeEvent) {
        log.warn((Object)"Storage2UriMapperJavaImpl.elementChanged(ElementChangedEvent) is deperecated and does nothing.");
    }

    private void updateCache(IJavaProject project) {
        try {
            HashSet datas = Sets.newHashSet();
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isCachable;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                boolean bl = isCachable = root.isArchive() || root.isExternal();
                if (isCachable) {
                    datas.add(this.getCachedData(root));
                }
                ++n2;
            }
            this.clearCache(project, datas);
        }
        catch (JavaModelException e) {
            log.error((Object)("Error getting package fragments roots of " + project.getElementName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(IJavaProject project, Set<PackageFragmentRootData> toBeKept) {
        ArrayList values;
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            values = Lists.newArrayList(this.cachedPackageFragmentRootData.values());
        }
        ArrayList toBeRemoved = Lists.newArrayList();
        for (PackageFragmentRootData data : values) {
            if (data.root == null || !project.equals(data.root.getJavaProject()) || toBeKept.contains(data)) continue;
            toBeRemoved.add(data);
        }
        if (!toBeRemoved.isEmpty()) {
            Map<String, PackageFragmentRootData> map2 = this.cachedPackageFragmentRootData;
            synchronized (map2) {
                this.cachedPackageFragmentRootData.values().removeAll(toBeRemoved);
            }
        }
    }

    @Override
    public void initializeCache() {
        if (!this.isInitialized) {
            IProject[] iProjectArray = this.workspace.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && JavaProject.hasJavaNature((IProject)project)) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    this.updateCache(javaProject);
                }
                ++n2;
            }
            JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

                public void elementChanged(ElementChangedEvent event) {
                    Set javaProjectsWithClasspathChange = Storage2UriMapperJavaImpl.this.getJavaProjectsWithClasspathChange(event.getDelta());
                    if (!javaProjectsWithClasspathChange.isEmpty()) {
                        for (IJavaProject project : javaProjectsWithClasspathChange) {
                            Storage2UriMapperJavaImpl.this.updateCache(project);
                        }
                        return;
                    }
                    for (IJavaElementDelta projectDelta : Storage2UriMapperJavaImpl.this.getProjectDeltas(event.getDelta())) {
                        IJavaProject project = (IJavaProject)projectDelta.getElement();
                        if ((projectDelta.getKind() & 2) != 0) {
                            Storage2UriMapperJavaImpl.this.clearCache(project, Collections.emptySet());
                            return;
                        }
                        switch (projectDelta.getFlags()) {
                            case 512: {
                                Storage2UriMapperJavaImpl.this.updateCache(project);
                                break;
                            }
                            case 1024: {
                                Storage2UriMapperJavaImpl.this.clearCache(project, Collections.emptySet());
                            }
                        }
                    }
                }
            }, (int)1);
            this.isInitialized = true;
        }
    }

    private Set<IJavaElementDelta> getProjectDeltas(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (delta.getElement().getElementType() == 2) {
            return Collections.singleton(delta);
        }
        LinkedHashSet result = null;
        if (element instanceof IJavaModel && delta.getAddedChildren() != null) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                Set<IJavaElementDelta> projectDeltas = this.getProjectDeltas(child);
                if (!projectDeltas.isEmpty()) {
                    if (result == null) {
                        result = Sets.newLinkedHashSet();
                    }
                    result.addAll(projectDeltas);
                }
                ++n2;
            }
        }
        return result == null ? Collections.emptySet() : result;
    }

    private Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (delta.getKind() == 2 || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || root.isExternal() && (delta.getFlags() & 0x3001) == delta.getFlags()) {
                return Collections.singleton(root.getJavaProject());
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.getPackageFragmentRootDeltas(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if ((delta.getFlags() & 0x20000) != 0 || (delta.getFlags() & 0x200000) != 0) {
                    return Collections.singleton((IJavaProject)element);
                }
                return this.getPackageFragmentRootDeltas(delta.getAffectedChildren());
            }
        }
        return Collections.emptySet();
    }

    private Set<IJavaProject> getPackageFragmentRootDeltas(IJavaElementDelta[] affectedChildren) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            set.addAll(this.getJavaProjectsWithClasspathChange(delta));
            ++n2;
        }
        return set;
    }

    static class PackageFragmentRootData {
        public URI uriPrefix;
        public final Object modificationStamp;
        public final IPackageFragmentRoot root;
        public Map<URI, IStorage> uri2Storage = Maps.newLinkedHashMap();

        public PackageFragmentRootData(IPackageFragmentRoot root, Object modificationStamp) {
            this.modificationStamp = modificationStamp;
            this.root = root;
        }

        public String toString() {
            return String.valueOf(this.root.toString()) + " / " + this.uriPrefix;
        }
    }
}

