/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;

public class JdtToBeBuiltComputer
implements IToBeBuiltComputerContribution {
    private static final Logger log = Logger.getLogger(JdtToBeBuiltComputer.class);
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IWorkspace workspace;
    @Inject
    private ModificationStampCache modificationStampCache;
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private IStorage2UriMapperJdtExtensions jdtUriMapperExtension;

    public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return;
        }
        this.modificationStampCache.projectToModificationStamp.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!project.isAccessible() || progress.isCanceled()) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            progress.setWorkRemaining(roots.length);
            HashMap updated = Maps.newHashMap();
            IWorkspace.ProjectOrder orderedProjects = this.workspace.computeProjectOrder(this.workspace.getRoot().getProjects());
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (progress.isCanceled()) {
                    return;
                }
                if (this.shouldHandle(root) && !this.isBuiltByUpstream(root, project, orderedProjects.projects)) {
                    Map rootData = this.jdtUriMapperExtension.getAllEntries(root);
                    for (Map.Entry e : rootData.entrySet()) {
                        if (!this.uriValidator.canBuild((URI)e.getKey(), (IStorage)e.getValue())) continue;
                        toBeBuilt.getToBeDeleted().add((URI)e.getKey());
                        toBeBuilt.getToBeUpdated().add((URI)e.getKey());
                    }
                }
                progress.worked(1);
                ++n2;
            }
            ModificationStampCache modificationStampCache = this.modificationStampCache;
            synchronized (modificationStampCache) {
                this.modificationStampCache.projectToModificationStamp.putAll(updated);
            }
        }
    }

    protected boolean isBuiltByUpstream(IPackageFragmentRoot root, IProject project, IProject[] projectsInCorrectBuildOrder) {
        IProject[] iProjectArray = projectsInCorrectBuildOrder;
        int n = projectsInCorrectBuildOrder.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IProject p = iProjectArray[n2];
            if (p.equals((Object)project)) {
                return false;
            }
            if (XtextProjectHelper.hasNature((IProject)p) && XtextProjectHelper.hasBuilder((IProject)p) && (javaProject = JavaCore.create((IProject)p)).exists() && javaProject.isOnClasspath((IJavaElement)root)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Build of project '" + project.getName() + "' skips indexing classpath entry '" + root.getPath() + "' because it already indexed by " + javaProject.getElementName()));
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean shouldHandle(IPackageFragmentRoot root) {
        try {
            boolean result = !JavaRuntime.newDefaultJREContainerPath().isPrefixOf(root.getRawClasspathEntry().getPath());
            return result &= root.isArchive() || root.isExternal();
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        if (storage instanceof IFile && JavaCore.isJavaLikeFileName((String)storage.getName())) {
            IJavaElement element = JavaCore.create((IResource)((IFile)storage).getParent());
            String fileName = storage.getName();
            String typeName = fileName.substring(0, fileName.lastIndexOf(46));
            if (element instanceof IPackageFragmentRoot) {
                this.queueJavaChange(typeName);
                return true;
            }
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                this.queueJavaChange(String.valueOf(packageFragment.getElementName()) + "." + typeName);
                return true;
            }
        }
        return false;
    }

    public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        return false;
    }

    protected void queueJavaChange(String typeName) {
        URI typeURI = this.typeURIHelper.createResourceURIForFQN(typeName);
        TypeResourceDescription oldDescription = new TypeResourceDescription(typeURI, Collections.emptyList());
        ChangedResourceDescriptionDelta delta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
        this.queuedBuildData.queueChange((IResourceDescription.Delta)delta);
    }

    public boolean isPossiblyHandled(IStorage resource) {
        return resource instanceof IJarEntryResource;
    }

    public boolean isRejected(IFolder folder) {
        boolean result = this.jdtHelper.isFromOutputPath((IResource)folder);
        return result;
    }

    @Singleton
    public static class ModificationStampCache {
        protected Map<String, Long> projectToModificationStamp = Maps.newHashMap();
    }
}

