/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public class ConstantExpressionValidator {
    @Inject
    @Extension
    private TypeReferences _typeReferences;
    @Inject
    @Extension
    private Primitives _primitives;
    @Inject
    @Extension
    private XExpressionHelper _xExpressionHelper;

    protected boolean _isConstant(XExpression expression) {
        return false;
    }

    protected boolean _isConstant(XStringLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XTypeLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XNumberLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XBooleanLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XCastedExpression expression) {
        boolean _or = false;
        JvmTypeReference _type = expression.getType();
        boolean _isPrimitive = this._primitives.isPrimitive(_type);
        if (_isPrimitive) {
            _or = true;
        } else {
            JvmTypeReference _type_1 = expression.getType();
            boolean _is = this._typeReferences.is(_type_1, String.class);
            _or = _isPrimitive || _is;
        }
        return _or;
    }

    protected boolean _isConstant(XAbstractFeatureCall expression) {
        JvmIdentifiableElement _feature;
        JvmIdentifiableElement feature = _feature = expression.getFeature();
        boolean _matched = false;
        if (!_matched && feature instanceof JvmField) {
            _matched = true;
            boolean _and = false;
            boolean _isStatic = ((JvmField)feature).isStatic();
            if (!_isStatic) {
                _and = false;
            } else {
                boolean _isFinal = ((JvmField)feature).isFinal();
                _and = _isStatic && _isFinal;
            }
            return _and;
        }
        if (!_matched && feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            return true;
        }
        if (!_matched && feature instanceof JvmOperation) {
            Functions.Function1<JvmBooleanAnnotationValue, Boolean> _function;
            _matched = true;
            JvmAnnotationReference annotationReference = this._xExpressionHelper.findInlineAnnotation(expression);
            boolean _equals = Objects.equal((Object)annotationReference, null);
            if (_equals) {
                return false;
            }
            EList _values = annotationReference.getValues();
            Iterable _filter = Iterables.filter((Iterable)_values, JvmBooleanAnnotationValue.class);
            boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<JvmBooleanAnnotationValue, Boolean>(){

                public Boolean apply(JvmBooleanAnnotationValue it) {
                    boolean _and = false;
                    String _valueName = it.getValueName();
                    boolean _equals = Objects.equal((Object)_valueName, (Object)"constantExpression");
                    if (!_equals) {
                        _and = false;
                    } else {
                        EList _values = it.getValues();
                        Boolean _head = (Boolean)IterableExtensions.head((Iterable)_values);
                        boolean _booleanValue = _head;
                        _and = _equals && _booleanValue;
                    }
                    return _and;
                }
            }));
            if (_exists) {
                boolean _xifexpression = false;
                XExpression _actualReceiver = expression.getActualReceiver();
                boolean _equals_1 = Objects.equal((Object)_actualReceiver, null);
                if (_equals_1) {
                    _xifexpression = true;
                } else {
                    boolean _isConstant;
                    XExpression _actualReceiver_1 = expression.getActualReceiver();
                    _xifexpression = _isConstant = this.isConstant(_actualReceiver_1);
                }
                boolean receiverConstant = _xifexpression;
                boolean _and = false;
                if (!receiverConstant) {
                    _and = false;
                } else {
                    EList<XExpression> _actualArguments = expression.getActualArguments();
                    Functions.Function1<XExpression, Boolean> _function_1 = new Functions.Function1<XExpression, Boolean>(){

                        public Boolean apply(XExpression it) {
                            boolean _isConstant = ConstantExpressionValidator.this.isConstant(it);
                            return _isConstant;
                        }
                    };
                    boolean _forall = IterableExtensions.forall(_actualArguments, (Functions.Function1)_function_1);
                    _and = receiverConstant && _forall;
                }
                return _and;
            }
        }
        return false;
    }

    public boolean isConstant(XExpression expression) {
        if (expression instanceof XAbstractFeatureCall) {
            return this._isConstant((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBooleanLiteral) {
            return this._isConstant((XBooleanLiteral)expression);
        }
        if (expression instanceof XCastedExpression) {
            return this._isConstant((XCastedExpression)expression);
        }
        if (expression instanceof XNumberLiteral) {
            return this._isConstant((XNumberLiteral)expression);
        }
        if (expression instanceof XStringLiteral) {
            return this._isConstant((XStringLiteral)expression);
        }
        if (expression instanceof XTypeLiteral) {
            return this._isConstant((XTypeLiteral)expression);
        }
        if (expression != null) {
            return this._isConstant(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }
}

