/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokedResolvedOperation
extends BottomResolvedOperation {
    private final List<LightweightTypeReference> typeArguments;

    protected InvokedResolvedOperation(JvmOperation operation, LightweightTypeReference contextType, List<LightweightTypeReference> typeArguments, OverrideTester overrideTester) {
        super(operation, contextType, overrideTester);
        this.typeArguments = typeArguments;
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> computeContextTypeParameterMapping() {
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result = super.computeContextTypeParameterMapping();
        EList typeParameters = this.getDeclaration().getTypeParameters();
        int i = 0;
        while (i < Math.min(typeParameters.size(), this.typeArguments.size())) {
            result.put((JvmTypeParameter)typeParameters.get(i), new LightweightMergedBoundTypeArgument(this.typeArguments.get(i), VarianceInfo.INVARIANT));
            ++i;
        }
        return result;
    }

    public List<LightweightTypeReference> getResolvedTypeArguments() {
        return Collections.unmodifiableList(this.typeArguments);
    }

    public static class Provider {
        @Inject
        private OverrideTester overrideTester;
        @Inject
        private IBatchTypeResolver batchTypeResolver;
        @Inject
        private CommonTypeComputationServices services;

        public InvokedResolvedOperation resolve(XAbstractFeatureCall featureCall) {
            IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(featureCall);
            StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, featureCall);
            return this.resolve(featureCall, resolvedTypes, owner);
        }

        protected InvokedResolvedOperation resolve(XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes, ITypeReferenceOwner owner) {
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature instanceof JvmOperation) {
                LightweightTypeReference contextType = this.getReceiverType(featureCall, resolvedTypes, owner);
                return new InvokedResolvedOperation((JvmOperation)feature, contextType, resolvedTypes.getActualTypeArguments(featureCall), this.overrideTester);
            }
            throw new IllegalArgumentException();
        }

        protected LightweightTypeReference getReceiverType(XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes, ITypeReferenceOwner owner) {
            XExpression receiver = featureCall.getActualReceiver();
            if (receiver == null) {
                JvmOperation operation = (JvmOperation)featureCall.getFeature();
                JvmDeclaredType declaringType = operation.getDeclaringType();
                return owner.newParameterizedTypeReference((JvmType)declaringType);
            }
            return resolvedTypes.getActualType(receiver);
        }
    }
}

