/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypes {
    public ArrayTypeReference tryConvertToArray(ParameterizedTypeReference typeReference) {
        ArrayTypeReference result = this.doTryConvertToArray(typeReference);
        if (result != null) {
            return result;
        }
        JvmType type = typeReference.getType();
        if (type.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return this.doTryConvertToArray(typeReference, new RecursionGuard<JvmTypeParameter>());
        }
        return null;
    }

    private ArrayTypeReference doTryConvertToArray(ParameterizedTypeReference typeReference, RecursionGuard<JvmTypeParameter> recursionGuard) {
        JvmType type = typeReference.getType();
        if (recursionGuard.tryNext((JvmTypeParameter)type)) {
            List<LightweightTypeReference> superTypes = typeReference.getSuperTypes();
            int i = 0;
            int size = superTypes.size();
            while (i < size) {
                LightweightTypeReference superType = superTypes.get(i);
                if (superType.isArray()) {
                    return (ArrayTypeReference)superType;
                }
                ArrayTypeReference result = this.doTryConvertToArray(typeReference);
                if (result != null) {
                    return result;
                }
                JvmType rawSuperType = superType.getType();
                if (rawSuperType != null && rawSuperType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER && (result = this.doTryConvertToArray((ParameterizedTypeReference)superType, recursionGuard)) != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    private ArrayTypeReference doTryConvertToArray(ParameterizedTypeReference typeReference) {
        LightweightTypeReference parameterizedIterable = typeReference.getSuperType(Iterable.class);
        if (parameterizedIterable != null) {
            ITypeReferenceOwner owner = typeReference.getOwner();
            if (parameterizedIterable.isRawType()) {
                LightweightTypeReference objectType = parameterizedIterable.getSuperTypes().get(0);
                ArrayTypeReference array = owner.newArrayTypeReference(objectType);
                return array;
            }
            LightweightTypeReference componentType = parameterizedIterable.getTypeArguments().get(0).getUpperBoundSubstitute();
            ArrayTypeReference array = owner.newArrayTypeReference(componentType);
            return array;
        }
        return null;
    }

    public LightweightTypeReference convertToList(ArrayTypeReference type) {
        LightweightTypeReference componentType = type.getComponentType();
        LightweightTypeReference wrapper = componentType.getWrapperTypeIfPrimitive();
        ITypeReferenceOwner owner = type.getOwner();
        JvmType listType = type.getServices().getTypeReferences().findDeclaredType(List.class, (Notifier)owner.getContextResourceSet());
        if (listType == null) {
            return owner.newUnknownTypeReference(List.class.getName());
        }
        ParameterizedTypeReference result = owner.newParameterizedTypeReference(listType);
        result.addTypeArgument(wrapper);
        return result;
    }
}

