/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildContext;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.RegistryBuilderParticipant;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.internal.Stopwatches;

public class XtextBuilder
extends IncrementalProjectBuilder {
    private static final Logger log = Logger.getLogger(XtextBuilder.class);
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private RegistryBuilderParticipant participant;
    @Inject
    private QueuedBuildData queuedBuildData;

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block16: {
            if (IBuildFlag.FORGET_BUILD_STATE_ONLY.isSet(args)) {
                this.forgetLastBuiltState();
                return this.getProject().getReferencedProjects();
            }
            long startTime = System.currentTimeMillis();
            Stopwatches.StoppedTask task = Stopwatches.forTask((String)String.format("XtextBuilder.build[%s]", this.getKindAsString(kind)));
            try {
                try {
                    task.start();
                    if (monitor != null) {
                        final String taskName = String.valueOf(Messages.XtextBuilder_Building) + this.getProject().getName() + ": ";
                        monitor = new ProgressMonitorWrapper((IProgressMonitor)monitor){

                            public void subTask(String name) {
                                super.subTask(String.valueOf(taskName) + name);
                            }
                        };
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    if (kind == 6) {
                        this.fullBuild((IProgressMonitor)progress.newChild(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                    } else {
                        IResourceDelta delta = this.getDelta(this.getProject());
                        if (delta == null || this.isOpened(delta)) {
                            this.fullBuild((IProgressMonitor)progress.newChild(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                        } else {
                            this.incrementalBuild(delta, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (OperationCanceledException e) {
                    this.forgetLastBuiltState();
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    this.forgetLastBuiltState();
                    if (monitor != null) {
                        monitor.done();
                    }
                    log.info((Object)("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms"));
                    task.stop();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.done();
                }
                log.info((Object)("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms"));
                task.stop();
                throw throwable;
            }
            if (monitor != null) {
                monitor.done();
            }
            log.info((Object)("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms"));
            task.stop();
        }
        return this.getProject().getReferencedProjects();
    }

    private String getKindAsString(int kind) {
        if (kind == 6) {
            return "FULL";
        }
        if (kind == 15) {
            return "CLEAN";
        }
        if (kind == 10) {
            return "INCREMENTAL";
        }
        if (kind == 9) {
            return "AUTO";
        }
        return "UNKOWN:" + kind;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.XtextBuilder_CollectingResources, (int)10);
        progress.subTask(Messages.XtextBuilder_CollectingResources);
        if (this.queuedBuildData.needRebuild(this.getProject())) {
            this.needRebuild();
        }
        final ToBeBuilt toBeBuilt = new ToBeBuilt();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (delta.getResource() instanceof IProject) {
                    return delta.getResource() == XtextBuilder.this.getProject();
                }
                if (delta.getResource() instanceof IStorage) {
                    if (delta.getKind() == 2) {
                        return XtextBuilder.this.toBeBuiltComputer.removeStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 4) {
                        return XtextBuilder.this.toBeBuiltComputer.updateStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                }
                return true;
            }
        };
        delta.accept(visitor);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.worked(2);
        this.doBuild(toBeBuilt, (IProgressMonitor)progress.newChild(8), IXtextBuilderParticipant.BuildType.INCREMENTAL);
    }

    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        boolean indexingOnly;
        boolean bl = indexingOnly = type == IXtextBuilderParticipant.BuildType.RECOVERY;
        if (new BuildData(this.getProject().getName(), null, toBeBuilt, this.queuedBuildData, indexingOnly).isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceSet resourceSet = this.getResourceSetProvider().get(this.getProject());
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        if (resourceSet instanceof ResourceSetImpl) {
            ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
        }
        BuildData buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, this.queuedBuildData, indexingOnly);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.update(buildData, (IProgressMonitor)progress.newChild(1));
        if (this.participant != null && !indexingOnly) {
            this.participant.build(new BuildContext(this, resourceSet, (List<IResourceDescription.Delta>)deltas, type), (IProgressMonitor)progress.newChild(1));
            this.getProject().getWorkspace().checkpoint(false);
        } else {
            progress.worked(1);
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    protected void fullBuild(IProgressMonitor monitor, boolean isRecoveryBuild) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IProject project = this.getProject();
        ToBeBuilt toBeBuilt = isRecoveryBuild ? this.toBeBuiltComputer.updateProjectNewResourcesOnly(project, (IProgressMonitor)progress.newChild(2)) : this.toBeBuiltComputer.updateProject(project, (IProgressMonitor)progress.newChild(2));
        this.doBuild(toBeBuilt, (IProgressMonitor)progress.newChild(8), isRecoveryBuild ? IXtextBuilderParticipant.BuildType.RECOVERY : IXtextBuilderParticipant.BuildType.FULL);
    }

    protected boolean isOpened(IResourceDelta delta) {
        return delta.getResource() instanceof IProject && (delta.getFlags() & 0x4000) != 0 && ((IProject)delta.getResource()).isOpen();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            ToBeBuilt toBeBuilt = this.toBeBuiltComputer.removeProject(this.getProject(), (IProgressMonitor)progress.newChild(2));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.doClean(toBeBuilt, (IProgressMonitor)progress.newChild(8));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.clean(toBeBuilt.getToBeDeleted(), (IProgressMonitor)progress.newChild(1));
        if (this.participant != null) {
            this.participant.build(new BuildContext(this, this.getResourceSetProvider().get(this.getProject()), (List<IResourceDescription.Delta>)deltas, IXtextBuilderParticipant.BuildType.CLEAN), (IProgressMonitor)progress.newChild(1));
        } else {
            progress.worked(1);
        }
    }
}

