/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.arguments;

import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderedFeatureCallArguments
extends StandardFeatureCallArguments {
    protected final List<XExpression> shiftedArguments;
    protected final List<JvmFormalParameter> shiftedParameters;

    public ReorderedFeatureCallArguments(List<XExpression> arguments, List<JvmFormalParameter> parameters, List<XExpression> shiftedArguments, List<JvmFormalParameter> shiftedParameters, boolean hasReceiver, ITypeReferenceOwner owner) {
        super(arguments, parameters, hasReceiver, owner);
        this.shiftedArguments = shiftedArguments;
        this.shiftedParameters = shiftedParameters;
    }

    @Override
    public boolean hasUnprocessedArguments() {
        return this.nextUnprocessedArgument < this.arguments.size() + this.shiftedArguments.size();
    }

    @Override
    public IFeatureCallArgumentSlot getNextUnprocessedArgumentSlot() {
        if (!this.hasUnprocessedArguments()) {
            throw new NoSuchElementException();
        }
        if (this.nextUnprocessedArgument >= this.parameters.size() && this.nextUnprocessedArgument - this.parameters.size() < this.shiftedParameters.size()) {
            return new StandardFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
        }
        return super.getNextUnprocessedArgumentSlot();
    }

    @Override
    public int getArgumentCount() {
        return super.getArgumentCount() + this.shiftedArguments.size();
    }

    @Override
    public XExpression internalGetArgument(int idx) {
        int unshiftedParameterSize = this.parameters.size();
        int unshiftedArgumentSize = this.arguments.size();
        if (idx >= unshiftedParameterSize || idx >= unshiftedArgumentSize) {
            if (unshiftedParameterSize == unshiftedArgumentSize) {
                return this.shiftedArguments.get(idx - unshiftedParameterSize);
            }
            if (unshiftedParameterSize < unshiftedArgumentSize) {
                int shiftedIdx = idx - unshiftedParameterSize;
                if (shiftedIdx >= this.shiftedArguments.size()) {
                    return (XExpression)this.arguments.get(idx - this.shiftedArguments.size());
                }
                return this.shiftedArguments.get(shiftedIdx);
            }
            return this.shiftedArguments.get(idx - unshiftedArgumentSize);
        }
        return super.internalGetArgument(idx);
    }

    @Override
    protected LightweightTypeReference internalGetParameterType(int idx) {
        JvmFormalParameter parameter = this.internalGetParameter(idx);
        return this.toLightweightTypeReference(parameter);
    }

    protected JvmFormalParameter internalGetParameter(int idx) {
        int unshiftedParameterSize = this.parameters.size();
        int unshiftedArgumentSize = this.arguments.size();
        if (idx >= unshiftedParameterSize || idx >= unshiftedArgumentSize) {
            if (unshiftedParameterSize == unshiftedArgumentSize) {
                return this.shiftedParameters.get(idx - unshiftedParameterSize);
            }
            if (unshiftedParameterSize < unshiftedArgumentSize) {
                int shiftedIdx = idx - unshiftedParameterSize;
                if (shiftedIdx >= this.shiftedArguments.size()) {
                    return (JvmFormalParameter)this.parameters.get(idx - this.shiftedArguments.size());
                }
                return this.shiftedParameters.get(shiftedIdx);
            }
            return this.shiftedParameters.get(idx - unshiftedArgumentSize);
        }
        return (JvmFormalParameter)this.parameters.get(idx);
    }
}

