/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.generator.parser.antlr.splitting.PartialClassExtractor;
import org.eclipse.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;
import org.eclipse.xtext.generator.parser.packrat.PackratParserFragment;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAntlrGeneratorFragment
extends AbstractGeneratorFragment {
    private AntlrToolFacade antlrTool = new AntlrToolFacade();
    private AntlrOptions options = new AntlrOptions();
    private List<String> antlrParams = Lists.newArrayList();

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (!this.antlrTool.isWorkable()) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment '" + PackratParserFragment.class.getName() + "' in your mwe2 file instead.");
        }
    }

    public void setAntlrTool(AntlrToolFacade facade) {
        this.antlrTool = facade;
    }

    public AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }

    public AntlrOptions getOptions() {
        return this.options;
    }

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        String[] result = this.antlrParams.toArray(new String[this.antlrParams.size()]);
        return result;
    }

    protected String getEncoding(XpandExecutionContext xpt, String outlet) {
        return xpt.getOutput().getOutlet(outlet).getFileEncoding();
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.options);
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        AbstractRule firstRule = (AbstractRule)grammar.getRules().get(0);
        if (!(firstRule instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)firstRule))) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
        super.generate(grammar, ctx);
    }

    protected void splitLexerClassFile(String filename, Charset encoding) throws IOException {
        String content = this.readFileIntoString(filename, encoding);
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        this.writeStringIntoFile(filename, splitter.transform(), encoding);
    }

    @Deprecated
    protected void splitLexerClassFile(String filename) throws IOException {
        this.splitLexerClassFile(filename, Charset.defaultCharset());
    }

    protected void splitParserClassFile(String filename, Charset encoding) throws IOException {
        String content = this.readFileIntoString(filename, encoding);
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, this.getOptions().getFieldsPerClass());
        PartialClassExtractor extractor = new PartialClassExtractor(splitter.transform(), this.getOptions().getMethodsPerClass());
        this.writeStringIntoFile(filename, extractor.transform(), encoding);
    }

    @Deprecated
    protected void splitParserClassFile(String filename) throws IOException {
        this.splitParserClassFile(filename, Charset.defaultCharset());
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, String absoluteParserFileName, Charset encoding) {
        try {
            if (this.containsUnorderedGroup(grammar)) {
                String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
                this.simplifyUnorderedGroupPredicates(javaFile, encoding);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, String absoluteParserFileName) {
        this.simplifyUnorderedGroupPredicatesIfRequired(grammar, absoluteParserFileName, Charset.defaultCharset());
    }

    protected String getParserFileNameSuffix() {
        return "Parser.java";
    }

    protected void simplifyUnorderedGroupPredicates(String javaFile, Charset encoding) throws IOException {
        String content = this.readFileIntoString(javaFile, encoding);
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        this.writeStringIntoFile(javaFile, newContent, encoding);
    }

    @Deprecated
    protected void simplifyUnorderedGroupPredicates(String javaFile) throws IOException {
        this.simplifyUnorderedGroupPredicates(javaFile, Charset.defaultCharset());
    }

    private void suppressWarningsImpl(String javaFile, Charset encoding) {
        String content = this.readFileIntoString(javaFile, encoding);
        content = new SuppressWarningsProcessor().process(content);
        this.writeStringIntoFile(javaFile, content, encoding);
    }

    protected void suppressWarnings(String grammarFileName, Charset encoding) {
        this.suppressWarnings(grammarFileName, grammarFileName, encoding);
    }

    protected void suppressWarnings(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        this.suppressWarningsImpl(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()), encoding);
        this.suppressWarningsImpl(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()), encoding);
    }

    @Deprecated
    protected void suppressWarnings(String grammarFileName) {
        this.suppressWarnings(grammarFileName, Charset.defaultCharset());
    }

    @Deprecated
    protected void suppressWarnings(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        this.suppressWarnings(absoluteLexerGrammarFileName, absoluteParserGrammarFileName, Charset.defaultCharset());
    }

    private void normalizeLineDelimitersImpl(String textFile, Charset encoding) {
        String content = this.readFileIntoString(textFile, encoding);
        content = new NewlineNormalizer(this.getLineDelimiter()){

            public String normalizeLineDelimiters(CharSequence content) {
                String result = super.normalizeLineDelimiters(content);
                result = result.replaceAll("\"\\+\\n\\s+\"", "");
                return result;
            }
        }.normalizeLineDelimiters(content);
        this.writeStringIntoFile(textFile, content, encoding);
    }

    protected String getLineDelimiter() {
        return this.getNaming().getLineDelimiter();
    }

    protected void normalizeLineDelimiters(String grammarFileName, Charset encoding) {
        this.normalizeLineDelimiters(grammarFileName, grammarFileName, encoding);
    }

    protected void normalizeTokens(String grammarFileName, Charset encoding) {
        String tokenFile = this.toTokenFileName(grammarFileName);
        String content = this.readFileIntoString(tokenFile, encoding);
        content = new NewlineNormalizer(this.getLineDelimiter()).normalizeLineDelimiters(content);
        List splitted = Strings.split((String)content, (String)this.getLineDelimiter());
        Collections.sort(splitted);
        content = String.valueOf(Strings.concat((String)this.getLineDelimiter(), (List)splitted)) + this.getLineDelimiter();
        this.writeStringIntoFile(tokenFile, content, encoding);
    }

    private String toTokenFileName(String grammarFileName) {
        return grammarFileName.replaceAll("\\.g$", ".tokens");
    }

    protected void normalizeLineDelimiters(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        this.normalizeLineDelimitersImpl(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()), encoding);
        this.normalizeLineDelimitersImpl(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()), encoding);
    }

    protected String getLexerFileNameSuffix() {
        return "Lexer.java";
    }

    protected void splitParserAndLexerIfEnabled(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        if (this.getOptions().isClassSplitting()) {
            try {
                this.splitLexerClassFile(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()), encoding);
                this.splitParserClassFile(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()), encoding);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void splitParserAndLexerIfEnabled(String absoluteGrammarFileName, Charset encoding) {
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, absoluteGrammarFileName, encoding);
    }

    @Deprecated
    protected void splitParserAndLexerIfEnabled(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        this.splitParserAndLexerIfEnabled(absoluteLexerGrammarFileName, absoluteParserGrammarFileName, Charset.defaultCharset());
    }

    @Deprecated
    protected void splitParserAndLexerIfEnabled(String absoluteGrammarFileName) {
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, absoluteGrammarFileName, Charset.defaultCharset());
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            if (!Iterators.filter((Iterator)rule.eAllContents(), UnorderedGroup.class).hasNext()) continue;
            return true;
        }
        return false;
    }
}

