/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class JdtBasedProcessorProvider
extends ProcessorInstanceForJvmTypeProvider {
    private static final Logger LOG = Logger.getLogger(JdtBasedProcessorProvider.class);

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader classLoader = this.getClassLoader((EObject)type);
            String _identifier = type.getIdentifier();
            Class<?> result = classLoader.loadClass(_identifier);
            return result.newInstance();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier_1 = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier_1;
                String _plus_1 = String.valueOf(_plus) + " : ";
                String _message = e.getMessage();
                String _plus_2 = String.valueOf(_plus_1) + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public ClassLoader getClassLoader(EObject ctx) {
        Resource _eResource = ctx.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        XtextResourceSet rs = (XtextResourceSet)_resourceSet;
        ResourceSetContext _get = ResourceSetContext.get((Notifier)rs);
        boolean isBuilder = _get.isBuilder();
        ResourceSetContext _get_1 = ResourceSetContext.get((Notifier)rs);
        boolean isEditor = _get_1.isEditor();
        if (isBuilder) {
            boolean _notEquals;
            EList _eAdapters = rs.eAdapters();
            Iterable _filter = Iterables.filter((Iterable)_eAdapters, ProcessorClassloaderAdapter.class);
            ProcessorClassloaderAdapter adapter = (ProcessorClassloaderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
            boolean bl = _notEquals = !Objects.equal((Object)((Object)adapter), null);
            if (_notEquals) {
                return adapter.classLoader;
            }
        }
        if (isEditor) {
            boolean _notEquals_1;
            Resource _editorResource = this.getEditorResource(ctx);
            EList _eAdapters_1 = _editorResource.eAdapters();
            Iterable _filter_1 = Iterables.filter((Iterable)_eAdapters_1, ProcessorClassloaderAdapter.class);
            ProcessorClassloaderAdapter adapter_1 = (ProcessorClassloaderAdapter)((Object)IterableExtensions.head((Iterable)_filter_1));
            boolean bl = _notEquals_1 = !Objects.equal((Object)((Object)adapter_1), null);
            if (_notEquals_1) {
                boolean _equals = Objects.equal((Object)adapter_1.classLoader, null);
                if (_equals) {
                    Resource _editorResource_1 = this.getEditorResource(ctx);
                    EList _eAdapters_2 = _editorResource_1.eAdapters();
                    _eAdapters_2.remove((Object)adapter_1);
                } else {
                    return adapter_1.classLoader;
                }
            }
        }
        Object _classpathURIContext = rs.getClasspathURIContext();
        IJavaProject project = (IJavaProject)_classpathURIContext;
        URLClassLoader classloader = this.createClassLoaderForJavaProject(project);
        if (isBuilder) {
            EList _eAdapters_3 = rs.eAdapters();
            ProcessorClassloaderAdapter _processorClassloaderAdapter = new ProcessorClassloaderAdapter(classloader);
            _eAdapters_3.add((Object)_processorClassloaderAdapter);
        }
        if (isEditor) {
            Resource _editorResource_2 = this.getEditorResource(ctx);
            EList _eAdapters_4 = _editorResource_2.eAdapters();
            ProcessorClassloaderAdapter _processorClassloaderAdapter_1 = new ProcessorClassloaderAdapter(classloader);
            _eAdapters_4.add((Object)_processorClassloaderAdapter_1);
        }
        return classloader;
    }

    private Resource getEditorResource(EObject ctx) {
        Resource _eResource = ctx.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        EList _resources = _resourceSet.getResources();
        return (Resource)IterableExtensions.head((Iterable)_resources);
    }

    protected URLClassLoader createClassLoaderForJavaProject(IJavaProject projectToUse) {
        LinkedHashSet urls = CollectionLiterals.newLinkedHashSet((Object[])new URL[0]);
        HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new IJavaProject[0]);
        this.collectClasspathURLs(projectToUse, urls, false, _newHashSet);
        ClassLoader _parentClassLoader = this.getParentClassLoader();
        return new URLClassLoader((URL[])Conversions.unwrapArray((Object)urls, URL.class), _parentClassLoader);
    }

    protected void collectClasspathURLs(IJavaProject projectToUse, LinkedHashSet<URL> result, boolean includeOutputFolder, Set<IJavaProject> visited) {
        try {
            IClasspathEntry[] resolvedClasspath;
            boolean _not;
            boolean _add = visited.add(projectToUse);
            boolean bl = _not = !_add;
            if (_not) {
                return;
            }
            if (includeOutputFolder) {
                IPath _outputLocation = projectToUse.getOutputLocation();
                IPath path = _outputLocation.addTrailingSeparator();
                String _string = path.toString();
                URI _createPlatformResourceURI = URI.createPlatformResourceURI((String)_string, (boolean)true);
                String _string_1 = _createPlatformResourceURI.toString();
                URL url = new URL(_string_1);
                result.add(url);
            }
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = projectToUse.getResolvedClasspath(true);
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _notEquals_2;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                URL url_1 = null;
                int _entryKind = entry.getEntryKind();
                switch (_entryKind) {
                    case 3: {
                        URL _uRL;
                        boolean _notEquals;
                        if (!includeOutputFolder) break;
                        IPath path_1 = entry.getOutputLocation();
                        boolean bl2 = _notEquals = !Objects.equal((Object)path_1, null);
                        if (!_notEquals) break;
                        IPath _addTrailingSeparator = path_1.addTrailingSeparator();
                        String _string_2 = _addTrailingSeparator.toString();
                        URI _createPlatformResourceURI_1 = URI.createPlatformResourceURI((String)_string_2, (boolean)true);
                        String _string_3 = _createPlatformResourceURI_1.toString();
                        url_1 = _uRL = new URL(_string_3);
                        break;
                    }
                    case 2: {
                        IPath path_2 = entry.getPath();
                        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot(projectToUse);
                        IResource project = _workspaceRoot.findMember(path_2);
                        IProject _project = project.getProject();
                        IJavaProject referencedProject = JavaCore.create((IProject)_project);
                        this.collectClasspathURLs(referencedProject, result, true, visited);
                        break;
                    }
                    case 1: {
                        boolean _notEquals_1;
                        IPath path_3 = entry.getPath();
                        IWorkspaceRoot _workspaceRoot_1 = this.getWorkspaceRoot(projectToUse);
                        IResource library = _workspaceRoot_1.findMember(path_3);
                        URL _xifexpression = null;
                        boolean bl3 = _notEquals_1 = !Objects.equal((Object)library, null);
                        if (_notEquals_1) {
                            java.net.URI _rawLocationURI = library.getRawLocationURI();
                            _xifexpression = _rawLocationURI.toURL();
                        } else {
                            File _file = path_3.toFile();
                            java.net.URI _uRI = _file.toURI();
                            _xifexpression = _uRI.toURL();
                        }
                        url_1 = _xifexpression;
                        break;
                    }
                    default: {
                        URL _uRL_1;
                        IPath path_4 = entry.getPath();
                        File _file_1 = path_4.toFile();
                        java.net.URI _uRI_1 = _file_1.toURI();
                        url_1 = _uRL_1 = _uRI_1.toURL();
                    }
                }
                boolean bl4 = _notEquals_2 = !Objects.equal(url_1, null);
                if (_notEquals_2) {
                    result.add(url_1);
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ClassLoader getParentClassLoader() {
        ClassLoader bundleClassLoader = TransformationContext.class.getClassLoader();
        return bundleClassLoader;
    }

    private IWorkspaceRoot getWorkspaceRoot(IJavaProject javaProject) {
        IProject _project = javaProject.getProject();
        IWorkspace _workspace = _project.getWorkspace();
        return _workspace.getRoot();
    }

    @Accessors
    public static class ProcessorClassloaderAdapter
    extends AdapterImpl {
        private ClassLoader classLoader;

        public ProcessorClassloaderAdapter(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public boolean isAdapterForType(Object type) {
            return Objects.equal((Object)type, ProcessorClassloaderAdapter.class);
        }

        public void unsetTarget(Notifier oldTarget) {
            this.discard();
        }

        public void setTarget(Notifier newTarget) {
            boolean _equals = Objects.equal((Object)newTarget, null);
            if (_equals) {
                this.discard();
            }
        }

        public ClassLoader discard() {
            Object _xifexpression = null;
            if (this.classLoader instanceof Closeable) {
                Object _xtrycatchfinallyexpression = null;
                try {
                    Object _xblockexpression = null;
                    ((Closeable)((Object)this.classLoader)).close();
                    this.classLoader = null;
                    _xtrycatchfinallyexpression = _xblockexpression = null;
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException e = (IOException)_t;
                        String _message = e.getMessage();
                        LOG.error((Object)_message, (Throwable)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression = _xtrycatchfinallyexpression;
            }
            return _xifexpression;
        }

        @Pure
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

