/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.scoping.DelegatingScope;
import org.eclipse.xtext.xbase.scoping.LocalVariableScopeContext;
import org.eclipse.xtext.xbase.scoping.XtypeScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.LocalVarDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.StaticMethodsFeatureForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentSugarDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XFeatureCallSugarDescriptionProvider;
import org.eclipse.xtext.xbase.typing.ITypeArgumentContextHelper;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseScopeProvider
extends XtypeScopeProvider {
    protected static final int DEFAULT_MEMBER_CALL_PRIORITY = 0;
    protected static final int DEFAULT_IT_PRIORITY = 10;
    protected static final int DEFAULT_THIS_PRIORITY = 20;
    protected static final int DEFAULT_IMPLICIT_STATIC_FEATURE_PRIORITY = 60;
    protected static final int DEFAULT_SUGAR_PRIORITY_OFFSET = 100;
    protected static final int DEFAULT_STATIC_EXTENSION_PRIORITY_OFFSET = 230;
    private static final Logger log = Logger.getLogger(XbaseScopeProvider.class);
    public static final QualifiedName THIS = QualifiedName.create((String[])new String[]{"this"});
    public static final QualifiedName SUPER = QualifiedName.create((String[])new String[]{"super"});
    public static final QualifiedName IT = QualifiedName.create((String[])new String[]{"it"});
    @Inject
    protected IJvmFeatureScopeProvider jvmFeatureScopeProvider;
    @Inject
    private Provider<DefaultJvmFeatureDescriptionProvider> defaultFeatureDescProvider;
    @Inject
    private Provider<XFeatureCallSugarDescriptionProvider> sugarFeatureDescProvider;
    @Inject
    private Provider<StaticMethodsFeatureForTypeProvider> implicitStaticFeatures;
    @Inject
    private Provider<XAssignmentDescriptionProvider> assignmentFeatureDescProvider;
    @Inject
    private Provider<XAssignmentSugarDescriptionProvider> assignmentSugarFeatureDescProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private ITypeArgumentContextHelper typeArgumentContextHelper;
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;

    public void setFeatureNameProvider(IdentifiableSimpleNameProvider featureNameProvider) {
        this.featureNameProvider = featureNameProvider;
    }

    public void setTypeProvider(ITypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void setSugarFeatureDescProvider(Provider<XFeatureCallSugarDescriptionProvider> sugarFeatureDescProvider) {
        this.sugarFeatureDescProvider = sugarFeatureDescProvider;
    }

    public void setDefaultFeatureDescProvider(Provider<DefaultJvmFeatureDescriptionProvider> defaultFeatureDescProvider) {
        this.defaultFeatureDescProvider = defaultFeatureDescProvider;
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter getScope(" + context + ", " + reference.getEContainingClass().getName() + "#" + reference.getName() + ")"));
        }
        try {
            if (this.isFeatureCallScope(reference)) {
                if (!(context instanceof XAbstractFeatureCall)) {
                    IScope iScope = IScope.NULLSCOPE;
                    return iScope;
                }
                IScope iScope = this.createFeatureCallScope((XAbstractFeatureCall)context, reference);
                return iScope;
            }
            if (this.isConstructorCallScope(reference)) {
                IScope iScope = this.createConstructorCallScope(context, reference);
                return iScope;
            }
            if (this.isTypeScope(reference)) {
                IScope iScope = this.createTypeScope(context, reference);
                return iScope;
            }
            IScope iScope = super.getScope(context, reference);
            return iScope;
        }
        catch (RuntimeException e) {
            log.error((Object)"error during scoping", (Throwable)e);
            throw e;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("leave getScope(" + context + ", " + reference.getEContainingClass().getName() + "#" + reference.getName() + ")"));
            }
        }
    }

    protected IScope createTypeScope(EObject context, EReference reference) {
        IScope parentScope = super.getScope(context, reference);
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(context);
        if (logicalContainer != null) {
            return this.createTypeScope(logicalContainer, reference, parentScope);
        }
        return parentScope;
    }

    protected IScope createTypeScope(JvmIdentifiableElement context, EReference reference, IScope parentScope) {
        if (context == null) {
            return parentScope;
        }
        if (context.eContainer() instanceof JvmIdentifiableElement) {
            parentScope = this.createTypeScope((JvmIdentifiableElement)context.eContainer(), reference, parentScope);
        }
        if (context instanceof JvmGenericType) {
            JvmGenericType genericType = (JvmGenericType)context;
            ArrayList descriptions = Lists.newArrayList();
            if (genericType.getSimpleName() != null) {
                QualifiedName inferredDeclaringTypeName = QualifiedName.create((String[])new String[]{genericType.getSimpleName()});
                descriptions.add(EObjectDescription.create((QualifiedName)inferredDeclaringTypeName, (EObject)genericType));
            }
            for (JvmTypeParameter param : genericType.getTypeParameters()) {
                if (param.getSimpleName() == null) continue;
                QualifiedName paramName = QualifiedName.create((String[])new String[]{param.getSimpleName()});
                descriptions.add(EObjectDescription.create((QualifiedName)paramName, (EObject)param));
            }
            if (!descriptions.isEmpty()) {
                return MapBasedScope.createScope((IScope)parentScope, (Iterable)descriptions);
            }
        } else if (context instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)context;
            List descriptions = null;
            for (JvmTypeParameter param : operation.getTypeParameters()) {
                if (param.getSimpleName() == null) continue;
                if (descriptions == null) {
                    descriptions = Lists.newArrayList();
                }
                QualifiedName paramName = QualifiedName.create((String[])new String[]{param.getSimpleName()});
                descriptions.add(EObjectDescription.create((QualifiedName)paramName, (EObject)param));
            }
            if (descriptions != null && !descriptions.isEmpty()) {
                return MapBasedScope.createScope((IScope)parentScope, (Iterable)descriptions);
            }
        }
        return parentScope;
    }

    protected boolean isTypeScope(EReference reference) {
        return TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType());
    }

    protected IScope createConstructorCallScope(final EObject context, EReference reference) {
        final IScope scope = super.getScope(context, reference);
        return new IScope(){

            public Iterable<IEObjectDescription> getAllElements() {
                Iterable original = scope.getAllElements();
                return this.createFeatureDescriptions(original);
            }

            protected Iterable<IEObjectDescription> createFeatureDescriptions(Iterable<IEObjectDescription> original) {
                Iterable result = Iterables.transform(original, (Function)new Function<IEObjectDescription, IEObjectDescription>(){

                    public IEObjectDescription apply(IEObjectDescription from) {
                        JvmConstructor constructor = (JvmConstructor)from.getEObjectOrProxy();
                        XConstructorCall constructorCall = null;
                        if (context instanceof XConstructorCall) {
                            constructorCall = (XConstructorCall)context;
                        }
                        ITypeArgumentContext typeArgumentContext = XbaseScopeProvider.this.typeArgumentContextHelper.getTypeArgumentContext(constructorCall, constructor);
                        JvmFeatureDescription result = new JvmFeatureDescription(from.getQualifiedName(), (JvmFeature)constructor, typeArgumentContext, constructor.getIdentifier(), true, true, null, null, 0);
                        result.setGenericTypeContext(typeArgumentContext);
                        return result;
                    }
                });
                return result;
            }

            public Iterable<IEObjectDescription> getElements(EObject object) {
                Iterable original = scope.getElements(object);
                return this.createFeatureDescriptions(original);
            }

            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                Iterable original = scope.getElements(name);
                return this.createFeatureDescriptions(original);
            }

            public IEObjectDescription getSingleElement(EObject object) {
                Iterable<IEObjectDescription> elements = this.getElements(object);
                return Iterables.isEmpty(elements) ? null : elements.iterator().next();
            }

            public IEObjectDescription getSingleElement(QualifiedName name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean isConstructorCallScope(EReference reference) {
        return reference.getEReferenceType() == TypesPackage.Literals.JVM_CONSTRUCTOR;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected IScope createFeatureCallScope(XAbstractFeatureCall call, EReference reference) {
        if (call instanceof XFeatureCall || call instanceof XAssignment && ((XAssignment)call).getAssignable() == null) {
            IScope result = this.createSimpleFeatureCallScope(call, reference, call.eResource(), false, -1);
            return result;
        }
        XExpression syntacticalReceiver = this.getSyntacticalReceiver(call);
        IScope result = this.createFeatureCallScopeForReceiver(call, syntacticalReceiver, reference);
        return result;
    }

    public IScope createSimpleFeatureCallScope(EObject context, EReference reference, Resource resource, boolean includeCurrentBlock, int idx) {
        XFeatureCall featureCall;
        if (context instanceof XFeatureCall && (featureCall = (XFeatureCall)context).getDeclaringType() != null) {
            JvmParameterizedTypeReference typeReference = this.typeReferences.createTypeRef((JvmType)featureCall.getDeclaringType(), new JvmTypeReference[0]);
            JvmFeatureScopeAcceptor featureScopeDescriptions = new JvmFeatureScopeAcceptor();
            IAcceptor<IJvmFeatureDescriptionProvider> curried = featureScopeDescriptions.curry((JvmTypeReference)typeReference, featureCall);
            this.addFeatureDescriptionProviders(this.getContextType(featureCall), null, null, null, this.getDefaultPriority(), true, curried);
            IScope result = featureScopeDescriptions.createScope(IScope.NULLSCOPE);
            return result;
        }
        DelegatingScope implicitFeaturesAndStatics = new DelegatingScope(IScope.NULLSCOPE);
        LocalVariableScopeContext scopeContext = this.createLocalVariableScopeContext(context, reference, includeCurrentBlock, idx);
        IScope localVariableScope = this.createLocalVarScope((IScope)implicitFeaturesAndStatics, scopeContext);
        IScope scopeForImplicitFeatures = this.createImplicitFeatureCallScope(context, resource, IScope.NULLSCOPE, localVariableScope);
        implicitFeaturesAndStatics.setDelegate(scopeForImplicitFeatures);
        return localVariableScope;
    }

    private IScope createFeatureScopeForTypeRef(JvmTypeReference declaringType, EObject expression, XExpression implicitReceiver, IScope parent) {
        JvmFeatureScopeAcceptor featureScopeDescriptions = new JvmFeatureScopeAcceptor();
        this.addFeatureScopes(declaringType, expression, this.getContextType(expression), implicitReceiver, null, this.getDefaultPriority(), featureScopeDescriptions);
        IScope result = featureScopeDescriptions.createScope(parent);
        return result;
    }

    protected LocalVariableScopeContext createLocalVariableScopeContext(EObject context, EReference reference, boolean includeCurrentBlock, int idx) {
        return new LocalVariableScopeContext(context, reference, includeCurrentBlock, idx, false, this.logicalContainerProvider);
    }

    public IScope createFeatureCallScopeForReceiver(XExpression context, XExpression receiver, EReference reference) {
        if (!this.isFeatureCallScope(reference)) {
            return IScope.NULLSCOPE;
        }
        if (receiver == null || receiver.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        JvmTypeReference receiverType = this.typeProvider.getType(receiver, true);
        if (receiverType != null) {
            return this.createFeatureScopeForTypeRef(receiverType, context, null, IScope.NULLSCOPE);
        }
        return IScope.NULLSCOPE;
    }

    protected XExpression getSyntacticalReceiver(XAbstractFeatureCall call) {
        if (call instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)call).getMemberCallTarget();
        }
        if (call instanceof XBinaryOperation) {
            return ((XBinaryOperation)call).getLeftOperand();
        }
        if (call instanceof XUnaryOperation) {
            return ((XUnaryOperation)call).getOperand();
        }
        if (call instanceof XAssignment) {
            return ((XAssignment)call).getAssignable();
        }
        return null;
    }

    protected final IScope createImplicitFeatureCallScope(EObject call, Resource resource, IScope parent, IScope localVariableScope) {
        JvmFeatureScopeAcceptor featureScopeDescriptions = new JvmFeatureScopeAcceptor();
        this.addFeatureCallScopes(call, localVariableScope, featureScopeDescriptions);
        JvmDeclaredType contextType = this.getContextType(call);
        IAcceptor<IJvmFeatureDescriptionProvider> acceptor = featureScopeDescriptions.curry(null, call);
        this.addStaticFeatureDescriptionProviders(resource, contextType, acceptor);
        IScope result = featureScopeDescriptions.createScope(parent);
        return result;
    }

    protected void addFeatureCallScopes(EObject featureCall, IScope localVariableScope, IJvmFeatureScopeAcceptor featureScopeDescriptions) {
        this.addFeatureCallScopes(featureCall, localVariableScope, THIS, this.getThisPriority(), featureScopeDescriptions);
        this.addFeatureCallScopes(featureCall, localVariableScope, IT, this.getItPriority(), featureScopeDescriptions);
    }

    protected void addFeatureCallScopes(EObject expression, IScope localVariableScope, QualifiedName variableName, int priority, IJvmFeatureScopeAcceptor featureScopeDescriptions) {
        JvmTypeReference receiverType;
        EObject implicitReceiver;
        IEObjectDescription implicitVariable = localVariableScope.getSingleElement(variableName);
        if (implicitVariable != null && (implicitReceiver = implicitVariable.getEObjectOrProxy()) instanceof JvmIdentifiableElement && (receiverType = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)implicitReceiver)) != null) {
            XFeatureCall receiver = XbaseFactory.eINSTANCE.createXFeatureCall();
            receiver.setFeature((JvmIdentifiableElement)implicitReceiver);
            this.addFeatureScopes(receiverType, expression, this.getContextType(expression), receiver, null, priority, featureScopeDescriptions);
        }
    }

    protected JvmDeclaredType getContextType(EObject obj) {
        JvmIdentifiableElement element;
        if (obj == null) {
            return null;
        }
        if (obj instanceof JvmDeclaredType) {
            return (JvmDeclaredType)obj;
        }
        if (obj instanceof XExpression && (element = this.logicalContainerProvider.getLogicalContainer(obj)) != null) {
            if (element instanceof JvmDeclaredType) {
                return (JvmDeclaredType)element;
            }
            if (element instanceof JvmMember) {
                return ((JvmMember)element).getDeclaringType();
            }
        }
        return this.getContextType(obj.eContainer());
    }

    protected IScope createLocalVarScope(IScope parentScope, LocalVariableScopeContext scopeContext) {
        XBlockExpression block;
        EObject context;
        if (scopeContext == null || scopeContext.getContext() == null) {
            return parentScope;
        }
        if (scopeContext.canSpawnForContainer()) {
            parentScope = this.createLocalVarScope(parentScope, scopeContext.spawnForContainer());
        }
        if ((context = scopeContext.getContext()).eContainer() instanceof XBlockExpression) {
            block = (XBlockExpression)context.eContainer();
            parentScope = this.createLocalVarScopeForBlock(block, block.getExpressions().indexOf((Object)context), scopeContext.isReferredFromClosure(), parentScope);
        }
        if (context.eContainer() instanceof XForLoopExpression && context.eContainingFeature() == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION) {
            XForLoopExpression loop = (XForLoopExpression)context.eContainer();
            parentScope = this.createLocalScopeForParameter(loop.getDeclaredParam(), parentScope);
        }
        if (context.eContainer() instanceof XCatchClause) {
            XCatchClause catchClause = (XCatchClause)context.eContainer();
            parentScope = this.createLocalScopeForParameter(catchClause.getDeclaredParam(), parentScope);
        }
        if (context instanceof XClosure) {
            parentScope = this.createLocalVarScopeForClosure((XClosure)context, parentScope);
        }
        if (context instanceof XCasePart) {
            parentScope = this.createLocalVarScopeForTypeGuardedCase((XCasePart)context, parentScope);
        }
        if (context instanceof XSwitchExpression) {
            parentScope = this.createLocalVarScopeForSwitchExpression((XSwitchExpression)context, parentScope);
        }
        if (context instanceof JvmOperation) {
            parentScope = this.createLocalVarScopeForJvmOperation((JvmOperation)context, parentScope);
        }
        if (context instanceof JvmConstructor) {
            parentScope = this.createLocalVarScopeForJvmConstructor((JvmConstructor)context, parentScope);
        }
        if (context instanceof JvmDeclaredType) {
            parentScope = this.createLocalVarScopeForJvmDeclaredType((JvmDeclaredType)context, parentScope);
        }
        if (scopeContext.isIncludeCurrentBlock()) {
            if (context instanceof XBlockExpression && !(block = (XBlockExpression)context).getExpressions().isEmpty()) {
                parentScope = this.createLocalVarScopeForBlock(block, scopeContext.getIndex(), scopeContext.isReferredFromClosure(), parentScope);
            }
            if (context instanceof XForLoopExpression) {
                parentScope = this.createLocalScopeForParameter(((XForLoopExpression)context).getDeclaredParam(), parentScope);
            }
            if (context instanceof XCatchClause) {
                parentScope = this.createLocalScopeForParameter(((XCatchClause)context).getDeclaredParam(), parentScope);
            }
        }
        return parentScope;
    }

    protected IScope createLocalVarScopeForJvmOperation(JvmOperation context, IScope parentScope) {
        EList parameters = context.getParameters();
        if (parameters.isEmpty()) {
            return parentScope;
        }
        ArrayList descriptions = Lists.newArrayList();
        for (JvmFormalParameter p : parameters) {
            if (p.getName() == null) continue;
            descriptions.add(new LocalVarDescription(QualifiedName.create((String[])new String[]{p.getName()}), (JvmIdentifiableElement)p));
        }
        return new JvmFeatureScope(parentScope, "operation " + context.getSimpleName(), descriptions);
    }

    protected IScope createLocalVarScopeForJvmConstructor(JvmConstructor context, IScope parentScope) {
        EList parameters = context.getParameters();
        if (parameters.isEmpty()) {
            return parentScope;
        }
        ArrayList descriptions = Lists.newArrayList();
        for (JvmFormalParameter p : parameters) {
            if (p.getName() == null) continue;
            descriptions.add(new LocalVarDescription(QualifiedName.create((String[])new String[]{p.getName()}), (JvmIdentifiableElement)p));
        }
        return new JvmFeatureScope(parentScope, "constructor " + context.getSimpleName(), descriptions);
    }

    protected IScope createLocalVarScopeForJvmDeclaredType(JvmDeclaredType type, IScope parentScope) {
        Iterator classes = Iterables.filter((Iterable)type.getSuperTypes(), (Predicate)new Predicate<JvmTypeReference>(){

            public boolean apply(JvmTypeReference input) {
                if (input.getType() instanceof JvmGenericType) {
                    return !((JvmGenericType)input.getType()).isInterface();
                }
                return false;
            }
        }).iterator();
        JvmGenericType superType = null;
        if (classes.hasNext()) {
            superType = (JvmGenericType)((JvmTypeReference)classes.next()).getType();
        }
        if (superType == null) {
            return new JvmFeatureScope(parentScope, "this", new LocalVarDescription(THIS, (JvmIdentifiableElement)type));
        }
        return new JvmFeatureScope(parentScope, "this & super", Lists.newArrayList((Object[])new LocalVarDescription[]{new LocalVarDescription(THIS, (JvmIdentifiableElement)type), new LocalVarDescription(SUPER, (JvmIdentifiableElement)superType)}));
    }

    protected boolean adaptsToJvmElement(EObject context) {
        if (context instanceof XExpression) {
            return this.logicalContainerProvider.getLogicalContainer(context) != null;
        }
        return false;
    }

    protected IScope createLocalVarScopeForSwitchExpression(XSwitchExpression context, IScope parentScope) {
        if (context.getLocalVarName() != null) {
            return new JvmFeatureScope(parentScope, "XSwitchExpression", new LocalVarDescription(QualifiedName.create((String[])new String[]{context.getLocalVarName()}), context));
        }
        return parentScope;
    }

    protected IScope createLocalVarScopeForTypeGuardedCase(XCasePart context, IScope parentScope) {
        JvmTypeReference guard = context.getTypeGuard();
        if (guard == null) {
            return parentScope;
        }
        String varName = this.featureNameProvider.getSimpleName(context);
        if (varName == null) {
            return parentScope;
        }
        return new JvmFeatureScope(parentScope, "XCasePart", new LocalVarDescription(QualifiedName.create((String[])new String[]{varName}), context));
    }

    protected IScope createLocalVarScopeForCatchClause(XCatchClause catchClause, int indexOfContextExpressionInBlock, IScope parentScope) {
        return this.createLocalScopeForParameter(catchClause.getDeclaredParam(), parentScope);
    }

    protected IScope createLocalVarScopeForBlock(XBlockExpression block, int indexOfContextExpressionInBlock, boolean referredFromClosure, IScope parentScope) {
        ArrayList descriptions = Lists.newArrayList();
        int i = 0;
        while (i < indexOfContextExpressionInBlock) {
            XVariableDeclaration varDecl;
            XExpression expression = (XExpression)block.getExpressions().get(i);
            if (expression instanceof XVariableDeclaration && (varDecl = (XVariableDeclaration)expression).getName() != null) {
                IValidatedEObjectDescription desc = this.createLocalVarDescription(varDecl);
                if (referredFromClosure && varDecl.isWriteable()) {
                    desc.setIssueCode("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access");
                }
                descriptions.add(desc);
            }
            ++i;
        }
        if (descriptions.isEmpty()) {
            return parentScope;
        }
        return new JvmFeatureScope(parentScope, "XBlockExpression", descriptions);
    }

    protected IScope createLocalVarScopeForClosure(XClosure closure, IScope parentScope) {
        ArrayList descriptions = Lists.newArrayList();
        EList<JvmFormalParameter> params = closure.getFormalParameters();
        for (JvmFormalParameter p : params) {
            if (p.getName() == null) continue;
            IValidatedEObjectDescription desc = this.createLocalVarDescription(p);
            descriptions.add(desc);
        }
        return new JvmFeatureScope(parentScope, "XClosure", descriptions);
    }

    protected void sortDescriptionsFromLowestToHighest(List<IJvmFeatureScopeProvider.FeatureScopeDescription> list) {
        Collections.sort(list, new Comparator<IJvmFeatureScopeProvider.FeatureScopeDescription>(){

            @Override
            public int compare(IJvmFeatureScopeProvider.FeatureScopeDescription o1, IJvmFeatureScopeProvider.FeatureScopeDescription o2) {
                int prio2;
                int prio1 = o1.getDescriptionProvider().getPriority();
                if (prio1 < (prio2 = o2.getDescriptionProvider().getPriority())) {
                    return 1;
                }
                if (prio1 > prio2) {
                    return -1;
                }
                return 0;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("sortedDescriptionsFromLowestToHighest:\n" + Joiner.on((char)'\n').join(list)));
        }
    }

    protected void addFeatureScopes(JvmTypeReference receiverType, EObject expression, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IJvmFeatureScopeAcceptor acceptor) {
        IAcceptor<IJvmFeatureDescriptionProvider> curried = acceptor.curry(receiverType, expression);
        if (expression instanceof XAssignment) {
            this.addFeatureDescriptionProvidersForAssignment(expression.eResource(), contextType, implicitReceiver, implicitArgument, priority, curried);
        } else {
            this.addFeatureDescriptionProviders(expression.eResource(), contextType, implicitReceiver, implicitArgument, priority, curried);
        }
    }

    protected void addStaticFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        StaticMethodsFeatureForTypeProvider staticProvider = this.newImplicitStaticFeaturesProvider();
        staticProvider.setResourceContext(resource);
        this.addFeatureDescriptionProviders(contextType, staticProvider, null, null, this.getImplicitStaticFeaturePriority(), true, acceptor);
    }

    protected int getThisPriority() {
        return 20;
    }

    protected int getDefaultPriority() {
        return 0;
    }

    protected int getItPriority() {
        return 10;
    }

    protected int getSugarPriorityOffset() {
        return 100;
    }

    protected int getImplicitStaticExtensionPriorityOffset() {
        return 230;
    }

    protected int getImplicitStaticFeaturePriority() {
        return 60;
    }

    protected void addFeatureDescriptionProviders(JvmDeclaredType contextType, IFeaturesForTypeProvider featureProvider, XExpression implicitReceiver, XExpression implicitArgument, int priority, boolean preferStatics, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        DefaultJvmFeatureDescriptionProvider defaultProvider = this.newDefaultFeatureDescriptionProvider();
        defaultProvider.setContextType(contextType);
        defaultProvider.setPriority(priority);
        if (featureProvider != null) {
            defaultProvider.setFeaturesForTypeProvider(featureProvider);
        }
        defaultProvider.setImplicitReceiver(implicitReceiver);
        defaultProvider.setImplicitArgument(implicitArgument);
        defaultProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)defaultProvider);
        XFeatureCallSugarDescriptionProvider sugarProvider = this.newSugarDescriptionProvider();
        sugarProvider.setContextType(contextType);
        sugarProvider.setPriority(priority + this.getSugarPriorityOffset());
        if (featureProvider != null) {
            sugarProvider.setFeaturesForTypeProvider(featureProvider);
        }
        sugarProvider.setImplicitReceiver(implicitReceiver);
        sugarProvider.setImplicitArgument(implicitArgument);
        sugarProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)sugarProvider);
    }

    protected void addFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        this.addFeatureDescriptionProviders(contextType, null, implicitReceiver, implicitArgument, priority, false, acceptor);
        if (implicitArgument == null) {
            StaticMethodsFeatureForTypeProvider implicitStaticFeatures = this.newImplicitStaticFeaturesProvider();
            implicitStaticFeatures.setResourceContext(resource);
            implicitStaticFeatures.setExtensionProvider(true);
            this.addFeatureDescriptionProviders(contextType, implicitStaticFeatures, implicitReceiver, implicitArgument, priority + this.getImplicitStaticExtensionPriorityOffset(), true, acceptor);
        }
    }

    protected StaticMethodsFeatureForTypeProvider newImplicitStaticFeaturesProvider() {
        return (StaticMethodsFeatureForTypeProvider)this.implicitStaticFeatures.get();
    }

    protected void addFeatureDescriptionProvidersForAssignment(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        this.addFeatureDescriptionProvidersForAssignment(contextType, null, implicitReceiver, implicitArgument, priority, false, acceptor);
    }

    protected void addFeatureDescriptionProvidersForAssignment(JvmDeclaredType contextType, IFeaturesForTypeProvider featureProvider, XExpression implicitReceiver, XExpression implicitArgument, int priority, boolean preferStatics, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        XAssignmentDescriptionProvider assignmentProvider = (XAssignmentDescriptionProvider)this.assignmentFeatureDescProvider.get();
        assignmentProvider.setContextType(contextType);
        if (featureProvider != null) {
            assignmentProvider.setFeaturesForTypeProvider(featureProvider);
        }
        assignmentProvider.setImplicitReceiver(implicitReceiver);
        assignmentProvider.setImplicitArgument(implicitArgument);
        assignmentProvider.setPriority(priority);
        assignmentProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)assignmentProvider);
        XAssignmentSugarDescriptionProvider sugarProvider = (XAssignmentSugarDescriptionProvider)this.assignmentSugarFeatureDescProvider.get();
        sugarProvider.setContextType(contextType);
        if (featureProvider != null) {
            sugarProvider.setFeaturesForTypeProvider(featureProvider);
        }
        sugarProvider.setImplicitReceiver(implicitReceiver);
        sugarProvider.setImplicitArgument(implicitArgument);
        sugarProvider.setPriority(this.getSugarPriorityOffset() + priority);
        sugarProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)sugarProvider);
    }

    protected IScope createLocalScopeForParameter(JvmFormalParameter p, IScope parentScope) {
        return p.getName() != null ? new JvmFeatureScope(parentScope, "JvmFormalParameter", this.createLocalVarDescription(p)) : parentScope;
    }

    protected IValidatedEObjectDescription createLocalVarDescription(JvmFormalParameter p) {
        return new LocalVarDescription(QualifiedName.create((String[])new String[]{p.getName()}), (JvmIdentifiableElement)p);
    }

    protected IValidatedEObjectDescription createLocalVarDescription(XVariableDeclaration varDecl) {
        return new LocalVarDescription(QualifiedName.create((String[])new String[]{varDecl.getName()}), varDecl);
    }

    protected DefaultJvmFeatureDescriptionProvider newDefaultFeatureDescriptionProvider() {
        return (DefaultJvmFeatureDescriptionProvider)this.defaultFeatureDescProvider.get();
    }

    protected XFeatureCallSugarDescriptionProvider newSugarDescriptionProvider() {
        return (XFeatureCallSugarDescriptionProvider)this.sugarFeatureDescProvider.get();
    }

    protected FeatureCallToJavaMapping getFeatureCallToJavaMapping() {
        return this.featureCallToJavaMapping;
    }

    protected ITypeArgumentContextHelper getTypeArgumentContextHelper() {
        return this.typeArgumentContextHelper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJvmFeatureScopeAcceptor
    implements IJvmFeatureScopeAcceptor {
        protected AbstractJvmFeatureScopeAcceptor() {
        }

        @Override
        public IAcceptor<IJvmFeatureDescriptionProvider> curry(JvmTypeReference featureDeclarator, EObject expression) {
            return new SimpleAcceptor(this, featureDeclarator, expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GenericTypeArgumentContextFactory
    implements Function<JvmFeatureDescription, ITypeArgumentContext> {
        private final EObject expression;
        private final JvmTypeReference receiverType;

        public GenericTypeArgumentContextFactory(JvmTypeReference receiverType, EObject expression) {
            this.receiverType = receiverType;
            this.expression = expression;
        }

        public ITypeArgumentContext apply(JvmFeatureDescription from) {
            JvmIdentifiableElement feature = from.getEObjectOrProxy();
            if (feature instanceof JvmExecutable && this.expression instanceof XAbstractFeatureCall) {
                XAbstractFeatureCall featureCall = (XAbstractFeatureCall)this.expression;
                List<XExpression> arguments = XbaseScopeProvider.this.featureCallToJavaMapping.getActualArguments(featureCall, feature, from.getImplicitReceiver(), from.getImplicitArgument());
                ITypeArgumentContext result = XbaseScopeProvider.this.typeArgumentContextHelper.getTypeArgumentContext(featureCall, arguments, (Provider<JvmTypeReference>)(this.receiverType != null ? Providers.of((Object)this.receiverType) : null), feature);
                return result;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IJvmFeatureScopeAcceptor {
        public void acceptScope(JvmTypeReference var1, Function<JvmFeatureDescription, ITypeArgumentContext> var2, IJvmFeatureDescriptionProvider var3);

        public IAcceptor<IJvmFeatureDescriptionProvider> curry(JvmTypeReference var1, EObject var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JvmFeatureScopeAcceptor
    extends AbstractJvmFeatureScopeAcceptor {
        private final List<IJvmFeatureScopeProvider.FeatureScopeDescription> descriptions = Lists.newArrayList();

        @Override
        public void acceptScope(JvmTypeReference featureDeclarator, Function<JvmFeatureDescription, ITypeArgumentContext> contextFactory, IJvmFeatureDescriptionProvider provider) {
            this.descriptions.add(new IJvmFeatureScopeProvider.FeatureScopeDescription(featureDeclarator, contextFactory, provider));
        }

        public IScope createScope(IScope parent) {
            if (this.descriptions.isEmpty()) {
                return parent;
            }
            XbaseScopeProvider.this.sortDescriptionsFromLowestToHighest(this.descriptions);
            JvmFeatureScope result = XbaseScopeProvider.this.jvmFeatureScopeProvider.createFeatureScope(parent, this.descriptions);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleAcceptor
    implements IAcceptor<IJvmFeatureDescriptionProvider> {
        private final Function<JvmFeatureDescription, ITypeArgumentContext> contextFactory;
        private final IJvmFeatureScopeAcceptor parent;
        private final JvmTypeReference receiverType;
        private final EObject expression;

        protected SimpleAcceptor(IJvmFeatureScopeAcceptor parent, JvmTypeReference receiverType, EObject expression) {
            this.parent = parent;
            this.receiverType = receiverType;
            this.expression = expression;
            this.contextFactory = new GenericTypeArgumentContextFactory(receiverType, expression);
        }

        public void accept(IJvmFeatureDescriptionProvider provider) {
            this.parent.acceptScope(this.receiverType, this.contextFactory, provider);
        }

        public IJvmFeatureScopeAcceptor getParent() {
            return this.parent;
        }

        public EObject getExpression() {
            return this.expression;
        }

        public JvmTypeReference getReceiverType() {
            return this.receiverType;
        }
    }
}

