/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.dispatch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchingSupport {
    @Inject
    private FeatureOverridesService overridesService;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private Primitives primitives;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private VisibilityService visibilityService;

    public Multimap<Pair<String, Integer>, JvmOperation> getDispatchMethods(JvmGenericType type) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        this.collectDispatchMethods(type, (Multimap<Pair<String, Integer>, JvmOperation>)result);
        return result;
    }

    public JvmOperation findSyntheticDispatchMethod(XtendClass clazz, final Pair<String, Integer> signature) {
        Iterable filter = Iterables.filter((Iterable)Iterables.filter(clazz.getMembers(), XtendFunction.class), (Predicate)new Predicate<XtendFunction>(){

            public boolean apply(XtendFunction input) {
                return input.isDispatch() && input.getParameters().size() == ((Integer)signature.getSecond()).intValue() && input.getName().equals(signature.getFirst());
            }
        });
        Iterator iterator = filter.iterator();
        if (iterator.hasNext()) {
            return this.associations.getDispatchOperation((XtendFunction)iterator.next());
        }
        return null;
    }

    protected void collectDispatchMethods(JvmGenericType type, Multimap<Pair<String, Integer>, JvmOperation> result) {
        Iterable features = Iterables.filter((Iterable)this.overridesService.getAllJvmFeatures((JvmTypeReference)this.typeRefs.createTypeRef((JvmType)type, new JvmTypeReference[0])), JvmOperation.class);
        for (JvmOperation operation : features) {
            if (!this.isDispatchOperation(operation, type)) continue;
            Pair signatureTuple = Tuples.create((Object)operation.getSimpleName().substring(1), (Object)operation.getParameters().size());
            result.put((Object)signatureTuple, (Object)operation);
        }
        this.removeNonLocalMethods(type, result);
    }

    protected void removeNonLocalMethods(final JvmGenericType type, Multimap<Pair<String, Integer>, JvmOperation> result) {
        ArrayList removeKeys = Lists.newArrayList();
        for (Pair signatureTuple : result.keySet()) {
            Collection collection = result.get((Object)signatureTuple);
            if (Iterables.any((Iterable)collection, (Predicate)new Predicate<JvmOperation>(){

                public boolean apply(JvmOperation input) {
                    return input.getDeclaringType() == type;
                }
            })) continue;
            removeKeys.add(signatureTuple);
        }
        for (Pair signatureTuple : removeKeys) {
            result.removeAll((Object)signatureTuple);
        }
    }

    protected boolean isDispatchOperation(JvmOperation operation, JvmGenericType contextType) {
        if (this.visibilityService.isVisible((JvmMember)operation, (JvmDeclaredType)contextType)) {
            ArrayList sourceElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.associations.getSourceElements((EObject)operation), XtendFunction.class));
            if (sourceElements.size() == 1) {
                XtendFunction xtendFunction = (XtendFunction)sourceElements.get(0);
                return xtendFunction.isDispatch() && operation.getSimpleName().equals("_" + xtendFunction.getName());
            }
            return !operation.getParameters().isEmpty() && !operation.isStatic() && operation.getSimpleName().startsWith("_");
        }
        return false;
    }

    public List<JvmOperation> sort(Collection<JvmOperation> collection) {
        ArrayList list = Lists.newArrayList(collection);
        Collections.sort(list, new Comparator<JvmOperation>(){

            @Override
            public int compare(JvmOperation o1, JvmOperation o2) {
                return DispatchingSupport.this.compare(o1, o2);
            }
        });
        return list;
    }

    protected int compare(JvmOperation o1, JvmOperation o2) {
        int params = o1.getParameters().size();
        int i = 0;
        while (i < params) {
            int distance2;
            JvmTypeReference p1 = ((JvmFormalParameter)o1.getParameters().get(i)).getParameterType();
            JvmTypeReference p2 = ((JvmFormalParameter)o2.getParameters().get(i)).getParameterType();
            int distance1 = p1 == null ? Integer.MAX_VALUE : this.getMaxDistanceToObject(p1);
            int n = distance2 = p2 == null ? Integer.MAX_VALUE : this.getMaxDistanceToObject(p2);
            if (distance1 != distance2) {
                return distance2 - distance1;
            }
            ++i;
        }
        String identifier1 = o1.getIdentifier();
        String parameterTypes1 = identifier1.substring(identifier1.indexOf(40));
        String identifier2 = o2.getIdentifier();
        String parameterTypes2 = identifier2.substring(identifier2.indexOf(40));
        return parameterTypes1.compareTo(parameterTypes2);
    }

    protected int getMaxDistanceToObject(JvmTypeReference type) {
        if (this.typeRefs.is(type = this.primitives.asWrapperTypeIfPrimitive(type), Object.class)) {
            return 0;
        }
        JvmType jvmType = type.getType();
        int maxDistance = 1;
        if (jvmType instanceof JvmDeclaredType) {
            EList list = ((JvmDeclaredType)jvmType).getSuperTypes();
            for (JvmTypeReference jvmTypeReference : list) {
                int result = 1 + this.getMaxDistanceToObject(jvmTypeReference);
                if (result <= maxDistance) continue;
                maxDistance = result;
            }
        }
        return maxDistance;
    }
}

