/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.resource;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.resource.XbaseResource;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.typing.XtendOverridesService;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2Resource
extends XbaseResource {
    public static final String FRAGMENT_PREFIX = "\u00a7lazyType$";
    public static final Logger LOG = Logger.getLogger(Xtend2Resource.class);
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private JvmOnlyTypeConformanceComputer jvmTypeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private XtendOverridesService overridesService;
    private Set<String> computingFragments = Sets.newLinkedHashSet();

    public synchronized EObject getEObject(String uriFragment) {
        if (!uriFragment.startsWith(FRAGMENT_PREFIX)) {
            return super.getEObject(uriFragment);
        }
        if (!this.computingFragments.add(uriFragment)) {
            return null;
        }
        try {
            String fragmentToJvmOperation = uriFragment.substring(FRAGMENT_PREFIX.length());
            EObject eObject = super.getEObject(fragmentToJvmOperation);
            if (eObject instanceof XExpression) {
                EObject eObject2 = EcoreUtil2.cloneIfContained((EObject)this.typeProvider.getType((XExpression)eObject));
                return eObject2;
            }
            if (eObject instanceof JvmOperation) {
                JvmOperation op = (JvmOperation)eObject;
                JvmTypeReference typeReference = this.inferReturnType(op);
                if (typeReference == null || typeReference.getType() == null) {
                    JvmTypeReference jvmTypeReference = this.typeReferences.getTypeForName(Object.class, (EObject)this.getContents().get(0), new JvmTypeReference[0]);
                    return jvmTypeReference;
                }
                if (typeReference.eContainer() != null && typeReference.eContainer() != op) {
                    typeReference = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)typeReference);
                }
                JvmTypeReference jvmTypeReference = typeReference;
                return jvmTypeReference;
            }
            if (eObject instanceof JvmFormalParameter) {
                int index;
                JvmFormalParameter param = (JvmFormalParameter)eObject;
                JvmOperation op = (JvmOperation)param.eContainer();
                Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods((JvmGenericType)op.getDeclaringType());
                Collection dispatchOperations = dispatchMethods.get((Object)Tuples.pair((Object)op.getSimpleName(), (Object)op.getParameters().size()));
                JvmTypeReference commonType = this.commonType(dispatchOperations, new Function<JvmOperation, JvmTypeReference>(index = op.getParameters().indexOf((Object)param)){
                    private final /* synthetic */ int val$index;
                    {
                        this.val$index = n;
                    }

                    public JvmTypeReference apply(JvmOperation from) {
                        return ((JvmFormalParameter)from.getParameters().get(this.val$index)).getParameterType();
                    }
                });
                if (commonType != null && commonType.eContainer() != null) {
                    commonType = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)commonType);
                }
                JvmTypeReference jvmTypeReference = commonType;
                return jvmTypeReference;
            }
            try {
                throw new IllegalStateException("couldn't resolve type proxy in " + eObject);
            }
            catch (RuntimeException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            this.computingFragments.remove(uriFragment);
        }
    }

    protected JvmTypeReference inferReturnType(JvmOperation jvmOperation) {
        ArrayList associatedReturnTypes = Lists.newArrayList();
        Iterable associatedElements = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
        boolean wasDispatch = false;
        for (XtendFunction func : associatedElements) {
            JvmTypeReference type = this.computeReturnType(func);
            if (type != null && !(type instanceof JvmAnyTypeReference)) {
                associatedReturnTypes.add(type);
            }
            wasDispatch |= func.isDispatch();
        }
        if (wasDispatch) {
            if (jvmOperation.getSimpleName().startsWith("_")) {
                for (XtendFunction func : associatedElements) {
                    if (func.getReturnType() != null) {
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)func.getReturnType());
                    }
                    JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                    if (overriddenOperation != null) {
                        JvmTypeReference result = overriddenOperation.getReturnType();
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                    }
                    JvmOperation dispatchOperation = this.associations.getDispatchOperation(func);
                    if (dispatchOperation == null) continue;
                    JvmTypeReference result = dispatchOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            } else {
                JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                if (overriddenOperation != null) {
                    JvmTypeReference result = overriddenOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            }
        }
        if (!associatedReturnTypes.isEmpty()) {
            JvmTypeReference commonSuperType = this.typeConformanceComputer.getCommonSuperType((List)associatedReturnTypes);
            return commonSuperType;
        }
        return null;
    }

    protected <T> JvmTypeReference commonType(Iterable<? extends T> iterable, Function<T, JvmTypeReference> mapping) {
        ArrayList references = Lists.newArrayList();
        for (T element : iterable) {
            JvmTypeReference apply = (JvmTypeReference)mapping.apply(element);
            if (this.typeReferences.isNullOrProxy(apply)) continue;
            references.add(apply);
        }
        JvmTypeReference result = this.jvmTypeConformanceComputer.getCommonSuperType((List)references);
        while (result instanceof JvmMultiTypeReference) {
            result = this.jvmTypeConformanceComputer.getCommonSuperType((List)((JvmMultiTypeReference)result).getReferences());
        }
        return result;
    }

    protected JvmTypeReference computeReturnType(XtendFunction function) {
        JvmTypeReference declaredOrInferredReturnType = this.getDeclaredOrOverriddenReturnType(function);
        if (declaredOrInferredReturnType != null) {
            return declaredOrInferredReturnType;
        }
        JvmTypeReference returnType = this.typeProvider.getCommonReturnType(function.getExpression(), true);
        if (returnType != null && returnType.getType() != null) {
            JvmOperation operation = this.associations.getDirectlyInferredOperation(function);
            if (operation == null) {
                return null;
            }
            JvmDeclaredType declaringType = operation.getDeclaringType();
            for (JvmTypeReference reference : Iterables.filter((Iterable)EcoreUtil2.eAllContents((EObject)returnType), JvmTypeReference.class)) {
                JvmTypeParameter parameter;
                if (!(reference.getType() instanceof JvmTypeParameter) || (parameter = (JvmTypeParameter)reference.getType()).getDeclarator() == declaringType || parameter.getDeclarator() == operation) continue;
                returnType = (JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)returnType);
                HashSet replaceUs = Sets.newHashSet();
                for (JvmTypeReference containerOfReplaced : Iterables.filter((Iterable)EcoreUtil2.eAllContents((EObject)returnType), JvmTypeReference.class)) {
                    if (!(containerOfReplaced.getType() instanceof JvmTypeParameter)) continue;
                    replaceUs.add(containerOfReplaced);
                }
                block2: for (JvmTypeReference replaceMe : replaceUs) {
                    JvmConstraintOwner constraintOwner;
                    if (replaceMe.eContainer() instanceof JvmTypeConstraint) {
                        JvmTypeConstraint containerConstraint = (JvmTypeConstraint)replaceMe.eContainer();
                        JvmConstraintOwner constraintOwner2 = (JvmConstraintOwner)replaceMe.getType();
                        for (JvmTypeConstraint constraint : constraintOwner2.getConstraints()) {
                            if (constraint.eClass() != containerConstraint.eClass()) continue;
                            containerConstraint.setTypeReference((JvmTypeReference)EcoreUtil2.clone((EObject)constraint.getTypeReference()));
                            continue block2;
                        }
                        continue;
                    }
                    if (replaceMe.eContainer() != null) {
                        constraintOwner = (JvmConstraintOwner)replaceMe.getType();
                        JvmWildcardTypeReference wildCard = this.typeReferences.wildCard();
                        for (JvmTypeConstraint constraint : constraintOwner.getConstraints()) {
                            wildCard.getConstraints().add((Object)((JvmTypeConstraint)EcoreUtil2.clone((EObject)constraint)));
                        }
                        EcoreUtil.replace((EObject)replaceMe, (EObject)wildCard);
                        continue;
                    }
                    constraintOwner = (JvmConstraintOwner)replaceMe.getType();
                    ArrayList superTypes = Lists.newArrayListWithExpectedSize((int)constraintOwner.getConstraints().size());
                    for (JvmTypeConstraint constraint : constraintOwner.getConstraints()) {
                        if (!(constraint instanceof JvmUpperBound)) continue;
                        superTypes.add(constraint.getTypeReference());
                    }
                    if (superTypes.isEmpty()) {
                        return this.typeReferences.getTypeForName(Object.class, (EObject)function, new JvmTypeReference[0]);
                    }
                    return this.typeConformanceComputer.getCommonSuperType((List)superTypes);
                }
                return returnType;
            }
            return returnType;
        }
        return this.typeReferences.getTypeForName(Object.class, (EObject)function, new JvmTypeReference[0]);
    }

    public JvmTypeReference getDeclaredOrOverriddenReturnType(XtendFunction func) {
        JvmTypeReference overridden;
        if (func.getReturnType() != null) {
            return func.getReturnType();
        }
        if (func.isOverride() && (overridden = this.overridesService.getOverriddenReturnType(func)) != null) {
            return overridden;
        }
        if (func.getCreateExtensionInfo() != null) {
            return this.typeProvider.getType(func.getCreateExtensionInfo().getCreateExpression());
        }
        return null;
    }
}

