/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.ecoreInference.DatatypeRuleUtil;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;
import org.eclipse.xtext.xtext.ecoreInference.ErrorAcceptor;
import org.eclipse.xtext.xtext.ecoreInference.IXtext2EcorePostProcessor;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.TransformationException;
import org.eclipse.xtext.xtext.ecoreInference.TypeHierarchyHelper;
import org.eclipse.xtext.xtext.ecoreInference.Xtext2EcoreInterpretationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtext2EcoreTransformer {
    private static final Logger log = Logger.getLogger(Xtext2EcoreTransformer.class);
    private final Grammar grammar;
    private Map<String, EPackage> generatedEPackages;
    private EClassifierInfos eClassifierInfos;
    private ErrorAcceptor errorAcceptor = new NullErrorAcceptor();
    private IXtext2EcorePostProcessor postProcessor;

    public Xtext2EcoreTransformer(Grammar grammar) {
        this.grammar = grammar;
    }

    public ErrorAcceptor getErrorAcceptor() {
        return this.errorAcceptor;
    }

    public void setErrorAcceptor(ErrorAcceptor errorAcceptor) {
        this.errorAcceptor = errorAcceptor;
    }

    public void setPostProcessor(IXtext2EcorePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public static void doTransform(Grammar grammar) {
        new Xtext2EcoreTransformer(grammar).transform();
    }

    public static List<EPackage> doGetGeneratedPackages(Grammar grammar) {
        return new Xtext2EcoreTransformer(grammar).getGeneratedPackages();
    }

    public List<EPackage> getGeneratedPackages() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        ResourceSet resourceSet = this.grammar.eResource().getResourceSet();
        if (resourceSet == null) {
            throw new NullPointerException("resourceSet may not be null");
        }
        Iterables.addAll(result, (Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter(this.grammar.getMetamodelDeclarations(), GeneratedMetamodel.class), (Function)new Function<AbstractMetamodelDeclaration, EPackage>(){

            public EPackage apply(AbstractMetamodelDeclaration param) {
                return param.getEPackage();
            }
        }), (Predicate)Predicates.notNull()));
        return Xtext2EcoreTransformer.getPackagesSortedByName(result);
    }

    public void transform() {
        this.eClassifierInfos = new EClassifierInfos(this.grammar);
        this.generatedEPackages = Maps.newLinkedHashMap();
        this.collectEClassInfosOfUsedGrammars();
        this.collectEPackages();
        if (!this.deriveTypes()) {
            return;
        }
        if (!this.deriveFeatures()) {
            return;
        }
        this.normalizeAndValidateGeneratedPackages();
        this.postProcessGeneratedPackages();
    }

    public void removeGeneratedPackages() {
        ResourceSet resourceSet = this.grammar.eResource().getResourceSet();
        Iterator resourceIter = resourceSet.getResources().iterator();
        List<EPackage> packages = this.getGeneratedPackages();
        block0: while (resourceIter.hasNext()) {
            Resource r = (Resource)resourceIter.next();
            for (EObject content : r.getContents()) {
                if ((!(content instanceof EPackage) || !packages.contains(content)) && (this.generatedEPackages == null || !this.generatedEPackages.containsValue(content))) continue;
                this.clearPackage(r, (EPackage)content);
                continue block0;
            }
        }
    }

    protected void clearPackage(Resource resource, EPackage pack) {
        HashMap uris = Maps.newHashMap();
        for (EClassifier classifier : pack.getEClassifiers()) {
            InternalEObject internalEObject = (InternalEObject)classifier;
            URI appendFragment = resource.getURI().appendFragment(resource.getURIFragment((EObject)internalEObject));
            uris.put(internalEObject, appendFragment);
        }
        pack.getEClassifiers().clear();
        for (Map.Entry entry : uris.entrySet()) {
            ((InternalEObject)entry.getKey()).eSetProxyURI((URI)entry.getValue());
        }
    }

    private static List<EPackage> getPackagesSortedByName(Collection<EPackage> packages) {
        ArrayList<EPackage> result = new ArrayList<EPackage>(packages);
        Collections.sort(result, new Comparator<EPackage>(){

            @Override
            public int compare(EPackage o1, EPackage o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    private boolean deriveTypes() {
        return this.deriveTypesImpl() && this.checkDatatypeRules() && this.deriveTypeHierarchy();
    }

    private boolean deriveTypeHierarchy() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                EClassifierInfo generatedEClass = this.findOrCreateEClassifierInfo(rule);
                if (rule instanceof ParserRule) {
                    ParserRule parserRule = (ParserRule)rule;
                    if (parserRule.getAlternatives() == null) continue;
                    if (!GrammarUtil.isDatatypeRule(parserRule)) {
                        this.deriveTypesAndHierarchy(parserRule, generatedEClass, parserRule.getAlternatives());
                        continue;
                    }
                    this.checkSupertypeOfOverriddenDatatypeRule(rule);
                    continue;
                }
                if (rule instanceof TerminalRule) {
                    if (rule.getType() == null) continue;
                    if (!(rule.getType().getClassifier() instanceof EDataType)) {
                        throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Return type of a terminal rule must be an EDataType.", rule.getType());
                    }
                    this.checkSupertypeOfOverriddenDatatypeRule(rule);
                    continue;
                }
                if (rule instanceof EnumRule) {
                    if (rule.getType() == null) continue;
                    if (!(rule.getType().getClassifier() instanceof EEnum)) {
                        throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Return type of an enum rule must be an EEnum.", rule.getType());
                    }
                    this.checkSupertypeOfOverriddenDatatypeRule(rule);
                    continue;
                }
                throw new IllegalStateException("Unknown rule type: " + rule.eClass().getName());
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private void checkSupertypeOfOverriddenDatatypeRule(AbstractRule rule) throws TransformationException {
        EDataType datatype = (EDataType)rule.getType().getClassifier();
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            TerminalRule terminal;
            AbstractRule parentRule = GrammarUtil.findRuleForName(usedGrammar, rule.getName());
            if (parentRule == null || parentRule == rule) continue;
            if (parentRule.getType() == null || parentRule.getType().getClassifier() == null) {
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot determine return type of overridden rule.", rule.getType());
            }
            if (!datatype.equals(parentRule.getType().getClassifier())) {
                String ruleName = this.getRuleNameForErrorMessage(parentRule);
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot inherit from " + ruleName + "rule and return another type.", rule.getType());
            }
            if (parentRule.eClass() != rule.eClass()) {
                if (parentRule instanceof EnumRule || parentRule instanceof ParserRule) {
                    if (rule instanceof TerminalRule && ((TerminalRule)rule).isFragment()) {
                        throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "A terminal fragment cannot override enum rule " + rule.getName() + ".", rule);
                    }
                } else if (parentRule instanceof TerminalRule) {
                    String ruleName = this.getRuleNameForErrorMessage(rule);
                    throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "A " + ruleName + " rule cannot override a terminal rule.", rule);
                }
            }
            if (rule instanceof TerminalRule && parentRule instanceof TerminalRule && (terminal = (TerminalRule)rule).isFragment() && !((TerminalRule)parentRule).isFragment()) {
                String message = "Terminal fragment cannot inherit from terminal rule '" + parentRule.getName() + "'";
                throw new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, message, rule);
            }
            return;
        }
    }

    protected String getRuleNameForErrorMessage(AbstractRule rule) {
        String ruleName = "datatype ";
        if (rule instanceof TerminalRule) {
            ruleName = "terminal ";
        } else if (rule instanceof EnumRule) {
            ruleName = "enum ";
        }
        return ruleName;
    }

    private boolean deriveTypesImpl() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                this.findOrCreateEClassifierInfo(rule);
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private boolean checkDatatypeRules() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                if (!(rule instanceof ParserRule) || !GrammarUtil.isDatatypeRule((ParserRule)rule) || DatatypeRuleUtil.isValidDatatypeRule((ParserRule)rule)) continue;
                throw new TransformationException(TransformationErrorCode.InvalidDatatypeRule, "Datatype rules may only use other datatype rules, lexer rules and keywords.", rule);
            }
            catch (TransformationException e) {
                this.reportError(e);
                result = false;
            }
        }
        return result;
    }

    private boolean deriveFeatures() {
        boolean result = true;
        for (AbstractRule rule : this.grammar.getRules()) {
            try {
                if (rule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                    this.deriveFeatures((ParserRule)rule);
                    continue;
                }
                if (!(rule instanceof EnumRule)) continue;
                this.deriveEnums((EnumRule)rule);
            }
            catch (TransformationException e) {
                result = false;
                this.reportError(e);
            }
        }
        return result;
    }

    private void deriveEnums(EnumRule rule) {
        EEnum returnType = (EEnum)rule.getType().getClassifier();
        if (returnType != null) {
            List<EnumLiteralDeclaration> decls = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
            for (EnumLiteralDeclaration decl : decls) {
                List<INode> nodes;
                if (decl.getEnumLiteral() == null && !(nodes = NodeModelUtils.findNodesForFeature(decl, (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__ENUM_LITERAL)).isEmpty()) {
                    if (nodes.size() > 1) {
                        throw new IllegalStateException("Unexpected nodes found: " + nodes);
                    }
                    INode node = nodes.get(0);
                    String text = node.getText();
                    EEnumLiteral literal = null;
                    if (rule.getType().getMetamodel() instanceof ReferencedMetamodel) {
                        literal = returnType.getEEnumLiteral(text);
                    } else {
                        EEnumLiteral existing = returnType.getEEnumLiteral(text);
                        if (existing == null) {
                            literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                            returnType.getELiterals().add((Object)literal);
                            literal.setName(text);
                            literal.setValue(decls.indexOf(decl));
                            if (decl.getLiteral() != null) {
                                literal.setLiteral(decl.getLiteral().getValue());
                            } else {
                                literal.setLiteral(text);
                            }
                        } else {
                            literal = existing;
                        }
                        SourceAdapter.adapt((EObject)literal, decl);
                    }
                    if (literal == null) {
                        this.reportError(new TransformationException(TransformationErrorCode.InvalidFeature, "Enum literal '" + text + "' does not exist.", decl));
                    } else {
                        decl.setEnumLiteral(literal);
                    }
                }
                if (decl.getLiteral() != null || decl.getEnumLiteral() == null) continue;
                Keyword kw = XtextFactory.eINSTANCE.createKeyword();
                kw.setValue(decl.getEnumLiteral().getLiteral());
                decl.setLiteral(kw);
            }
        }
    }

    private Xtext2EcoreInterpretationContext deriveFeatures(final Xtext2EcoreInterpretationContext context, AbstractElement element) {
        XtextSwitch<Xtext2EcoreInterpretationContext> visitor = new XtextSwitch<Xtext2EcoreInterpretationContext>(){

            @Override
            public Xtext2EcoreInterpretationContext caseCompoundElement(CompoundElement object) {
                ArrayList<Xtext2EcoreInterpretationContext> contexts = new ArrayList<Xtext2EcoreInterpretationContext>();
                for (AbstractElement group : object.getElements()) {
                    contexts.add(Xtext2EcoreTransformer.this.deriveFeatures(context, group));
                }
                Xtext2EcoreInterpretationContext result = context;
                if (!contexts.isEmpty()) {
                    if (GrammarUtil.isOptionalCardinality(object)) {
                        contexts.add(0, result);
                    } else {
                        result = (Xtext2EcoreInterpretationContext)contexts.get(0);
                    }
                    result = result.mergeSpawnedContexts(contexts);
                }
                return result;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseAssignment(Assignment object) {
                try {
                    context.addFeature(object);
                }
                catch (TransformationException ex) {
                    Xtext2EcoreTransformer.this.reportError(ex);
                }
                return context;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseGroup(Group object) {
                Xtext2EcoreInterpretationContext result = Xtext2EcoreTransformer.this.deriveFeatures(context.spawnContextForGroup(), (EList<AbstractElement>)object.getElements());
                if (GrammarUtil.isOptionalCardinality(object)) {
                    result = result.mergeSpawnedContexts(Arrays.asList(context, result));
                }
                return result;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseRuleCall(RuleCall object) {
                AbstractRule calledRule;
                if (!GrammarUtil.isOptionalCardinality(object) && (calledRule = object.getRule()) != null && calledRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)calledRule)) {
                    try {
                        EClassifierInfo eClassifierInfo = Xtext2EcoreTransformer.this.findOrCreateEClassifierInfo(calledRule);
                        return context.spawnContextWithCalledRule(eClassifierInfo, object);
                    }
                    catch (TransformationException e) {
                        Xtext2EcoreTransformer.this.reportError(e);
                    }
                }
                return context;
            }

            @Override
            public Xtext2EcoreInterpretationContext caseAction(Action object) {
                try {
                    TypeRef actionTypeRef = object.getType();
                    EClassifierInfo actionType = Xtext2EcoreTransformer.this.findOrCreateEClassifierInfo(actionTypeRef, null, true);
                    EClassifierInfo currentCompatibleType = context.getCurrentCompatibleType();
                    Xtext2EcoreInterpretationContext ctx = context.spawnContextWithReferencedType(actionType, object);
                    if (object.getFeature() != null) {
                        ctx.addFeature(object.getFeature(), currentCompatibleType, GrammarUtil.isMultipleAssignment(object), true, object);
                    }
                    return ctx;
                }
                catch (TransformationException e) {
                    Xtext2EcoreTransformer.this.reportError(e);
                    return context;
                }
            }

            @Override
            public Xtext2EcoreInterpretationContext defaultCase(EObject object) {
                return context;
            }
        };
        return (Xtext2EcoreInterpretationContext)visitor.doSwitch(element);
    }

    private Xtext2EcoreInterpretationContext deriveFeatures(Xtext2EcoreInterpretationContext context, EList<AbstractElement> elements) {
        Xtext2EcoreInterpretationContext result = context;
        for (AbstractElement element : elements) {
            result = this.deriveFeatures(result, element);
        }
        return result;
    }

    private void deriveFeatures(ParserRule rule) throws TransformationException {
        EClassifierInfo classInfo = this.findEClassifierInfo(rule);
        if (classInfo == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "No type available for rule " + rule.getName(), rule);
        }
        Xtext2EcoreInterpretationContext context = new Xtext2EcoreInterpretationContext(this.eClassifierInfos, classInfo);
        if (rule.getAlternatives() != null) {
            this.deriveFeatures(context, rule.getAlternatives());
        }
    }

    private TypeRef getOrComputeReturnType(AbstractRule rule) {
        TypeRef result = rule.getType();
        if (result == null) {
            EClassifier classifier = this.getClassifierFor(rule);
            if (classifier == null) {
                if (rule.getName() == null) {
                    return null;
                }
                result = this.getTypeRef(rule.getName());
            } else {
                result = this.getTypeRef(classifier);
            }
            if (result.getMetamodel() == null) {
                AbstractMetamodelDeclaration bestMatch = null;
                for (AbstractMetamodelDeclaration decl : this.grammar.getMetamodelDeclarations()) {
                    if (!(decl instanceof GeneratedMetamodel) || !Strings.isEmpty((String)decl.getAlias())) continue;
                    bestMatch = decl;
                    break;
                }
                if (result.getMetamodel() == null) {
                    result.setMetamodel(bestMatch);
                }
            }
            rule.setType(result);
        }
        return result;
    }

    EClassifier getClassifierFor(AbstractRule rule) {
        if (rule.getType() != null && rule.getType().getClassifier() != null) {
            return rule.getType().getClassifier();
        }
        if (rule instanceof TerminalRule || rule instanceof ParserRule && DatatypeRuleUtil.isDatatypeRule((ParserRule)rule)) {
            return GrammarUtil.findEString(this.grammar);
        }
        return null;
    }

    TypeRef getTypeRef(EClassifier classifier) {
        TypeRef result = XtextFactory.eINSTANCE.createTypeRef();
        result.setClassifier(classifier);
        EPackage pack = classifier.getEPackage();
        for (AbstractMetamodelDeclaration decl : GrammarUtil.allMetamodelDeclarations(this.grammar)) {
            if (!pack.equals(decl.getEPackage())) continue;
            result.setMetamodel(decl);
            return result;
        }
        return result;
    }

    TypeRef getTypeRef(String qualifiedName) {
        TypeRef result = XtextFactory.eINSTANCE.createTypeRef();
        String[] split = qualifiedName.split("::");
        String name = qualifiedName;
        if (split.length > 1) {
            result.setMetamodel(this.findMetamodel(this.grammar, split[0], split[1]));
            name = split[1];
        } else {
            result.setMetamodel(this.findDefaultMetamodel(this.grammar, qualifiedName));
        }
        if (result.getMetamodel() instanceof ReferencedMetamodel && result.getMetamodel().getEPackage() != null) {
            result.setClassifier(result.getMetamodel().getEPackage().getEClassifier(name));
        }
        return result;
    }

    public AbstractMetamodelDeclaration findDefaultMetamodel(Grammar grammar, String containedClassifier) {
        return this.findMetamodel(grammar, "", containedClassifier);
    }

    public AbstractMetamodelDeclaration findMetamodel(Grammar grammar, String alias, String containedClassifier) {
        EList<AbstractMetamodelDeclaration> declarations = grammar.getMetamodelDeclarations();
        AbstractMetamodelDeclaration result = null;
        for (AbstractMetamodelDeclaration decl : declarations) {
            EPackage pack;
            if (!this.isSameAlias(decl.getAlias(), alias) || (pack = decl.getEPackage()) == null || pack.getEClassifier(containedClassifier) == null) continue;
            if (result != null) {
                return null;
            }
            result = decl;
        }
        return result;
    }

    public boolean isSameAlias(String alias, String alias2) {
        return Strings.isEmpty((String)alias) ? Strings.isEmpty((String)alias2) : alias.equals(alias2);
    }

    private void normalizeAndValidateGeneratedPackages() {
        TypeHierarchyHelper helper = new TypeHierarchyHelper(this.grammar, this.eClassifierInfos, this.errorAcceptor);
        helper.liftUpFeaturesRecursively();
        helper.removeDuplicateDerivedFeatures();
    }

    private void deriveTypesAndHierarchy(final ParserRule rule, final EClassifierInfo ruleReturnType, AbstractElement element) throws TransformationException {
        TransformationException ex = (TransformationException)new XtextSwitch<TransformationException>(){

            @Override
            public TransformationException caseAction(Action action) {
                TypeRef actionTypeRef = action.getType();
                try {
                    Xtext2EcoreTransformer.this.addSuperType(rule, actionTypeRef, ruleReturnType);
                    return null;
                }
                catch (TransformationException ex) {
                    return ex;
                }
            }

            @Override
            public TransformationException caseCompoundElement(CompoundElement object) {
                for (AbstractElement ele : object.getElements()) {
                    try {
                        Xtext2EcoreTransformer.this.deriveTypesAndHierarchy(rule, ruleReturnType, ele);
                    }
                    catch (TransformationException ex) {
                        return ex;
                    }
                }
                return null;
            }

            @Override
            public TransformationException caseRuleCall(RuleCall ruleCall) {
                AbstractRule calledRule = ruleCall.getRule();
                if (calledRule == null) {
                    ICompositeNode node = NodeModelUtils.getNode(ruleCall);
                    if (node != null) {
                        return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot find rule " + node.getText().trim(), ruleCall);
                    }
                    return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot find called rule.", ruleCall);
                }
                if (calledRule instanceof TerminalRule || calledRule instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)calledRule)) {
                    return null;
                }
                if (calledRule instanceof EnumRule) {
                    return new TransformationException(TransformationErrorCode.NoSuchRuleAvailable, "Cannot call enum rule without assignment.", ruleCall);
                }
                TypeRef calledRuleReturnTypeRef = Xtext2EcoreTransformer.this.getOrComputeReturnType(calledRule);
                try {
                    Xtext2EcoreTransformer.this.addSuperType(rule, calledRuleReturnTypeRef, ruleReturnType);
                }
                catch (TransformationException ex) {
                    return ex;
                }
                return null;
            }
        }.doSwitch(element);
        if (ex != null) {
            throw ex;
        }
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            if (!this.deriveTypeHierarchyFromOverridden(rule, usedGrammar)) continue;
            return;
        }
    }

    private boolean deriveTypeHierarchyFromOverridden(ParserRule rule, Grammar grammar) throws TransformationException {
        AbstractRule parentRule = GrammarUtil.findRuleForName(grammar, rule.getName());
        if (parentRule != null && parentRule.getType() != null && parentRule != rule) {
            if (parentRule.getType().getClassifier() instanceof EDataType) {
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot inherit from datatype rule and return another type.", rule.getType());
            }
            EClassifierInfo parentTypeInfo = this.eClassifierInfos.getInfoOrNull(parentRule.getType());
            if (parentTypeInfo == null) {
                throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot determine return type of overridden rule.", rule.getType());
            }
            this.addSuperType(rule, rule.getType(), parentTypeInfo);
            return true;
        }
        return false;
    }

    private void addSuperType(ParserRule rule, TypeRef subTypeRef, EClassifierInfo superTypeInfo) throws TransformationException {
        EClassifierInfo subTypeInfo;
        EClassifier subType = subTypeRef.getClassifier();
        EClassifierInfo eClassifierInfo = subTypeInfo = subType == null ? this.findOrCreateEClassifierInfo(subTypeRef, null, true) : this.eClassifierInfos.getInfoOrNull(subType);
        if (subTypeInfo == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Type '" + superTypeInfo.getEClassifier().getName() + "' is not available.", rule.getType());
        }
        if (superTypeInfo.isAssignableFrom(subTypeInfo)) {
            return;
        }
        if (subTypeInfo.getEClassifier() instanceof EDataType) {
            throw new TransformationException(TransformationErrorCode.InvalidSupertype, "Cannot add supertype '" + superTypeInfo.getEClassifier().getName() + "' to simple datatype '" + subTypeInfo.getEClassifier().getName() + "'.", rule.getType());
        }
        if (!subTypeInfo.isGenerated()) {
            throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot add supertype '" + superTypeInfo.getEClassifier().getName() + "' to sealed type '" + subTypeInfo.getEClassifier().getName() + "'.", rule.getType());
        }
        subTypeInfo.addSupertype(superTypeInfo);
    }

    private void collectEPackages() {
        EList<AbstractMetamodelDeclaration> metamodelDeclarations = this.grammar.getMetamodelDeclarations();
        LinkedHashMap generateUs = Maps.newLinkedHashMap();
        for (AbstractMetamodelDeclaration metamodelDeclaration : metamodelDeclarations) {
            try {
                if (metamodelDeclaration instanceof ReferencedMetamodel) {
                    ReferencedMetamodel referencedMetamodel = (ReferencedMetamodel)metamodelDeclaration;
                    EPackage referencedEPackage = referencedMetamodel.getEPackage();
                    if (referencedEPackage == null) continue;
                    this.collectClassInfosOf(referencedEPackage, referencedMetamodel);
                    continue;
                }
                if (metamodelDeclaration instanceof GeneratedMetamodel) {
                    String alias = Strings.emptyIfNull((String)metamodelDeclaration.getAlias());
                    if (generateUs.containsKey(alias)) {
                        GeneratedMetamodel prev = (GeneratedMetamodel)generateUs.get(alias);
                        if (prev != null) {
                            if (prev.getEPackage() != null) {
                                prev.getEPackage().eResource().getResourceSet().getResources().remove((Object)prev.getEPackage().eResource());
                            }
                            prev.setEPackage(null);
                        }
                        generateUs.put(alias, null);
                        EPackage pack = metamodelDeclaration.getEPackage();
                        if (pack != null) {
                            pack.eResource().getResourceSet().getResources().remove((Object)pack.eResource());
                        }
                        metamodelDeclaration.setEPackage(null);
                        throw new TransformationException(TransformationErrorCode.AliasForMetamodelAlreadyExists, "Alias '" + alias + "' registered more than once.", metamodelDeclaration);
                    }
                    generateUs.put(alias, (GeneratedMetamodel)metamodelDeclaration);
                    continue;
                }
                throw new IllegalStateException("unknown metamodelDeclaraton " + metamodelDeclaration);
            }
            catch (TransformationException e) {
                this.reportError(e);
            }
        }
        for (GeneratedMetamodel metamodel : generateUs.values()) {
            try {
                if (metamodel == null) continue;
                this.addGeneratedEPackage(metamodel);
            }
            catch (TransformationException e) {
                this.reportError(e);
            }
        }
    }

    private void collectEClassInfosOfUsedGrammars() {
        LinkedHashSet visitedGrammars = Sets.newLinkedHashSet();
        visitedGrammars.add(this.grammar);
        for (Grammar usedGrammar : this.grammar.getUsedGrammars()) {
            EClassifierInfos parent = this.createClassifierInfosFor(usedGrammar, visitedGrammars);
            if (parent == null) continue;
            this.getEClassifierInfos().addParent(parent);
        }
    }

    private EClassifierInfos createClassifierInfosFor(Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return null;
        }
        EClassifierInfos result = new EClassifierInfos(grammar);
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            EPackage referencedEPackage = declaration.getEPackage();
            if (referencedEPackage == null) continue;
            this.collectClassInfosOf(result, referencedEPackage, declaration, false);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            EClassifierInfos parent = this.createClassifierInfosFor(usedGrammar, visitedGrammars);
            if (parent == null) continue;
            result.addParent(parent);
        }
        return result;
    }

    private void collectClassInfosOf(EPackage referencedEPackage, AbstractMetamodelDeclaration metaModel) {
        this.collectClassInfosOf(this.eClassifierInfos, referencedEPackage, metaModel, metaModel instanceof GeneratedMetamodel);
    }

    private void collectClassInfosOf(EClassifierInfos target, EPackage referencedEPackage, AbstractMetamodelDeclaration metaModel, boolean generated) {
        for (EClassifier eClassifier : referencedEPackage.getEClassifiers()) {
            EClassifierInfo info;
            if (eClassifier instanceof EClass) {
                EClass eClass = (EClass)eClassifier;
                info = EClassifierInfo.createEClassInfo(eClass, generated, this.getGeneratedEPackageURIs(), GrammarUtil.getGrammar(metaModel));
                target.addInfo(metaModel, eClassifier.getName(), info);
                continue;
            }
            if (!(eClassifier instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eClassifier;
            info = EClassifierInfo.createEDataTypeInfo(eDataType, generated);
            target.addInfo(metaModel, eClassifier.getName(), info);
        }
    }

    private Set<String> getGeneratedEPackageURIs() {
        List<GeneratedMetamodel> list = EcoreUtil2.typeSelect(this.grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        return Sets.newLinkedHashSet((Iterable)Iterables.transform(list, (Function)new Function<GeneratedMetamodel, String>(){

            public String apply(GeneratedMetamodel from) {
                return from.getEPackage() != null ? from.getEPackage().getNsURI() : null;
            }
        }));
    }

    private void reportError(TransformationErrorCode errorCode, String message, EObject erroneousElement) {
        this.errorAcceptor.acceptError(errorCode, message, erroneousElement);
    }

    private void reportError(TransformationException exception) {
        log.trace((Object)exception.getErrorCode(), (Throwable)exception);
        this.reportError(exception.getErrorCode(), exception.getMessage(), exception.getErroneousElement());
    }

    private EClassifierInfo findOrCreateEClassifierInfo(AbstractRule rule) throws TransformationException {
        TypeRef typeRef = this.getOrComputeReturnType(rule);
        if (typeRef == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot create type for unnamed rule.", rule);
        }
        if (typeRef.getMetamodel() != null && typeRef.getMetamodel().getEPackage() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create type without declared package.", typeRef);
        }
        return this.findOrCreateEClassifierInfo(typeRef, rule.getName(), this.grammar.getRules().contains((Object)rule));
    }

    private EClassifierInfo findEClassifierInfo(AbstractRule rule) {
        TypeRef typeRef = this.getOrComputeReturnType(rule);
        if (typeRef == null) {
            throw new NullPointerException();
        }
        if (rule.getType() != typeRef) {
            throw new IllegalStateException();
        }
        return this.eClassifierInfos.getInfo(typeRef);
    }

    private EClassifierInfo findOrCreateEClassifierInfo(TypeRef typeRef, String name, boolean createIfMissing) throws TransformationException {
        if (typeRef.getClassifier() != null && typeRef.getMetamodel() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot find metamodel for type '" + typeRef.getClassifier().getName() + "'", typeRef);
        }
        EClassifierInfo info = this.eClassifierInfos.getInfo(typeRef);
        if (info == null) {
            EDataType dataType = GrammarUtil.findEString(GrammarUtil.getGrammar(typeRef));
            if (dataType != null && typeRef.getClassifier() == dataType && (info = this.eClassifierInfos.getInfoOrNull(typeRef)) != null) {
                return info;
            }
            if (createIfMissing) {
                info = this.createEClassifierInfo(typeRef, name);
            }
        }
        return info;
    }

    private EClassifierInfo createEClassifierInfo(TypeRef typeRef, String name) throws TransformationException {
        if (this.eClassifierInfos.getInfo(typeRef) != null) {
            throw new IllegalArgumentException("Cannot create EClass for same type twice " + typeRef.getClassifier().getName());
        }
        String classifierName = null;
        classifierName = GrammarUtil.getTypeRefName(typeRef);
        if (classifierName == null) {
            classifierName = name;
        }
        if (classifierName == null) {
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot reference unnamed type.", typeRef);
        }
        AbstractMetamodelDeclaration metaModel = typeRef.getMetamodel();
        if (metaModel == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create type for " + classifierName + " because its MetaModel is unknown.", typeRef);
        }
        EPackage generatedEPackage = this.getGeneratedEPackage(metaModel);
        if (generatedEPackage == null) {
            throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot create type '" + classifierName + "' in alias " + typeRef.getMetamodel().getAlias(), typeRef);
        }
        EClassifier classifier = generatedEPackage.getEClassifier(classifierName);
        if (classifier == null) {
            if (GrammarUtil.containingParserRule(typeRef) != null) {
                classifier = EcoreFactory.eINSTANCE.createEClass();
            } else if (GrammarUtil.containingEnumRule(typeRef) != null) {
                classifier = EcoreFactory.eINSTANCE.createEEnum();
            } else {
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot create datatype " + classifierName, typeRef);
            }
            classifier.setName(classifierName);
            generatedEPackage.getEClassifiers().add((Object)classifier);
            typeRef.setClassifier(classifier);
            EClassifierInfo result = classifier instanceof EClass ? EClassifierInfo.createEClassInfo((EClass)classifier, true, this.getGeneratedEPackageURIs(), GrammarUtil.getGrammar(typeRef)) : EClassifierInfo.createEDataTypeInfo((EDataType)classifier, true);
            if (!this.eClassifierInfos.addInfo(typeRef, result)) {
                throw new IllegalStateException("cannot add type for typeRef twice: '" + classifierName + "'");
            }
            SourceAdapter.adapt((EObject)classifier, typeRef);
            return result;
        }
        typeRef.setClassifier(classifier);
        SourceAdapter.adapt((EObject)classifier, typeRef);
        return this.eClassifierInfos.getInfo(classifier);
    }

    private void addGeneratedEPackage(GeneratedMetamodel generatedMetamodel) throws TransformationException {
        String alias = Strings.emptyIfNull((String)generatedMetamodel.getAlias());
        if (this.generatedEPackages.containsKey(alias)) {
            throw new TransformationException(TransformationErrorCode.AliasForMetamodelAlreadyExists, "alias '" + alias + "' already exists", generatedMetamodel);
        }
        if (generatedMetamodel.getEPackage() == null) {
            throw new TransformationException(TransformationErrorCode.UnknownMetaModelAlias, "Cannot create EPackage without NsURI.", generatedMetamodel);
        }
        EPackage generatedEPackage = generatedMetamodel.getEPackage();
        this.generatedEPackages.put(alias, generatedEPackage);
        this.collectClassInfosOf(generatedEPackage, generatedMetamodel);
    }

    private EPackage getGeneratedEPackage(AbstractMetamodelDeclaration metaModel) {
        if (metaModel instanceof GeneratedMetamodel) {
            return metaModel.getEPackage();
        }
        return null;
    }

    private void postProcessGeneratedPackages() {
        if (this.postProcessor != null) {
            Iterable generatedMetamodels = Iterables.filter(this.grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
            for (GeneratedMetamodel metamodel : generatedMetamodels) {
                this.postProcessor.process(metamodel);
            }
        }
    }

    public EClassifierInfos getEClassifierInfos() {
        return this.eClassifierInfos;
    }

    public static class NullErrorAcceptor
    implements ErrorAcceptor {
        public void acceptError(TransformationErrorCode errorCode, String arg0, EObject arg1) {
        }
    }
}

