/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.wizards;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.ide.wizards.FieldInitializerUtil;
import org.eclipse.xtend.ide.wizards.Messages;
import org.eclipse.xtend.ide.wizards.XtendClassUtil;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public class NewXtendClassWizardPage
extends NewTypeWizardPage {
    private IResource fResource;
    @Inject
    private FieldInitializerUtil util;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    private int size;

    public NewXtendClassWizardPage() {
        super(0, "Xtend Class");
        this.setTitle("Xtend Class");
        this.setDescription(Messages.XTEND_CLASS_WIZARD_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int cols = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = cols;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, cols);
        this.createPackageControls(composite, cols);
        this.createSeparator(composite, cols);
        this.createTypeNameControls(composite, cols);
        this.createSuperClassControls(composite, cols);
        this.createSuperInterfacesControls(composite, cols);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void init(IStructuredSelection selection) {
        IJavaElement elem = this.util.getSelectedResource(selection);
        this.initContainerPage(elem);
        this.initTypePage(elem);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public int createType() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        NewXtendClassWizardPage.this.createXtendClass(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ERROR_CREATING_CLASS, (String)realException.getMessage());
        }
        return this.size;
    }

    private void createXtendClass(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.getPackageFragment().exists()) {
            try {
                this.getPackageFragmentRoot().createPackageFragment(this.getPackageFragment().getElementName(), true, monitor);
            }
            catch (JavaModelException e) {
                this.displayError(Messages.ERROR_CREATING_PACKAGE, e.getMessage());
            }
        }
        IResource res = this.getPackageFragment().getResource();
        IFile xtendClass = ((IFolder)res).getFile(String.valueOf(this.getTypeName()) + ".xtend");
        try {
            URI uri = this.storage2UriMapper.getUri((IStorage)xtendClass);
            String contents = XtendClassUtil.create(this.getTypeName(), this.getPackageFragment(), this.getSuperClass(), this.getSuperInterfaces(), this.whitespaceInformationProvider.getIndentationInformation(uri).getIndentString(), this.whitespaceInformationProvider.getLineSeparatorInformation(uri).getLineSeparator(), monitor);
            this.size = contents.length();
            xtendClass.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, monitor);
            this.fResource = xtendClass;
        }
        catch (CoreException e) {
            this.displayError(Messages.ERROR_CREATING_CLASS, e.getMessage());
        }
    }

    private void displayError(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)NewXtendClassWizardPage.this.getShell(), (String)title, (String)message);
            }
        });
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    protected IStatus typeNameChanged() {
        IFolder folder;
        IResource resource;
        IPackageFragment packageFragment = this.getPackageFragment();
        if (packageFragment != null && (resource = packageFragment.getResource()) instanceof IFolder && (folder = (IFolder)resource).getFile(String.valueOf(this.getTypeName()) + ".xtend").exists()) {
            String packageName = "";
            if (!packageFragment.isDefaultPackage()) {
                packageName = String.valueOf(packageFragment.getElementName()) + ".";
            }
            return new StatusInfo(4, String.valueOf(Messages.TYPE_EXISTS_0) + packageName + this.getTypeName() + Messages.TYPE_EXISTS_1);
        }
        return super.typeNameChanged();
    }

    public IResource getResource() {
        return this.fResource;
    }
}

