/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.Test;

public class InternalBuilderTest {
    @Test
    public void test() throws CoreException, FileNotFoundException {
        this.reportMemoryState("Starting build.");
        try {
            this.clearJdtIndex();
            ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            this.clearJdtIndex();
            this.reportMemoryState("Finished build.");
        }
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ArrayList<String> errors = new ArrayList<String>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String msg = MarkerUtilities.getMessage((IMarker)marker);
            if (MarkerUtilities.getSeverity((IMarker)marker) == 2) {
                errors.add(String.valueOf(msg) + " in " + marker.getResource().getFullPath() + " line: " + MarkerUtilities.getLineNumber((IMarker)marker));
            }
            ++n2;
        }
        List<String> top10 = errors.size() > 10 ? IterableExtensions.toList((Iterable)IterableExtensions.take(errors, (int)10)) : errors;
        Assert.assertTrue((String)("Problems found (" + top10.size() + " of " + errors.size() + "): " + IterableExtensions.join(errors, (CharSequence)", ")), (boolean)errors.isEmpty());
    }

    private void clearJdtIndex() throws FileNotFoundException {
        File jdtMetadata = JavaCore.getPlugin().getStateLocation().toFile();
        boolean success = Files.sweepFolder((File)jdtMetadata);
        System.out.println("Clean up index " + jdtMetadata.getAbsolutePath() + ": " + (success ? "success" : "fail"));
    }

    private void reportMemoryState(String reportName) {
        System.out.println(String.valueOf(reportName) + " Memory max=" + Runtime.getRuntime().maxMemory() / 0x100000L + "m, total=" + Runtime.getRuntime().totalMemory() / 0x100000L + "m, free=" + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
    }
}

