/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionInExpressionFinder {
    @Inject
    private ITypeProvider typeProvider;

    public List<EObject> findChildrenThrowingException(EObject rootExpression, JvmTypeReference thrownException) {
        final ArrayList result = Lists.newArrayList();
        this.findChildrenThrowingException(rootExpression, thrownException, new IAcceptor<EObject>(){

            public void accept(EObject t) {
                result.add(t);
            }
        });
        return result;
    }

    protected void findChildrenThrowingException(EObject rootExpression, JvmTypeReference thrownException, IAcceptor<EObject> acceptor) {
        boolean exceptionSeenInChildren = false;
        for (EObject element : rootExpression.eContents()) {
            if (element instanceof XExpression) {
                if (!Iterables.contains(this.typeProvider.getThrownExceptionTypes((XExpression)element), (Object)thrownException)) continue;
                exceptionSeenInChildren = true;
                this.findChildrenThrowingException(element, thrownException, acceptor);
                continue;
            }
            if (!(element instanceof JvmIdentifiableElement) || !Iterables.contains(this.typeProvider.getThrownExceptionForIdentifiable((JvmIdentifiableElement)element), (Object)thrownException)) continue;
            exceptionSeenInChildren = true;
            this.findChildrenThrowingException(element, thrownException, acceptor);
        }
        if (!exceptionSeenInChildren) {
            acceptor.accept((Object)rootExpression);
        }
    }
}

