/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.imports.TypeUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUsages {
    private Multimap<String, JvmDeclaredType> simpleName2types = LinkedHashMultimap.create();
    private Multimap<JvmDeclaredType, TypeUsage> types2usages = LinkedHashMultimap.create();
    private List<JvmDeclaredType> staticImports = Lists.newArrayList();
    private List<JvmDeclaredType> extensionImports = Lists.newArrayList();
    private List<TypeUsage> unresolvedTypes = Lists.newArrayList();

    public void addTypeUsage(JvmDeclaredType typeToImport, JvmDeclaredType usedType, ITextRegion textRegion, JvmMember context) {
        this.simpleName2types.put((Object)typeToImport.getSimpleName(), (Object)typeToImport);
        this.types2usages.put((Object)typeToImport, (Object)new TypeUsage(usedType, textRegion, context));
    }

    public void addTypeUsage(JvmDeclaredType typeToImport, String suffix, ITextRegion textRegion, JvmMember context) {
        this.simpleName2types.put((Object)typeToImport.getSimpleName(), (Object)typeToImport);
        this.types2usages.put((Object)typeToImport, (Object)new TypeUsage(typeToImport, suffix, textRegion, context));
    }

    public void addUnresolved(String unresolvedTypeName, String suffix, ITextRegion textRegion, JvmMember context) {
        this.unresolvedTypes.add(new TypeUsage(unresolvedTypeName, suffix, textRegion, context));
    }

    public Multimap<String, JvmDeclaredType> getSimpleName2Types() {
        return this.simpleName2types;
    }

    public Iterable<TypeUsage> getUsages(JvmDeclaredType type) {
        return this.types2usages.get((Object)type);
    }

    public List<TypeUsage> getUnresolvedTypeUsages() {
        return this.unresolvedTypes;
    }

    public void addStaticImport(JvmDeclaredType declarator) {
        this.staticImports.add(declarator);
    }

    public void addExtensionImport(JvmDeclaredType declarator) {
        this.extensionImports.add(declarator);
    }

    public List<JvmDeclaredType> getStaticImports() {
        return this.staticImports;
    }

    public List<JvmDeclaredType> getExtensionImports() {
        return this.extensionImports;
    }
}

