/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.lang.reflect.Field;

public final class ConformanceFlags {
    public static final int NONE = 0;
    public static final int RAW_TYPE = 1;
    public static final int SUCCESS = 512;
    public static final int DEMAND_CONVERSION = 1024;
    public static final int SUBTYPE = 2048;
    public static final int PRIMITIVE_WIDENING = 4096;
    public static final int UNBOXING = 8192;
    public static final int BOXING = 16384;
    public static final int RAW_TYPE_CONVERSION = 32768;
    public static final int SYNONYM = 65536;
    public static final int UNKNOWN_TYPE_PARTICIPATED = 131072;
    public static final int INCOMPATIBLE = 262144;
    public static final int VAR_ARG = 524288;
    public static final int CHECKED = 0x100000;
    public static final int SEALED = 0x200000;
    public static final int UNCHECKED = 0x400000;
    public static final int LAMBDA_RAW_COMPATIBLE = 0x800000;
    public static final int LAMBDA_PARAMETER_COMPATIBLE = 0x1000000;
    public static final int MERGED = 0x2000000;
    public static final int NO_IMPLICIT_RETURN = 0x4000000;
    public static final int EXPLICIT_VOID_RETURN = 0x8000000;
    public static final int PROPAGATED_TYPE = 0x10000000;
    public static final int THROWN_EXCEPTION = 0x20000000;
    public static final int PREFERRED_LAMBDA_SUGAR = 0x40000000;
    public static final int LAMBDA_VOID_COMPATIBLE = Integer.MIN_VALUE;
    public static final int CHECKED_SUCCESS = 0x100200;
    private static final int SUCCESS_OR_LAMBDA = 25166336;
    public static final int CHECK_RESULTS = 25428480;

    private ConformanceFlags() {
        throw new AssertionError();
    }

    public static int compareFlags(int left, int right) {
        if (left == right) {
            return 0;
        }
        int leftSuccess = left & 0x1800200;
        int rightSuccess = right & 0x1800200;
        if (leftSuccess != rightSuccess) {
            if (leftSuccess == 0) {
                return 1;
            }
            if (rightSuccess == 0) {
                return -1;
            }
            if (leftSuccess < rightSuccess) {
                return -1;
            }
            return 1;
        }
        if ((left & 0x10000) != (right & 0x10000)) {
            if ((left & 0x10000) != 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static String toString(int flags) {
        Field[] fields = ConformanceFlags.class.getFields();
        try {
            StringBuilder result = new StringBuilder("[");
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                int fieldValue = f.getInt(null);
                if (Integer.bitCount(fieldValue) == 1 && (fieldValue & flags) != 0) {
                    if (result.length() != 1) {
                        result.append(", ");
                    }
                    result.append(f.getName());
                }
                ++n2;
            }
            result.append("]");
            return result.toString();
        }
        catch (Exception e) {
            return Integer.toString(flags);
        }
    }

    public static boolean sanityCheck(int flags) {
        ConformanceFlags.doCheck(flags, 0x500000);
        if ((flags & 0x400000) == 0) {
            ConformanceFlags.doCheck(flags, 25428480);
        } else if ((flags & 0x1A40200) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + ConformanceFlags.toString(flags));
        }
        return true;
    }

    private static void doCheck(int flags, int bits) {
        if ((flags & bits) == 0) {
            throw new IllegalArgumentException("Invalid flags: " + ConformanceFlags.toString(flags));
        }
        if (Integer.bitCount(flags & bits) != 1) {
            throw new IllegalArgumentException("Invalid flags: " + ConformanceFlags.toString(flags));
        }
    }
}

