/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.ui.operations.AbstractProvisioningOperation;
import org.eclipse.epp.internal.mpc.ui.operations.FeatureDescriptor;
import org.eclipse.epp.internal.mpc.ui.operations.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;

public class ResolveFeatureNamesOperation
extends AbstractProvisioningOperation {
    private final Set<FeatureDescriptor> featureDescriptors = new HashSet<FeatureDescriptor>();
    private final Set<FeatureDescriptor> unresolvedFeatureDescriptors = new HashSet<FeatureDescriptor>();

    public ResolveFeatureNamesOperation(List<CatalogItem> installableConnectors) {
        super(installableConnectors);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.ResolveFeatureNamesOperation_resolvingFeatures, (int)100);
            try {
                List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
                List<IInstallableUnit> installableUnits = this.queryInstallableUnits(monitor.newChild(50), repositories);
                HashSet<String> resolvedFeatureIds = new HashSet<String>();
                for (IInstallableUnit iu : installableUnits) {
                    FeatureDescriptor descriptor = new FeatureDescriptor(iu);
                    resolvedFeatureIds.add(descriptor.getId());
                    resolvedFeatureIds.add(descriptor.getSimpleId());
                    this.featureDescriptors.add(descriptor);
                }
                for (CatalogItem catalogItem : this.items) {
                    for (String iu : catalogItem.getInstallableUnits()) {
                        if (resolvedFeatureIds.contains(iu)) continue;
                        FeatureDescriptor descriptor = new FeatureDescriptor(iu);
                        this.unresolvedFeatureDescriptors.add(descriptor);
                    }
                }
            }
            finally {
                this.removeAddedRepositoryLocations();
                monitor.done();
            }
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String getProperty(IInstallableUnit candidate, String key) {
        String value = TranslationSupport.getInstance().getIUProperty(candidate, key);
        return value != null ? value : "";
    }

    public Set<FeatureDescriptor> getFeatureDescriptors() {
        return this.featureDescriptors;
    }

    public Set<FeatureDescriptor> getUnresolvedFeatureDescriptors() {
        return this.unresolvedFeatureDescriptors;
    }
}

